/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.protocol;

import java.util.List;
import oracle.security.xmlsec.saml2.protocol.RequestAbstract;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AssertionIDRequest
extends RequestAbstract {
    public AssertionIDRequest(Element element) throws DOMException {
        super(element);
    }

    public AssertionIDRequest(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AssertionIDRequest(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:protocol", "AssertionIDRequest");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:protocol");
    }

    public void addAssertionIDRef(String id) {
        Document doc = this.getOwnerDocument();
        Element idRef = doc.createElementNS("urn:oasis:names:tc:SAML:2.0:assertion", "AssertionIDRef");
        idRef.appendChild(doc.createTextNode(id));
        String prefix = XMLElement.getDefaultNSPrefix((String)"urn:oasis:names:tc:SAML:2.0:assertion");
        String nsAttr = "xmlns";
        if (prefix != null) {
            idRef.setPrefix(prefix);
            nsAttr = nsAttr + ":" + prefix;
        }
        idRef.setAttributeNS("http://www.w3.org/2000/xmlns/", nsAttr, "urn:oasis:names:tc:SAML:2.0:assertion");
        this.appendChild(idRef);
    }

    public List getAssertionIDRefs() {
        return SAML2Utils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AssertionIDRef");
    }
}

