/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.profiles.attribute.dce;

import oracle.security.xmlsec.saml2.core.Attribute;
import oracle.security.xmlsec.saml2.util.SAML2URI;
import oracle.security.xmlsec.util.XMLElement;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class DCEGroupsAttribute
extends Attribute {
    public DCEGroupsAttribute(Element element) throws DOMException {
        super(element);
    }

    public DCEGroupsAttribute(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public DCEGroupsAttribute(Document owner) throws DOMException {
        super(owner);
        this.setNameFormat("urn:oasis:names:tc:SAML:2.0:attrname-format:uri");
        this.setName("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE:groups");
    }

    public void addAttributeValue(String uuidValue, String realm, String friendlyName) {
        Element av = this.addAttributeValue(this.getOwnerDocument().createTextNode(uuidValue), SAML2URI.encoding_xsitype_dceValueType);
        if (realm != null || friendlyName != null) {
            String prefix = XMLElement.getDefaultNSPrefix((String)"urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE");
            if (prefix == null || prefix.length() == 0) {
                prefix = "dceprof";
            }
            this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:" + prefix, "urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE");
            if (realm != null) {
                av.setAttributeNS("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE", prefix + ":Realm", realm);
            }
            if (friendlyName != null) {
                av.setAttributeNS("urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE", prefix + ":FriendlyName", friendlyName);
            }
        }
    }

    @Override
    public String[] getAttributeValueStrings() {
        return this.getAttributeValuesAsStrings(SAML2URI.encoding_xsitype_dceValueType, true);
    }

    @Override
    public String getAttributeProfileID() {
        return "urn:oasis:names:tc:SAML:2.0:profiles:attribute:DCE";
    }
}

