/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.Iterator;
import java.util.List;
import oracle.security.xmlsec.saml2.core.Attribute;
import oracle.security.xmlsec.saml2.profiles.attribute.GenericAttribute;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.Attr;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class RequestedAttribute
extends XMLElement {
    public RequestedAttribute(Element element) throws DOMException {
        super(element);
    }

    public RequestedAttribute(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public RequestedAttribute(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "RequestedAttribute");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void setIsRequired(boolean required) {
        this.setAttribute("isRequired", String.valueOf(required));
    }

    public boolean getIsRequired() {
        String str;
        return this.hasAttribute("isRequired") && ("true".equals(str = this.getAttribute("isRequired")) || "1".equals(str));
    }

    public void setSAMLAttribute(Attribute attr) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"AttributeValue");
        Document thisDoc = this.getOwnerDocument();
        boolean importNodes = thisDoc != attr.getOwnerDocument();
        NamedNodeMap xmlAttrs = attr.getAttributes();
        int len = xmlAttrs.getLength();
        for (int i = 0; i < len; ++i) {
            Attr xmlAttr = (Attr)xmlAttrs.item(i);
            if (importNodes) {
                xmlAttr = (Attr)thisDoc.importNode(xmlAttr, true);
            }
            if (xmlAttr.getPrefix() != null) {
                this.setAttributeNodeNS((Attr)xmlAttr.cloneNode(true));
                continue;
            }
            this.setAttributeNode((Attr)xmlAttr.cloneNode(true));
        }
        List values = attr.getAttributeValues();
        for (Node value : values) {
            if (importNodes) {
                value = thisDoc.importNode(value, true);
            }
            this.appendChild(value.cloneNode(true));
        }
    }

    public Attribute getSAMLAttribute() {
        Document thisDoc = this.getOwnerDocument();
        GenericAttribute attr = new GenericAttribute(thisDoc);
        boolean hasContent = false;
        NamedNodeMap xmlAttrs = this.getAttributes();
        int len = xmlAttrs.getLength();
        for (int i = 0; i < len; ++i) {
            Attr xmlAttr = (Attr)xmlAttrs.item(i);
            String attrName = xmlAttr.getName();
            if ("isRequired".equals(attrName) || attrName.startsWith("xsi:") || attrName.startsWith("xml:") || attrName.startsWith("xmlns")) continue;
            hasContent = true;
            if (xmlAttr.getPrefix() != null) {
                attr.setAttributeNodeNS((Attr)xmlAttr.cloneNode(true));
                continue;
            }
            attr.setAttributeNode((Attr)xmlAttr.cloneNode(true));
        }
        List values = SAML2Utils.getChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AttributeValue");
        if (values != null) {
            hasContent = true;
            Iterator it = values.iterator();
            while (it.hasNext()) {
                attr.appendChild(((Node)it.next()).cloneNode(true));
            }
        }
        if (hasContent) {
            return (Attribute)SAML2Utils.getInstance((Element)attr.getNode(), null, null);
        }
        return null;
    }

    static {
        SAML2Initializer.initialize();
    }
}

