/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import oracle.security.xmlsec.saml2.metadata.Extensions;
import oracle.security.xmlsec.saml2.metadata.OrganizationDisplayName;
import oracle.security.xmlsec.saml2.metadata.OrganizationName;
import oracle.security.xmlsec.saml2.metadata.OrganizationURL;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Organization
extends XMLElement {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata"};
    private static final String[] tagList = new String[]{"Extensions", "OrganizationName", "OrganizationDisplayName", "OrganizationURL"};

    public Organization(Element element) throws DOMException {
        super(element);
    }

    public Organization(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Organization(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "Organization");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:metadata");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    protected Organization(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:metadata");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void setExtensions(Extensions extension) {
        SAML2Utils.setChildElement(this, extension, nsList, tagList);
    }

    public Extensions getExtensions() {
        return (Extensions)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "Extensions");
    }

    public void addOrganizationName(OrganizationName name) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)name, (String[])nsList, (String[])tagList);
    }

    public List getOrganizationNames() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "OrganizationName");
    }

    public void addOrganizationDisplayName(OrganizationDisplayName name) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)name, (String[])nsList, (String[])tagList);
    }

    public List getOrganizationDisplayNames() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "OrganizationDisplayName");
    }

    public void addOrganizationURL(OrganizationURL uri) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)uri, (String[])nsList, (String[])tagList);
    }

    public List getOrganizationURLs() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "OrganizationURL");
    }

    public void setAttributeNS(String namespaceURI, String qualifiedName, String value) {
        ((Element)this.getNode()).setAttributeNS(namespaceURI, qualifiedName, value);
    }

    public String getAttributeNS(String namespaceURI, String localName) {
        return ((Element)this.getNode()).getAttributeNS(namespaceURI, localName);
    }

    static {
        SAML2Initializer.initialize();
    }
}

