/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.saml2.metadata.EncryptionMethod;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class KeyDescriptor
extends XMLElement {
    private static final String[] tagList = new String[]{"KeyInfo", "EncryptionMethod"};
    private static final String[] nsList = new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata"};

    public KeyDescriptor(Element element) throws DOMException {
        super(element);
    }

    public KeyDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public KeyDescriptor(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "KeyDescriptor");
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:metadata");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    protected KeyDescriptor(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        this.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns", "urn:oasis:names:tc:SAML:2.0:metadata");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void setUse(KeyType use) {
        this.setAttribute("use", use.getValue());
    }

    public KeyType getUse() {
        if (this.hasAttribute("use")) {
            return new KeyType(this.getAttribute("use"));
        }
        return null;
    }

    public void setKeyInfo(XSKeyInfo ki) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"KeyInfo");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)ki, (String[])nsList, (String[])tagList);
    }

    public XSKeyInfo getKeyInfo() {
        return (XSKeyInfo)SAML2Utils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
    }

    public void addEncryptionMethod(EncryptionMethod encMethod) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)encMethod, (String[])nsList, (String[])tagList);
    }

    public List getEncryptionMethods() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "EncryptionMethod");
    }

    static {
        SAML2Initializer.initialize();
    }

    public static class KeyType {
        public static final KeyType ENCRYPTION = new KeyType("encryption");
        public static final KeyType SIGNING = new KeyType("signing");
        private String value;

        public KeyType(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return "KeyType=" + this.value;
        }

        public int hashCode() {
            return this.value.hashCode();
        }

        public boolean equals(Object o) {
            if (o.getClass().getName().equals(KeyType.class.getName())) {
                return this.getValue().equals(((KeyType)o).getValue());
            }
            return false;
        }
    }
}

