/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import oracle.security.xmlsec.saml2.core.Attribute;
import oracle.security.xmlsec.saml2.metadata.AssertionIDRequestService;
import oracle.security.xmlsec.saml2.metadata.AttributeProfile;
import oracle.security.xmlsec.saml2.metadata.NameIDMappingService;
import oracle.security.xmlsec.saml2.metadata.SSODescriptor;
import oracle.security.xmlsec.saml2.metadata.SingleSignOnService;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class IDPSSODescriptor
extends SSODescriptor {
    private static final String[] tagList = new String[]{"Signature", "Extensions", "KeyDescriptor", "Organization", "ContactPerson", "ArtifactResolutionService", "SingleLogoutService", "ManageNameIDService", "NameIDFormat", "SingleSignOnService", "NameIDMappingService", "AssertionIDRequestService", "AttributeProfile", "Attribute"};
    private static final String[] nsList = new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:assertion"};

    public IDPSSODescriptor(Element element) throws DOMException {
        super(element);
    }

    public IDPSSODescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public IDPSSODescriptor(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void setWantAssertionsSigned(boolean signed) {
        this.setAttribute("WantAssertionsSigned", String.valueOf(signed));
    }

    public boolean getWantAssertionsSigned() {
        String str;
        return this.hasAttribute("WantAssertionsSigned") && ("true".equals(str = this.getAttribute("WantAssertionsSigned")) || "1".equals(str));
    }

    public void addSingleSignOnService(SingleSignOnService sso) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)sso, (String[])nsList, (String[])tagList);
    }

    public List getSingleSignOnServices() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "SingleSignOnService");
    }

    public void addNameIDMappingService(NameIDMappingService nms) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)nms, (String[])nsList, (String[])tagList);
    }

    public List getNameIDMappingServices() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "NameIDMappingService");
    }

    public void addAssertionIDRequestService(AssertionIDRequestService nms) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)nms, (String[])nsList, (String[])tagList);
    }

    public List getAssertionIDRequestServices() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AssertionIDRequestService");
    }

    public void addAttributeProfile(AttributeProfile ap) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)ap, (String[])nsList, (String[])tagList);
    }

    public List getAttributeProfiles() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AttributeProfile");
    }

    public void addSAMLAttribute(Attribute attr) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)attr, (String[])nsList, (String[])tagList);
    }

    public List getSAMLAttributes() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Attribute");
    }
}

