/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import oracle.security.crypto.util.InvalidInputException;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class EntityID
extends XMLElement {
    public EntityID(Element element) throws DOMException {
        super(element);
    }

    public EntityID(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    protected EntityID(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    public void setURI(String uri) throws InvalidInputException {
        if (uri.length() > 1024) {
            throw new InvalidInputException("URI can not exceed 1024 characters");
        }
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"*", (String)"*");
        this.appendChild(this.getOwnerDocument().createTextNode(uri));
    }

    public String getURI() {
        return XMLUtils.collectText((Node)this.getNode());
    }

    static {
        SAML2Initializer.initialize();
    }
}

