/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.metadata;

import java.util.List;
import oracle.security.xmlsec.saml2.metadata.AdditionalMetadataLocation;
import oracle.security.xmlsec.saml2.metadata.AffiliationDescriptor;
import oracle.security.xmlsec.saml2.metadata.ContactPerson;
import oracle.security.xmlsec.saml2.metadata.Descriptor;
import oracle.security.xmlsec.saml2.metadata.EntityID;
import oracle.security.xmlsec.saml2.metadata.Organization;
import oracle.security.xmlsec.saml2.metadata.RoleDescriptor;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EntityDescriptor
extends Descriptor {
    private static final String[] tagList = new String[]{"Signature", "Extensions", "RoleDescriptor", "IDPSSODescriptor", "SPSSODescriptor", "AuthnAuthorityDescriptor", "AttributeAuthorityDescriptor", "PDPDescriptor", "AffiliationDescriptor", "Organization", "ContactPerson", "AdditionalMetadataLocation"};
    private static final String[] nsList = new String[]{"http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata", "urn:oasis:names:tc:SAML:2.0:metadata"};

    public EntityDescriptor(Element element) throws DOMException {
        super(element);
    }

    public EntityDescriptor(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public EntityDescriptor(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:metadata");
    }

    protected EntityDescriptor(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public void addRoleDescriptor(RoleDescriptor rd) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"AffiliationDescriptor");
        XMLElement before = SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "Organization");
        if (before == null) {
            before = SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson");
        }
        if (before == null) {
            before = SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AdditionalMetadataLocation");
        }
        if (before == null) {
            this.appendChild(rd.getNode());
        } else {
            this.insertBefore(rd.getNode(), before.getNode());
        }
    }

    public List getRoleDescriptors() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor");
    }

    public List getIDPSSODescriptors() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor");
    }

    public List getSPSSODescriptors() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "SPSSODescriptor");
    }

    public List getAuthnAuthorityDescriptors() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AuthnAuthorityDescriptor");
    }

    public List getAttributeAuthorityDescriptors() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AttributeAuthorityDescriptor");
    }

    public List getPDPDescriptors() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "PDPDescriptor");
    }

    public void setAffiliationDescriptor(AffiliationDescriptor ad) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"RoleDescriptor");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"IDPSSODescriptor");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"SPSSODescriptor");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"AuthnAuthorityDescriptor");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"AttributeAuthorityDescriptor");
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"PDPDescriptor");
        XMLElement before = SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "Organization");
        if (before == null) {
            before = SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson");
        }
        if (before == null) {
            before = SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AdditionalMetadataLocation");
        }
        if (before == null) {
            this.appendChild(ad.getNode());
        } else {
            this.insertBefore(ad.getNode(), before.getNode());
        }
    }

    public AffiliationDescriptor getAffiliationDescriptor() {
        return (AffiliationDescriptor)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AffiliationDescriptor");
    }

    public void setOrganization(Organization org) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:metadata", (String)"Organization");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)org, (String[])nsList, (String[])tagList);
    }

    public Organization getOrganization() {
        return (Organization)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:metadata", "Organization");
    }

    public void addContactPerson(ContactPerson cp) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)cp, (String[])nsList, (String[])tagList);
    }

    public List getContactPersons() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson");
    }

    public void addAdditionalMetadataLocation(AdditionalMetadataLocation aml) {
        XMLUtils.insertChild((XMLElement)this, (XMLElement)aml, (String[])nsList, (String[])tagList);
    }

    public List getAdditionalMetadataLocations() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:metadata", "AdditionalMetadataLocation");
    }

    public void setEntityID(EntityID entity) {
        this.setAttribute("entityID", entity.getURI());
    }

    public String getEntityID() {
        if (this.hasAttribute("entityID")) {
            return this.getAttribute("entityID");
        }
        return null;
    }
}

