/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.util.List;
import oracle.security.xmlsec.saml2.core.Assertion;
import oracle.security.xmlsec.saml2.core.EncryptedAssertion;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLNode;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Evidence
extends XMLElement {
    public Evidence(Element element) throws DOMException {
        super(element);
    }

    public Evidence(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Evidence(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "Evidence");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    public void addAssertionIDReference(String id) {
        SAML2Utils.appendChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AssertionIDReference", id);
    }

    public List getAssertionIDReferences() {
        return SAML2Utils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AssertionIDReference");
    }

    public void addAssertionURIReference(String uri) {
        SAML2Utils.appendChildElementWithText(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AssertionURIReference", uri);
    }

    public List getAssertionURIReferences() {
        return SAML2Utils.collectTextFromChildren(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AssertionURIReference");
    }

    public void addAssertion(Assertion assertion) {
        this.appendChild((XMLNode)assertion);
    }

    public List getAssertions() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
    }

    public void addEncryptedAssertion(EncryptedAssertion assertion) {
        this.appendChild((XMLNode)assertion);
    }

    public List getEncryptedAssertions() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "EncryptedAssertion");
    }

    static {
        SAML2Initializer.initialize();
    }
}

