/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.util.Date;
import oracle.security.xmlsec.saml2.core.AuthnContext;
import oracle.security.xmlsec.saml2.core.Statement;
import oracle.security.xmlsec.saml2.core.SubjectLocality;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AuthnStatement
extends Statement {
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion"};
    private static final String[] tagList = new String[]{"SubjectLocality", "AuthnContext"};

    public AuthnStatement(Element element) throws DOMException {
        super(element);
    }

    public AuthnStatement(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public AuthnStatement(Document owner) throws DOMException {
        super(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    protected AuthnStatement(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
    }

    public void setSessionIndex(String index) {
        this.setAttribute("SessionIndex", index);
    }

    public String getSessionIndex() {
        if (this.hasAttribute("SessionIndex")) {
            return this.getAttribute("SessionIndex");
        }
        return null;
    }

    public void setAuthnInstant(Date authenticationInstant) {
        this.setAttribute("AuthnInstant", XMLUtils.formatDateTime((Date)authenticationInstant));
    }

    public Date getAuthnInstant() {
        if (this.hasAttribute("AuthnInstant")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("AuthnInstant"));
        }
        return null;
    }

    public void setSessionNotOnOrAfter(Date notOnOrAfter) {
        this.setAttribute("SessionNotOnOrAfter", XMLUtils.formatDateTime((Date)notOnOrAfter));
    }

    public Date getSessionNotOnOrAfter() {
        if (this.hasAttribute("SessionNotOnOrAfter")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("SessionNotOnOrAfter"));
        }
        return null;
    }

    public void setSubjectLocality(SubjectLocality subjectLocality) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"SubjectLocality");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)subjectLocality, (String[])nsList, (String[])tagList);
    }

    public SubjectLocality getSubjectLocality() {
        return (SubjectLocality)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "SubjectLocality");
    }

    public void setAuthnContext(AuthnContext authnCtx) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"AuthnContext");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)authnCtx, (String[])nsList, (String[])tagList);
    }

    public AuthnContext getAuthnContext() {
        return (AuthnContext)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContext");
    }

    static {
        SAML2Initializer.initialize();
    }
}

