/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.saml2.core;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.X509Certificate;
import java.util.Date;
import java.util.List;
import oracle.security.xmlsec.dsig.SigningException;
import oracle.security.xmlsec.dsig.VerifyException;
import oracle.security.xmlsec.dsig.XSKeyInfo;
import oracle.security.xmlsec.dsig.XSSignature;
import oracle.security.xmlsec.saml2.core.Advice;
import oracle.security.xmlsec.saml2.core.Conditions;
import oracle.security.xmlsec.saml2.core.Issuer;
import oracle.security.xmlsec.saml2.core.NameID;
import oracle.security.xmlsec.saml2.core.Statement;
import oracle.security.xmlsec.saml2.core.Subject;
import oracle.security.xmlsec.saml2.util.SAML2Initializer;
import oracle.security.xmlsec.saml2.util.SAML2Utils;
import oracle.security.xmlsec.transform.TransformationException;
import oracle.security.xmlsec.util.XMLElement;
import oracle.security.xmlsec.util.XMLUtils;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class Assertion
extends XMLElement {
    protected static String VERSION = "2.0";
    private static final String[] nsList = new String[]{"urn:oasis:names:tc:SAML:2.0:assertion", "http://www.w3.org/2000/09/xmldsig#", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion", "urn:oasis:names:tc:SAML:2.0:assertion"};
    private static final String[] tagList = new String[]{"Issuer", "Signature", "Subject", "Conditions", "Advice", "Statement", "AuthnStatement", "AuthzDecisionStatement", "AttributeStatement"};

    public Assertion(Element element) throws DOMException {
        super(element);
    }

    public Assertion(Element element, String systemId) throws DOMException {
        super(element, systemId);
    }

    public Assertion(Document owner) throws DOMException {
        this(owner, "urn:oasis:names:tc:SAML:2.0:assertion", "Assertion");
        this.addNSPrefixAttrDefault("urn:oasis:names:tc:SAML:2.0:assertion");
    }

    protected Assertion(Document owner, String nsURI, String localName) throws DOMException {
        super(owner, nsURI, localName);
        this.setVersion(VERSION);
    }

    public void setVersion(String ver) {
        this.setAttribute("Version", ver);
    }

    public String getVersion() {
        if (this.hasAttribute("Version")) {
            return this.getAttribute("Version");
        }
        return null;
    }

    public void setID(String assertionID) {
        this.setAttribute("ID", assertionID);
    }

    public String getID() {
        if (this.hasAttribute("ID")) {
            return this.getAttribute("ID");
        }
        return null;
    }

    public void setIssueInstant(Date issueInstant) {
        this.setAttribute("IssueInstant", XMLUtils.formatDateTime((Date)issueInstant));
    }

    public Date getIssueInstant() {
        if (this.hasAttribute("IssueInstant")) {
            return XMLUtils.parseDateTime((String)this.getAttribute("IssueInstant"));
        }
        return null;
    }

    public void setIssuer(NameID issuer) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"Issuer");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)issuer, (String[])nsList, (String[])tagList);
    }

    public Issuer getIssuer() {
        return (Issuer)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Issuer");
    }

    public void setSubject(Subject subject) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"Subject");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)subject, (String[])nsList, (String[])tagList);
    }

    public Subject getSubject() {
        return (Subject)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Subject");
    }

    public void setConditions(Conditions conditions) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"Conditions");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)conditions, (String[])nsList, (String[])tagList);
    }

    public Conditions getConditions() {
        return (Conditions)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Conditions");
    }

    public void setAdvice(Advice advice) {
        XMLUtils.removeChildren((Element)((Element)this.getNode()), (String)"urn:oasis:names:tc:SAML:2.0:assertion", (String)"Advice");
        XMLUtils.insertChild((XMLElement)this, (XMLElement)advice, (String[])nsList, (String[])tagList);
    }

    public Advice getAdvice() {
        return (Advice)SAML2Utils.getChildElement(this, "urn:oasis:names:tc:SAML:2.0:assertion", "Advice");
    }

    public void addStatement(Statement statement) {
        this.appendChild(statement.getNode());
    }

    public List getAuthnStatements() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AuthnStatement");
    }

    public List getAuthzDecisionStatements() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AuthzDecisionStatement");
    }

    public List getAttributeStatements() {
        return SAML2Utils.getChildElements(this, "urn:oasis:names:tc:SAML:2.0:assertion", "AttributeStatement");
    }

    public XSSignature getSignature() {
        return (XSSignature)SAML2Utils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "Signature");
    }

    public boolean isSigned() {
        return SAML2Utils.getChildElement(this, "http://www.w3.org/2000/09/xmldsig#", "Signature") != null;
    }

    public void sign(PrivateKey privateKey, X509Certificate cert) throws SigningException {
        this.sign(privateKey, cert, "http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    public void sign(String signatureMethod, PrivateKey privateKey, X509Certificate cert) throws SigningException {
        String digestMethod = "http://www.w3.org/2000/09/xmldsig#sha1";
        if (signatureMethod == "http://www.w3.org/2001/04/xmldsig-more#rsa-sha256") {
            digestMethod = "http://www.w3.org/2001/04/xmlenc#sha256";
        }
        this.sign(signatureMethod, digestMethod, privateKey, cert, "http://www.w3.org/2001/10/xml-exc-c14n#");
    }

    public void sign(PrivateKey privateKey, X509Certificate cert, String c14nMethod) throws SigningException {
        try {
            String keyAlgorithm = privateKey.getAlgorithm();
            String signatureMethod = null;
            if ("RSA".equals(keyAlgorithm)) {
                signatureMethod = "http://www.w3.org/2000/09/xmldsig#rsa-sha1";
            } else if ("DSA".equals(keyAlgorithm)) {
                signatureMethod = "http://www.w3.org/2000/09/xmldsig#dsa-sha1";
            } else {
                throw new SigningException("Unsupported key algorithm.");
            }
            XSSignature sig = this.addSignature(signatureMethod, c14nMethod);
            if (cert != null) {
                XSKeyInfo ki = sig.createKeyInfo();
                ki.addKeyInfoData((XMLElement)ki.createX509Data(cert));
                sig.setKeyInfo(ki);
            }
            sig.sign(privateKey, null);
        }
        catch (TransformationException ex) {
            throw new SigningException(ex.toString());
        }
    }

    public void sign(String signatureMethod, String digestMethod, PrivateKey privateKey, X509Certificate cert, String c14nMethod) throws SigningException {
        try {
            XSSignature sig = this.addSignature(signatureMethod, c14nMethod, digestMethod);
            if (cert != null) {
                XSKeyInfo ki = sig.createKeyInfo();
                ki.addKeyInfoData((XMLElement)ki.createX509Data(cert));
                sig.setKeyInfo(ki);
            }
            sig.sign(privateKey, null);
        }
        catch (TransformationException ex) {
            throw new SigningException(ex.toString());
        }
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod) {
        return this.addSignature(signatureMethod, c14nMethod, "http://www.w3.org/2000/09/xmldsig#sha1");
    }

    public XSSignature addSignature(String signatureMethod, String c14nMethod, String digestMethod) {
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
        XSSignature sig = SAML2Utils.createSignature(this, this.getID(), signatureMethod, c14nMethod, digestMethod);
        XMLUtils.insertChild((XMLElement)this, (XMLElement)sig, (String[])nsList, (String[])tagList);
        return sig;
    }

    public boolean verify() throws VerifyException {
        return this.verify(null);
    }

    public boolean verify(PublicKey publicKey) throws VerifyException {
        XSSignature sig = this.getSignature();
        if (sig == null) {
            throw new VerifyException("The message is not signed");
        }
        if (publicKey != null) {
            return sig.verify(publicKey, true);
        }
        return sig.verify(true);
    }

    protected void clearSignature() {
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"http://www.w3.org/2000/09/xmldsig#", (String)"Signature");
    }

    static {
        SAML2Initializer.initialize();
    }
}

