/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.validation;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.repository.OPatchAutoRHPRepository;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationFailureReason;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidationResult;
import com.oracle.glcm.patch.auto.rhp.validation.RHPValidator;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.opatch.opatchsdk.OPatchContext;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchTarget;

public class RHPPatchvalidator
implements RHPValidator {
    Logger _logger = Logger.getLogger(RHPPatchvalidator.class.getName());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RHPValidationResult validate(OPatchAutoRHPOptions options) {
        RHPValidationResult result = null;
        boolean isCreateImage = false;
        String oracleHome = null;
        String invPtrLocation = null;
        String patchLocation = null;
        boolean isDirectory = false;
        try {
            isCreateImage = options.getOption("create.image").isSwitchEnabled();
            invPtrLocation = options.getOption("inventory.pointer.location").getValue();
            OPatchAutoOption patchBasedir = options.getOption("patch.base.directory");
            if (patchBasedir.hasValue()) {
                patchLocation = patchBasedir.getValue();
                isDirectory = true;
            } else {
                patchLocation = options.getOption("patch.location").getValue();
            }
        }
        catch (OPatchAutoException e) {
            this._logger.finest("opatchauto exception=" + e.getLocalizedMessage());
        }
        if (isCreateImage) {
            if (StringUtil.isNullOrEmpty(patchLocation)) {
                result = new RHPValidationResult(RHPValidator.ValidatorID.PATCH_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.INVALID_PATCH_LOCATION, new Object[0]);
                return result;
            }
            oracleHome = System.getProperty("OPatch.ORACLE_HOME");
            try {
                OPatchContext.destroyContextReference();
                OPatchContext context = OPatchContext.getInstance((String)oracleHome, (String)invPtrLocation);
                context.setCustomScratchWorkingdirectory(RHPPatchvalidator.getCustomLogDirForCore(oracleHome));
                OPatchTarget target = new OPatchTarget(context);
                List<String> patchList = OPatchAutoRHPRepository.getInstance().getPatchList(patchLocation, isDirectory);
                ArrayList<OPatchPatch> installedPatchList = new ArrayList<OPatchPatch>();
                for (String patch_locn : patchList) {
                    boolean isComposite = this.isComposite(patch_locn);
                    List<String> patchIds = this.getAllPatchIds(patch_locn, isComposite);
                    for (String id : patchIds) {
                        OPatchPatch patch = target.getContext().getInstalledActivePatch(id);
                        if (patch == null) continue;
                        installedPatchList.add(patch);
                    }
                }
                if (installedPatchList.isEmpty()) {
                    result = new RHPValidationResult(RHPValidator.ValidatorID.PATCH_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.NO_PATCH_INSTALLED, new Object[0]);
                }
                result = new RHPValidationResult(RHPValidator.ValidatorID.PATCH_VALIDATOR, RHPValidationResult.ValidationStatus.SUCCESS, null, new Object[0]);
            }
            catch (OPatchException e) {
                this._logger.log(Level.WARNING, e.getMessage(), e);
                result = new RHPValidationResult(RHPValidator.ValidatorID.PATCH_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.INVENTORY_LOAD_FAILURE, oracleHome, e.getMessage());
            }
            catch (OPatchAutoException e) {
                this._logger.log(Level.WARNING, e.getMessage(), e);
                result = new RHPValidationResult(RHPValidator.ValidatorID.PATCH_VALIDATOR, RHPValidationResult.ValidationStatus.FAILED, RHPValidationFailureReason.PATCH_COLLECTION_FAILED, patchLocation, e.getLocalizedMessage());
            }
            finally {
                try {
                    OPatchContext.destroyContextReference();
                }
                catch (OPatchException e) {
                    this._logger.log(Level.WARNING, "Exception while destroying context", e);
                }
            }
        } else {
            this._logger.fine("Patch validation not required for the operation");
            result = new RHPValidationResult(RHPValidator.ValidatorID.PATCH_VALIDATOR, RHPValidationResult.ValidationStatus.SUCCESS, null, new Object[0]);
        }
        return result;
    }

    protected boolean isComposite(String patch_locn) {
        boolean value = false;
        try {
            OPatchPatch[] patches;
            this._logger.finest("Invoking getPatchesNoSymbolResolve() on " + patch_locn);
            for (OPatchPatch subPatch : patches = OPatchPatch.getPatchesNoSymbolResolve((String)patch_locn)) {
                if (!subPatch.isComposite()) continue;
                this._logger.info("Detected a composite Patch inside the patch at: " + subPatch.getPatchLocation() + "\nSubpatches : " + subPatch.getSubPatchIds());
                return true;
            }
        }
        catch (OPatchException ex) {
            this._logger.warning("This is not a Composite patch: \"" + patch_locn + "\"");
            value = false;
        }
        catch (Throwable t) {
            this._logger.warning("Hit an Error with this patch: \"" + patch_locn + "\"");
            value = false;
        }
        return value;
    }

    private List<String> getAllPatchIds(String patch_locn, boolean isComposite) throws OPatchException {
        ArrayList<String> patchIds = new ArrayList<String>();
        if (isComposite) {
            for (OPatchPatch patch : OPatchPatch.getPatches((String)patch_locn)) {
                patchIds.add(patch.getPatchId());
            }
        } else {
            OPatchPatch patch = new OPatchPatch(patch_locn);
            patchIds.add(patch.getPatchId());
        }
        return patchIds;
    }

    private static String getCustomLogDirForCore(String oh) {
        String customDir = oh + File.separator + "cfgtoollogs" + File.separator + "opatchauto" + File.separator + "core";
        File customDirFile = new File(customDir);
        if (customDirFile.exists() || customDirFile.mkdirs()) {
            return customDir;
        }
        return System.getProperty("java.io.tmpdir");
    }
}

