/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.repository.system;

import com.oracle.cie.common.comdev.ComdevHelper;
import com.oracle.cie.common.util.FileUtils;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import com.oracle.glcm.patch.auto.rhp.repository.system.ProductDriverException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import oracle.cluster.deployment.ClusterwareInfo;
import oracle.cluster.install.InstallException;
import oracle.ops.mgmt.cluster.Cluster;
import oracle.ops.mgmt.cluster.ClusterInfoException;
import oracle.ops.mgmt.cluster.NoSuchCRSHomeException;
import oracle.ops.mgmt.cluster.NoSuchExecutableException;
import oracle.sysman.oii.oiic.OiicStandardInventorySession;
import oracle.sysman.oii.oiii.OiiiCompInstallID;
import oracle.sysman.oii.oiii.OiiiInstallAreaControl;
import oracle.sysman.oii.oiii.OiiiInstallInventory;
import oracle.sysman.oii.oiii.OiiiInventoryDoesNotExistException;
import oracle.sysman.oii.oiii.OiiiOracleHomeInfo;
import oracle.sysman.oii.oiii.OiiiVersion;
import oracle.sysman.oii.oiit.OiitTargetLockNotAvailableException;
import oracle.sysman.oii.oiix.OiixPathOps;
import oracle.sysman.oii.oiix.OiixPlatform;

public class OracleHomeInformationLoader {
    private static final String OLR_LOC_LINUX = "/etc/oracle/olr.loc";
    private static final String CRSCTL_COMMAND = "bin" + File.separator + "crsctl";
    private static final String BIN_EXTENSION = ".bin";
    private static final String EXE_EXTENSION = ".exe";
    private static final String OUI_DIR = "oui";
    private static final String SYSTEM_PROPERTY_OUI_LOC = "oracle.installer.oui_loc";
    private static final String SYSTEM_PROPERTY_STARTUP_LOC = "oracle.installer.startup_location";
    private static final String LIB_DIR = "lib";
    private static final String SYSTEM_PROPERTY_LIB_LOC = "oracle.installer.library_loc";
    private final Logger _logger = Logger.getLogger(OracleHomeInformationLoader.class.getName());
    private String _crsHome = null;
    private List<File> _crsSftwareInsOnly = new ArrayList<File>();
    private CRSStatus _crsStatus = CRSStatus.NONE;
    private String _crsVersionFromOUI = null;
    private Vector<OiiiOracleHomeInfo> _homeList = null;
    private String _oraclebase = null;
    private boolean _isInventoryLoaded = false;
    private List<String> _hostList = new ArrayList<String>();

    private OracleHomeInformationLoader() {
    }

    public static OracleHomeInformationLoader getInstance() {
        OracleHomeInformationLoader crsInfoLoader = Loader._crsInfoLoader;
        return crsInfoLoader;
    }

    public void loadInventory(String oracleHome) throws ProductDriverException {
        try {
            if (!this._isInventoryLoaded) {
                OiicStandardInventorySession inventorySession = this.initOUI();
                this._homeList = this.getHomesList(inventorySession);
                this.retrieveNodeNames(oracleHome, inventorySession);
                this.detectCrsHome(inventorySession);
                this._oraclebase = this.detectOraclebase(inventorySession, oracleHome);
                this.endSession(inventorySession);
                this._isInventoryLoaded = true;
            }
        }
        catch (Exception e1) {
            throw new ProductDriverException("failed to load inventory details due to " + e1.getMessage());
        }
    }

    private String detectOraclebase(OiicStandardInventorySession inventorySession, String ohPath) throws ProductDriverException {
        String oracleBase = null;
        OiiiInstallInventory inv = inventorySession.getInstallAreaControl().getInstallInventory();
        OiiiOracleHomeInfo homeInfo = inv.getHomeWithLocation(ohPath);
        oracleBase = homeInfo != null ? homeInfo.getAdditionalOracleHomeProperty("ORACLE_BASE") : this.findOraBaseUsingCommand(ohPath);
        this._logger.log(Level.FINE, "ORACLE_BASE for " + ohPath + " is " + oracleBase);
        return oracleBase;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String findOraBaseUsingCommand(String ohpath) throws ProductDriverException {
        File orabase = new File(ohpath + "/bin/orabase");
        if (!orabase.exists()) {
            this._logger.log(Level.FINE, ohpath + "/bin/orabase could not be found for OracleHome at " + ohpath);
            return null;
        }
        try {
            String s = null;
            Process p = Runtime.getRuntime().exec(new String[]{ohpath + "/bin/orabase"});
            try (BufferedReader b = new BufferedReader(new InputStreamReader(p.getInputStream()));){
                s = b.readLine();
                this._logger.fine(ohpath + " has ORACLE_BASE " + s);
            }
            return s;
        }
        catch (IOException e) {
            throw new ProductDriverException(e.getMessage(), e, ProductDriverException.Type.Unknown);
        }
    }

    public String getGridHome() {
        return this._crsHome;
    }

    public List<String> getHostList() {
        return this._hostList;
    }

    public String getOraclebaseLocation() {
        return this._oraclebase;
    }

    public static boolean isGridHome(String oracleHomePath) {
        String crsctlCmd = oracleHomePath + File.separator + CRSCTL_COMMAND;
        crsctlCmd = ComdevHelper.isWindows() ? crsctlCmd + EXE_EXTENSION : crsctlCmd + BIN_EXTENSION;
        File crsctl = new File(crsctlCmd);
        return crsctl.exists();
    }

    public boolean isStackRunning() throws ProductDriverException {
        boolean running = false;
        switch (this._crsStatus) {
            case RUNNING: {
                running = true;
                break;
            }
            case NOT_RUNNING: {
                running = false;
                break;
            }
            default: {
                running = this.isCRSRunning();
            }
        }
        this._logger.log(Level.INFO, "running: " + running);
        return running;
    }

    private boolean isCRSRunning() throws ProductDriverException {
        boolean running = false;
        String crsHomePath = this._crsHome;
        CrsType crsType = CrsType.NONE;
        File gridHome = new File(crsHomePath);
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            if (crsInfo.isCRSConfigured(crsHomePath)) {
                crsType = CrsType.CRS;
            } else if (crsInfo.isHAConfigured(crsHomePath)) {
                crsType = CrsType.SIHA;
            } else if (this._crsSftwareInsOnly.size() > 0) {
                crsType = CrsType.SOFTWARE_INSTALLATION_ONLY;
            } else {
                throw new ProductDriverException("No any valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
            }
            this._logger.log(Level.INFO, "crsType: " + (Object)((Object)crsType));
            if (crsType == CrsType.CRS) {
                running = crsInfo.isCRSRunning(gridHome.getAbsolutePath());
            } else if (crsType == CrsType.SIHA) {
                running = crsInfo.isHARunning(gridHome.getAbsolutePath());
            }
            this._crsStatus = running ? CRSStatus.RUNNING : CRSStatus.NOT_RUNNING;
        }
        catch (InstallException e) {
            this._logger.log(Level.FINE, e.getMessage());
        }
        return running;
    }

    public CrsType getCRSType() throws ProductDriverException {
        CrsType crsType;
        block5: {
            crsType = CrsType.NONE;
            File gridHome = new File(this._crsHome);
            ClusterwareInfo crsInfo = new ClusterwareInfo();
            try {
                if (crsInfo.isCRSConfigured(gridHome.getAbsolutePath())) {
                    crsType = CrsType.CRS;
                    break block5;
                }
                if (crsInfo.isHAConfigured(gridHome.getAbsolutePath())) {
                    crsType = CrsType.SIHA;
                    break block5;
                }
                if (this._crsSftwareInsOnly.size() > 0) {
                    crsType = CrsType.SOFTWARE_INSTALLATION_ONLY;
                    break block5;
                }
                throw new ProductDriverException("No any valid Grid Home detected on current system", ProductDriverException.Type.ConfigurationNotSupported);
            }
            catch (InstallException e) {
                this._logger.log(Level.FINE, e.getMessage());
            }
        }
        this._logger.log(Level.INFO, "CRS type :" + (Object)((Object)crsType));
        return crsType;
    }

    public boolean isGridEnv() throws ProductDriverException {
        CrsType type = this.getCRSType();
        return type != CrsType.NONE;
    }

    public String getCrsVersion(boolean stackRunning) throws ProductDriverException {
        String version = null;
        this._logger.entering(OracleHomeInformationLoader.class.getName(), "getCrsVersion");
        if (!stackRunning) {
            this._logger.log(Level.FINE, "CRS stack is down. Now getting crs version by OUI.");
            return this._crsVersionFromOUI;
        }
        CrsType crsType = this.getCRSType();
        File ohpath = new File(this._crsHome);
        ClusterwareInfo crsInfo = new ClusterwareInfo();
        try {
            version = crsType != CrsType.CRS ? crsInfo.getSIHAReleaseVersionString(ohpath.getAbsolutePath()) : crsInfo.getCRSActiveVersionString(ohpath.getAbsolutePath());
            return version;
        }
        catch (NoSuchExecutableException e) {
            throw new ProductDriverException(e, ProductDriverException.Type.ProductApiException);
        }
        catch (NoSuchCRSHomeException e) {
            throw new ProductDriverException("OracleHome Path given does not exist", e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        catch (ClusterInfoException e) {
            throw new ProductDriverException(e, ProductDriverException.Type.UnableToCollectKnownInformation);
        }
        catch (InstallException e) {
            throw new ProductDriverException(e, ProductDriverException.Type.ProductApiException);
        }
    }

    public OracleHomeType getHomeType(String oracleHome) {
        OracleHomeType homeType = null;
        if (this._homeList != null && !this._homeList.isEmpty()) {
            if (FileUtils.getFile((String)oracleHome).equals(FileUtils.getFile((String)this._crsHome))) {
                homeType = OracleHomeType.CRS;
            } else if (this._crsSftwareInsOnly.contains(FileUtils.getFile((String)oracleHome))) {
                homeType = OracleHomeType.CRS;
            } else if (this._homeList != null && !this._homeList.isEmpty()) {
                for (OiiiOracleHomeInfo oh : this._homeList) {
                    if (!FileUtils.getFile((String)oh.getLocation()).equals(FileUtils.getFile((String)oracleHome))) continue;
                    homeType = OracleHomeType.RAC;
                }
            }
        }
        return homeType;
    }

    private String detectCrsHome(OiicStandardInventorySession inventorySession) throws ProductDriverException {
        if (this._crsHome != null) {
            return this._crsHome;
        }
        boolean hasCrs = false;
        for (OiiiOracleHomeInfo home : this._homeList) {
            String homePath = home.getLocation();
            if (home.isCRSHome()) {
                this._crsHome = homePath;
                hasCrs = true;
                continue;
            }
            File crsctl = new File(homePath + File.separator + "bin" + File.separator + "crsctl.bin");
            if (!crsctl.exists()) continue;
            this._crsSftwareInsOnly.add(FileUtils.getFile((String)homePath));
        }
        if (!hasCrs && this._crsSftwareInsOnly.size() > 0) {
            String crsHomeInOlrFile = this.getCrsHomeFromOlrFile();
            this._crsHome = crsHomeInOlrFile != null && crsHomeInOlrFile.length() != 0 ? crsHomeInOlrFile : this._crsSftwareInsOnly.get(0).getAbsolutePath();
        }
        if (this._crsHome == null) {
            throw new ProductDriverException("Cannot detect any valid Grid Infrastructure setup.");
        }
        this._crsVersionFromOUI = this.getCrsVersion(inventorySession);
        return this._crsHome;
    }

    private String getCrsVersion(OiicStandardInventorySession inventorySession) {
        String version = "";
        OiiiInstallAreaControl oiac = inventorySession.getInstallAreaControl();
        OiiiInstallInventory oii = oiac.getInstallInventory();
        for (OiiiOracleHomeInfo oh : this._homeList) {
            if (!FileUtils.getFile((String)oh.getLocation()).equals(FileUtils.getFile((String)this._crsHome))) continue;
            Vector compList = oii.getTopLevelComps(oh.getIndex());
            version = ((OiiiCompInstallID)compList.get(0)).getVersion().getVerString();
            break;
        }
        return version;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getCrsHomeFromOlrFile() {
        File olrFile = new File(OLR_LOC_LINUX);
        BufferedReader reader = null;
        try {
            reader = new BufferedReader(new FileReader(olrFile));
            String line = null;
            while ((line = reader.readLine()) != null) {
                if (!line.contains("crs_home")) continue;
                String[] crshomeLine = line.split("=");
                if (crshomeLine == null || crshomeLine.length != 2) continue;
                String string = crshomeLine[1];
                return string;
            }
            reader.close();
        }
        catch (IOException e) {
        }
        finally {
            if (reader != null) {
                try {
                    reader.close();
                }
                catch (IOException e1) {}
            }
        }
        return null;
    }

    private Vector<OiiiOracleHomeInfo> getHomesList(OiicStandardInventorySession inventorySession) {
        OiiiInstallAreaControl oiac = inventorySession.getInstallAreaControl();
        OiiiInstallInventory oii = oiac.getInstallInventory();
        Vector homeList = oii.getHomes();
        return homeList;
    }

    private void retrieveNodeNames(String homePath, OiicStandardInventorySession inventorySession) throws ProductDriverException {
        if (this._hostList != null && this._hostList.size() > 0) {
            return;
        }
        try {
            String[] nodeList = Cluster.getNodes();
            this._hostList.addAll(Arrays.asList(nodeList));
        }
        catch (Exception e) {
            String haVersion = this.getCrsVersion(this.isStackRunning());
            OiiiVersion baseVersionObj = new OiiiVersion("12.2.0.0");
            OiiiVersion versionToCompareObj = new OiiiVersion(haVersion);
            if (versionToCompareObj.equals(baseVersionObj) || versionToCompareObj.laterThan(baseVersionObj)) {
                try {
                    String nodeName = InetAddress.getLocalHost().getHostName();
                    if (nodeName != null) {
                        if (nodeName.indexOf(".") != -1) {
                            nodeName = nodeName.substring(0, nodeName.indexOf("."));
                        }
                    } else {
                        throw new UnknownHostException("Unknown host");
                    }
                    this._hostList = new ArrayList<String>();
                    this._hostList.add(nodeName);
                }
                catch (UnknownHostException e1) {
                    throw new ProductDriverException(e1, ProductDriverException.Type.ProductApiException);
                }
            }
            try {
                String[] nodeList = OracleHomeInformationLoader.retrieveNodeListUsingOUI(homePath, inventorySession);
                this._hostList.addAll(Arrays.asList(nodeList));
            }
            catch (Exception e1) {
                throw new ProductDriverException(e1, ProductDriverException.Type.ProductApiException);
            }
        }
    }

    private static String[] retrieveNodeListUsingOUI(String homePath, OiicStandardInventorySession inventorySession) throws OPatchAutoException {
        String[] nodes = new String[]{};
        OiiiInstallAreaControl oiac = inventorySession.getInstallAreaControl();
        OiiiInstallInventory oii = oiac.getInstallInventory();
        block0: for (Object home : oii.getHomes()) {
            OiiiOracleHomeInfo homeInfo = (OiiiOracleHomeInfo)home;
            if (null == homePath || !new File(homeInfo.getLocation()).equals(new File(homePath))) continue;
            Vector nodeList = homeInfo.getNodeList();
            if (nodeList.isEmpty()) break;
            nodes = new String[nodeList.size()];
            nodeList.toArray(nodes);
            String localNode = homeInfo.getLocalNode();
            if (localNode == null || localNode.equals("")) {
                localNode = OPatchautoRHPHelper.getHostname();
            }
            for (int i = 0; i < nodes.length; ++i) {
                if (!nodes[i].equals(localNode)) continue;
                if (i == 0) break block0;
                String tmp = nodes[0];
                nodes[0] = nodes[i];
                nodes[i] = tmp;
                break block0;
            }
        }
        if (nodes.length < 1) {
            nodes = new String[]{OPatchautoRHPHelper.getHostname()};
        }
        return nodes;
    }

    private OiicStandardInventorySession initOUI() throws ProductDriverException {
        String oh = System.getenv("ORACLE_HOME");
        if ((oh == null || oh.equals("")) && ((oh = System.getProperty("ORACLE_HOME")) == null || oh.equals(""))) {
            throw new ProductDriverException("Please set the ORACLE_HOME environment variable to the location of the Grid Infrastructure (GI) Home.");
        }
        StringBuffer ouiLocation = new StringBuffer(oh);
        ouiLocation.append(File.separator);
        ouiLocation.append(OUI_DIR);
        System.setProperty(SYSTEM_PROPERTY_OUI_LOC, ouiLocation.toString());
        System.setProperty(SYSTEM_PROPERTY_STARTUP_LOC, ouiLocation.toString());
        String sLibraryLoc = OiixPathOps.concatPath((String)ouiLocation.toString(), (String)LIB_DIR);
        String dirName = OiixPlatform.getCurrentPlatformDirectoryName();
        sLibraryLoc = OiixPathOps.concatPath((String)sLibraryLoc, (String)dirName);
        sLibraryLoc = OiixPathOps.getNativeForm((String)sLibraryLoc);
        System.setProperty(SYSTEM_PROPERTY_LIB_LOC, sLibraryLoc);
        return this.startSession();
    }

    private OiicStandardInventorySession startSession() throws ProductDriverException {
        OiicStandardInventorySession osis = new OiicStandardInventorySession("OUISM", "1.0");
        try {
            osis.initSession(0);
        }
        catch (OiitTargetLockNotAvailableException e) {
            throw new ProductDriverException(e, ProductDriverException.Type.ProductApiException);
        }
        catch (IOException e) {
            throw new ProductDriverException(e, ProductDriverException.Type.Unknown);
        }
        catch (OiiiInventoryDoesNotExistException e) {
            throw new ProductDriverException(e, ProductDriverException.Type.Unknown);
        }
        return osis;
    }

    private void endSession(OiicStandardInventorySession inventorySession) {
        inventorySession.endSession();
        inventorySession = null;
    }

    private static class Loader {
        static OracleHomeInformationLoader _crsInfoLoader = new OracleHomeInformationLoader();

        private Loader() {
        }
    }

    public static enum OracleHomeType {
        CRS,
        RAC,
        SIDB;

    }

    public static enum ClusterStatus {
        CRS_RUNNING,
        CRS_NOT_RUNNING,
        CRS_STATUS_UNKNOWN;

    }

    public static enum CrsType {
        NONE,
        CRS,
        SIHA,
        SOFTWARE_INSTALLATION_ONLY;

    }

    static enum CRSStatus {
        NONE,
        RUNNING,
        NOT_RUNNING;

    }
}

