/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.command;

import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.Command;
import com.oracle.glcm.patch.auto.rhp.command.RHPApplyImageCommand;
import com.oracle.glcm.patch.auto.rhp.command.RHPCreateImageCommand;
import com.oracle.glcm.patch.auto.rhp.command.RHPParams;
import com.oracle.glcm.patch.auto.rhp.command.RHPQeryWorkingCopyCommand;
import com.oracle.glcm.patch.auto.rhp.command.RHPQueryImageCommand;
import com.oracle.glcm.patch.auto.rhp.command.RHPSwitchBackHomeCommand;
import com.oracle.glcm.patch.auto.rhp.command.RHPSwitchHomeCommand;
import java.util.ArrayList;
import java.util.List;

public class RHPCommandGenerator {
    public List<String> generateCommand(Command cmd, RHPParams params) throws OPatchAutoException {
        ArrayList<String> commandToExecute = new ArrayList<String>();
        List<String> generatedCommands = cmd.generateCommand(params);
        if (generatedCommands != null && !generatedCommands.isEmpty()) {
            commandToExecute.addAll(generatedCommands);
        }
        return commandToExecute;
    }

    public List<Command> getCommand(RHPOperation type) {
        ArrayList<Command> commandList = new ArrayList<Command>();
        switch (type) {
            case CREATE_IMAGE: {
                commandList.add(new RHPCreateImageCommand());
                break;
            }
            case PROVISION_HOME: {
                commandList.add(new RHPApplyImageCommand());
                break;
            }
            case SWITCH_HOME: {
                commandList.add(new RHPSwitchHomeCommand());
                break;
            }
            case QUERY_IMAGE: {
                commandList.add(new RHPQueryImageCommand());
                break;
            }
            case QUERY_WORKINGCOPY: {
                commandList.add(new RHPQeryWorkingCopyCommand());
                break;
            }
            case SWITCH_BACK_HOME: {
                commandList.add(new RHPSwitchBackHomeCommand());
                break;
            }
        }
        return commandList;
    }
}

