/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp.command;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import com.oracle.glcm.patch.auto.rhp.RHPOperation;
import com.oracle.glcm.patch.auto.rhp.command.RHPParams;
import com.oracle.glcm.patch.auto.rhp.executor.RHPCommandExecutor;
import com.oracle.glcm.patch.auto.rhp.repository.system.OracleHomeInformationLoader;
import java.io.File;
import java.util.List;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public abstract class Command {
    protected final Logger _logger = Logger.getLogger(this.getClass().getName());

    public abstract RHPOperation getOperationType();

    public abstract List<String> generateCommand(RHPParams var1) throws OPatchAutoException;

    public void preExecute(RHPParams params) throws OPatchAutoException {
    }

    public void postExecute(RHPParams params) throws OPatchAutoException {
    }

    public String getRHPExecutable(String rhpClientHome) {
        return OPatchautoRHPHelper.removeTrailingFileSeperator(rhpClientHome) + File.separator + "bin" + File.separator + "rhpctl";
    }

    public String getImageType(String oracleHome) {
        String imageType = null;
        OracleHomeInformationLoader.OracleHomeType homeType = OracleHomeInformationLoader.getInstance().getHomeType(oracleHome);
        switch (homeType) {
            case CRS: {
                imageType = "ORACLEGISOFTWARE";
                break;
            }
            case RAC: 
            case SIDB: {
                imageType = "ORACLEDBSOFTWARE";
            }
        }
        this._logger.fine("Type of the image is " + imageType);
        return imageType;
    }

    public abstract String getStatusMessage(RHPCommandExecutor.Status var1, RHPParams var2);

    protected String generateBatchesCommand(String batches) throws OPatchAutoException {
        StringBuffer command = new StringBuffer("");
        Pattern pattern = Pattern.compile("\\[(.*?)\\]");
        Matcher matcher = pattern.matcher(batches);
        StringBuffer tmp = new StringBuffer("");
        while (matcher.find()) {
            tmp.append("\\(");
            tmp.append(matcher.group(1));
            tmp.append("\\),");
        }
        if (StringUtil.isNullOrEmpty((String)tmp.toString())) {
            throw new OPatchAutoException(Integer.toString(75060), new Object[0]);
        }
        command.append(" ");
        command.append("-batches");
        command.append(" ");
        command.append(tmp.substring(0, tmp.lastIndexOf(",")));
        return command.toString();
    }
}

