/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.glcm.patch.auto.rhp;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.common.util.reporting.Reporting;
import com.oracle.glcm.patch.auto.OPatchAutoCommand;
import com.oracle.glcm.patch.auto.OPatchAutoException;
import com.oracle.glcm.patch.auto.OPatchAutoHelper;
import com.oracle.glcm.patch.auto.OPatchAutoOption;
import com.oracle.glcm.patch.auto.OPatchAutoOptionsException;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPExecutor;
import com.oracle.glcm.patch.auto.rhp.OPatchAutoRHPOptions;
import com.oracle.glcm.patch.auto.rhp.OPatchautoRHPHelper;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class OPatchAutoRHP {
    private static final Logger _log;
    private static OPatchAutoRHPOptions _opatchautoRHPOptions;

    public static void main(String[] args) {
        int retCode = 0;
        Throwable throwable = null;
        try {
            String lastSessionId;
            _opatchautoRHPOptions = OPatchAutoRHPOptions.getInstance();
            ArrayList<String> argsList = new ArrayList<String>();
            if (args != null) {
                argsList.addAll(Arrays.asList(args));
            }
            if (argsList.isEmpty()) {
                OPatchAutoRHP.usage(OPatchAutoHelper.getPublishedMessage((String)"68002", (Object[])new Object[0]), false, null);
            }
            OPatchAutoCommand command = OPatchAutoCommand.apply;
            String operationArg = (String)argsList.remove(0);
            if (operationArg.equalsIgnoreCase(_opatchautoRHPOptions.getOption("help").getArg())) {
                String message = null;
                boolean helpRequest = true;
                argsList.remove(_opatchautoRHPOptions.getOption("rhp").getArg());
                if (!argsList.isEmpty()) {
                    message = OPatchAutoHelper.getPublishedMessage((String)"68148", (Object[])new Object[]{argsList});
                    helpRequest = false;
                }
                OPatchAutoRHP.usage(message, helpRequest, null);
            }
            try {
                command = OPatchAutoCommand.valueOf((String)operationArg.toLowerCase());
                if (OPatchAutoRHP.unsupportedCommandList().contains(command)) {
                    throw new IllegalArgumentException("Unsupported command::" + command);
                }
                _opatchautoRHPOptions.setCommand(command);
            }
            catch (IllegalArgumentException e) {
                Set<OPatchAutoCommand> filteredCommandList = OPatchAutoRHP.filterUnsuporttedCommands(OPatchAutoCommand.getExternalCommands());
                OPatchAutoRHP.usage(OPatchAutoHelper.getPublishedMessage((String)"68003", (Object[])new Object[]{operationArg, filteredCommandList}), false, null);
            }
            if (argsList.isEmpty() && command.hasOptions()) {
                OPatchAutoRHP.usage(OPatchAutoHelper.getPublishedMessage((String)"68002", (Object[])new Object[0]), false, command);
            }
            try {
                _opatchautoRHPOptions.setPopulatedOptions(OPatchAutoRHP.populateOptionsFromArgs(command, _opatchautoRHPOptions, argsList));
            }
            catch (OPatchAutoOptionsException e) {
                OPatchAutoRHP.usage(e.getMessage(), false, command);
            }
            OPatchAutoRHP.handleUsageRequests(_opatchautoRHPOptions, command);
            if (command.isResume() && !StringUtil.isNullOrEmpty((String)(lastSessionId = OPatchAutoRHP.findLastSessionId()))) {
                _opatchautoRHPOptions.getOption("session").setValue(lastSessionId);
            }
            OPatchAutoRHPExecutor executor = new OPatchAutoRHPExecutor();
            executor.prepareExecution(_opatchautoRHPOptions, command);
        }
        catch (OPatchAutoOptionsException e) {
            if (!e.isHelpRequested()) {
                throwable = e;
                retCode = 41;
            }
            _log.log(Level.FINE, "OPatchAuto options exception...", e);
            Reporting.report((String)e.getMessage());
        }
        catch (Throwable e) {
            throwable = e;
            retCode = 42;
            _log.log(Level.SEVERE, "OPatchAuto failed.", e);
            Reporting.report((String)e.getMessage());
        }
        if (!Boolean.getBoolean("OPatchAuto.disable.system.exit")) {
            if (retCode == 0) {
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchAuto.RHP.successful", (Object[])new Object[0]));
            } else {
                Reporting.report((String)OPatchAutoHelper.getLocalizedString((String)"OPatchAuto.RHP.failed", (Object[])new Object[0]));
            }
            System.exit(retCode);
        } else if (retCode != 0) {
            throw new IllegalStateException(OPatchAutoHelper.getPublishedMessage((String)"68001", (Object[])new Object[]{retCode}), throwable);
        }
    }

    private static String findLastSessionId() {
        String lastSessionId = null;
        Properties file = new Properties();
        try {
            file.load(new FileInputStream(OPatchautoRHPHelper.getRHPSessionPropertyFile()));
        }
        catch (OPatchAutoException | IOException throwable) {
            // empty catch block
        }
        lastSessionId = file.getProperty("sessionid");
        return lastSessionId;
    }

    private static Set<OPatchAutoOption> populateOptionsFromArgs(OPatchAutoCommand command, OPatchAutoRHPOptions options, List<String> argsList) throws OPatchAutoException {
        LinkedHashSet<OPatchAutoOption> populatedOptions = new LinkedHashSet<OPatchAutoOption>();
        LinkedHashSet<OPatchAutoOption> supportedOptions = new LinkedHashSet<OPatchAutoOption>();
        supportedOptions.addAll(options.getRHPGlobalOptions());
        supportedOptions.addAll(options.getRHPCommandOptions(command));
        OPatchAutoOption parameter = options.getRHPCommandParameter(command);
        if (parameter != null) {
            supportedOptions.add(parameter);
        }
        HashSet<String> switches = new HashSet<String>();
        HashSet<String> validArgs = new HashSet<String>();
        for (OPatchAutoOption option : supportedOptions) {
            if (option.isSwitch()) {
                switches.add(option.getArg());
                continue;
            }
            validArgs.add(option.getArg());
        }
        Map<String, String> parsedCommandArgs = OPatchAutoRHP.parseCommandLineArgs(argsList, validArgs, switches, parameter != null ? parameter.getArg() : null);
        for (Map.Entry<String, String> entry : parsedCommandArgs.entrySet()) {
            String arg = entry.getKey();
            String value = entry.getValue();
            for (OPatchAutoOption option : supportedOptions) {
                if (!option.getArg().equals(arg)) continue;
                if (option.isDisabled()) {
                    throw new OPatchAutoOptionsException("68150", new Object[]{arg});
                }
                if (option.isPassword()) {
                    option.setPasswordValue(value.toCharArray());
                } else {
                    option.setValue(value);
                }
                populatedOptions.add(option);
            }
        }
        return populatedOptions;
    }

    private static Map<String, String> parseCommandLineArgs(List<String> argsList, Collection<String> validArgs, Collection<String> validSwitches, String parameter) throws OPatchAutoOptionsException {
        boolean hasParameter = !StringUtil.isNullOrEmpty((String)parameter, (boolean)true);
        HashMap<String, String> options = new HashMap<String, String>();
        if (argsList != null && !argsList.isEmpty()) {
            for (int x = 0; x < argsList.size(); ++x) {
                String value;
                String arg = argsList.get(x);
                if (arg == null) {
                    throw new OPatchAutoOptionsException("68029", new Object[]{"null"});
                }
                if (!arg.startsWith("-")) {
                    if (hasParameter && !options.containsKey(parameter)) {
                        options.put(parameter, arg);
                        continue;
                    }
                    throw new OPatchAutoOptionsException("68029", new Object[]{arg});
                }
                if (validSwitches != null && validSwitches.contains(arg)) {
                    value = "true";
                } else {
                    if (validArgs != null && !validArgs.contains(arg)) {
                        throw new OPatchAutoOptionsException("68029", new Object[]{arg});
                    }
                    if (argsList.size() <= ++x || argsList.get(x).startsWith("-")) {
                        if (argsList.size() <= x) {
                            throw new OPatchAutoOptionsException("68030", new Object[]{arg});
                        }
                        throw new OPatchAutoOptionsException("68031", new Object[]{argsList.get(x), arg});
                    }
                    value = argsList.get(x);
                }
                options.put(arg, value);
            }
        }
        return options;
    }

    private static void handleUsageRequests(OPatchAutoRHPOptions options, OPatchAutoCommand command) throws OPatchAutoException {
        if (Boolean.parseBoolean(options.getOption("help").getValue())) {
            Set<OPatchAutoOption> populatedOptions = options.getPopulatedOptions();
            if (populatedOptions != null) {
                populatedOptions.remove(options.getOption("help"));
                populatedOptions.remove(options.getOption("rhp"));
            }
            String message = null;
            boolean helpRequest = true;
            if (populatedOptions != null && !populatedOptions.isEmpty()) {
                message = OPatchAutoHelper.getPublishedMessage((String)"68148", (Object[])new Object[]{OPatchAutoRHP.getOptionNames(populatedOptions)});
                helpRequest = false;
            }
            OPatchAutoRHP.usage(message, helpRequest, command);
        }
    }

    private static Collection<String> getOptionNames(Collection<OPatchAutoOption> options) {
        ArrayList<String> missingRequired = new ArrayList<String>();
        if (options != null) {
            for (OPatchAutoOption option : options) {
                if (option == null) continue;
                missingRequired.add(option.getArg());
            }
        }
        return missingRequired;
    }

    private static void usage(String message, boolean helpRequest, OPatchAutoCommand command) throws OPatchAutoException {
        StringBuilder sb = new StringBuilder();
        if (!StringUtil.isNullOrEmpty((String)message, (boolean)true)) {
            sb.append(message).append("\n\n");
        }
        sb.append(OPatchAutoRHP.getUsageHeader());
        if (command == null) {
            sb.append(OPatchAutoRHP.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.line1.indent", (Object[])new Object[0]))));
            sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.line1", (Object[])new Object[0]));
            sb.append("\n\n");
            int indentSize = Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.command.prefix.indent", (Object[])new Object[0]));
            String commandPrefix = OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.command.prefix", (Object[])new Object[0]) + " ";
            sb.append(OPatchAutoRHP.getIndent(indentSize)).append(commandPrefix);
            indentSize += commandPrefix.length();
            Set<OPatchAutoCommand> filterCommandList = OPatchAutoRHP.filterUnsuporttedCommands(OPatchAutoCommand.getExternalCommands());
            for (OPatchAutoCommand c : filterCommandList) {
                sb.append(c.name()).append("\n").append(OPatchAutoRHP.getIndent(indentSize));
            }
            sb.append("\n");
            indentSize = Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.global.prefix.indent", (Object[])new Object[0]));
            String globalPrefix = OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.global.prefix", (Object[])new Object[0]) + " ";
            sb.append(OPatchAutoRHP.getIndent(indentSize)).append(globalPrefix);
            indentSize += globalPrefix.length();
            Set<OPatchAutoOption> globalOptions = _opatchautoRHPOptions.getRHPGlobalOptions();
            for (OPatchAutoOption option : globalOptions) {
                sb.append(option.getArg()).append("\n").append(OPatchAutoRHP.getIndent(indentSize));
            }
            sb.append("\n");
            indentSize = Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.examples.prefix.indent", (Object[])new Object[0]));
            String examplesPrefix = OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.examples.prefix", (Object[])new Object[0]);
            sb.append(OPatchAutoRHP.getIndent(indentSize)).append(examplesPrefix).append("\n");
            indentSize = Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.example.indent", (Object[])new Object[0]));
            String appName = OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.app.name", (Object[])new Object[0]);
            for (OPatchAutoOption option : globalOptions) {
                sb.append(OPatchAutoRHP.getIndent(indentSize)).append("'").append(appName).append(" ").append(option.getArg()).append("'\n");
            }
            for (OPatchAutoCommand c : filterCommandList) {
                if (c.isInternal()) continue;
                if (!c.hasOptions()) {
                    sb.append(OPatchAutoRHP.getIndent(indentSize)).append("'").append(appName).append(" ").append(c.name()).append("'\n");
                    continue;
                }
                for (OPatchAutoOption option : globalOptions) {
                    if (!option.isPerCommandGlobal()) continue;
                    sb.append(OPatchAutoRHP.getIndent(indentSize)).append("'").append(appName).append(" ").append(c.name()).append(" ").append(option.getArg()).append("'\n");
                }
            }
        } else {
            if (command.isResumed()) {
                command = OPatchAutoCommand.resume;
            }
            Set<OPatchAutoOption> commandOptions = _opatchautoRHPOptions.getRHPCommandOptions(command);
            Iterator<OPatchAutoOption> it = commandOptions.iterator();
            while (it.hasNext()) {
                OPatchAutoOption commandOption = it.next();
                if (commandOption.isVisible()) continue;
                it.remove();
            }
            String indent = OPatchAutoRHP.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.command.description.indent", (Object[])new Object[0])));
            sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.command.description.header", (Object[])new Object[0]));
            sb.append("\n");
            String description = command.getDescription();
            String formattedDescription = description.replace("\n", "\n" + indent);
            sb.append(indent).append(formattedDescription);
            sb.append("\n\n");
            sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.syntax.description.header", (Object[])new Object[0]));
            sb.append("\n");
            if (!command.hasOptions()) {
                sb.append(indent).append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.command.no.options", (Object[])new Object[]{command})).append("\n");
            } else {
                int indentSize;
                int wrap = Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.syntax.wrap", (Object[])new Object[0]));
                String appName = indent + OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.app.name", (Object[])new Object[0]);
                appName = appName + " " + command.name();
                int currentSize = indentSize = appName.length() + 1;
                String args = "";
                OPatchAutoOption commandParameter = _opatchautoRHPOptions.getRHPCommandParameter(command);
                if (commandParameter != null) {
                    String argsStr = "[ <" + commandParameter.getArg() + "> ]";
                    currentSize += argsStr.length();
                    args = args + " " + (String)argsStr;
                }
                for (OPatchAutoOption commandOption : commandOptions) {
                    String argsStr = "[ " + commandOption.getCommandLineDescription() + " ]";
                    if (currentSize + argsStr.length() > wrap) {
                        args = args + "\n" + OPatchAutoRHP.getIndent(indentSize);
                        currentSize = indentSize;
                    } else {
                        args = args + " ";
                    }
                    currentSize += argsStr.length();
                    args = args + argsStr;
                }
                sb.append(appName).append(args);
                sb.append("\n\n");
                sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.options.description.header", (Object[])new Object[0]));
                String optionIndent = OPatchAutoRHP.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.option.indent", (Object[])new Object[0])));
                String optionDescIndent = OPatchAutoRHP.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.option.description.indent", (Object[])new Object[0])));
                for (OPatchAutoOption commandOption : commandOptions) {
                    sb.append("\n");
                    sb.append(optionIndent).append(commandOption.getCommandLineDescription());
                    sb.append("\n");
                    sb.append(optionDescIndent).append(commandOption.getDescription().replace("\n", "\n" + optionDescIndent));
                    if (commandOption.hasSupportedValues()) {
                        String supportIndent = optionDescIndent + "  ";
                        sb.append("\n").append(supportIndent);
                        sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.option.supported.values", (Object[])new Object[0]));
                        supportIndent = supportIndent + "  ";
                        sb.append("\n").append(supportIndent);
                        for (String val : commandOption.getSupportedValues()) {
                            sb.append(val.replace("\n", "\n" + supportIndent));
                        }
                    }
                    sb.append("\n");
                }
                if (commandParameter != null) {
                    optionIndent = OPatchAutoRHP.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.parameter.indent", (Object[])new Object[0])));
                    optionDescIndent = OPatchAutoRHP.getIndent(Integer.parseInt(OPatchAutoHelper.getLocalizedString((String)"opatchauto.parameter.description.indent", (Object[])new Object[0])));
                    sb.append("\n");
                    sb.append(OPatchAutoHelper.getLocalizedString((String)"opatchauto.parameters.description.header", (Object[])new Object[0]));
                    sb.append("\n");
                    sb.append(optionIndent).append(commandParameter.getArg());
                    sb.append("\n");
                    sb.append(optionDescIndent).append(commandParameter.getDescription().replace("\n", "\n" + optionDescIndent));
                    sb.append("\n");
                }
            }
            String example = command.getExample();
            if (!StringUtil.isNullOrEmpty((String)example)) {
                sb.append("\n");
                String exampleHeaderString = OPatchAutoHelper.getLocalizedString((String)"opatchauto.command.example.header", (Object[])new Object[0]);
                sb.append(exampleHeaderString);
                sb.append("\n");
                String formattedExample = example.replace("\n", "\n" + indent);
                sb.append(indent).append(formattedExample);
                sb.append("\n");
            }
        }
        OPatchAutoOptionsException exception = new OPatchAutoOptionsException(sb.toString(), new Object[0]);
        exception.setHelpRequested(helpRequest);
        throw exception;
    }

    private static Set<OPatchAutoCommand> filterUnsuporttedCommands(Collection<OPatchAutoCommand> orginalCommandLst) throws OPatchAutoException {
        HashSet<OPatchAutoCommand> filteredCommandList = new HashSet<OPatchAutoCommand>(orginalCommandLst);
        Set<OPatchAutoCommand> unsupportedCommands = OPatchAutoRHP.unsupportedCommandList();
        Iterator filIterator = filteredCommandList.iterator();
        while (filIterator.hasNext()) {
            OPatchAutoCommand externalCommand = (OPatchAutoCommand)filIterator.next();
            if (!unsupportedCommands.contains(externalCommand)) continue;
            filIterator.remove();
        }
        return filteredCommandList;
    }

    private static Set<OPatchAutoCommand> unsupportedCommandList() {
        HashSet<OPatchAutoCommand> unsupportedList = new HashSet<OPatchAutoCommand>();
        unsupportedList.add(OPatchAutoCommand.lsphases);
        unsupportedList.add(OPatchAutoCommand.lsplans);
        unsupportedList.add(OPatchAutoCommand.action);
        return unsupportedList;
    }

    private static String getUsageHeader() {
        return MessageFormat.format(OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.header1", (Object[])new Object[0]), OPatchAutoHelper.getInstance().getOPatchAutoVersion()) + "\n" + OPatchAutoHelper.getLocalizedString((String)"opatchauto.usage.header2", (Object[])new Object[0]) + "\n\n";
    }

    private static String getIndent(int size) {
        return StringUtil.getPad((String)" ", (int)size);
    }

    static {
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchauto/messages");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchauto/opatchauto");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchauto/usage");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautorhp/messages");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautorhp/usage");
        ResourceBundleManager.manageBundle((String)"opatchauto", (String)"resources/opatchautorhp/opatchauto-rhp");
        ResourceBundleManager.setPrefix((String)"opatchauto", (String)"OPATCHAUTO");
        _log = Logger.getLogger(OPatchAutoRHP.class.getName());
    }
}

