/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common.tools;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.repository.common.CommonCommandLine;
import com.oracle.cie.repository.common.config.RepoCommonConfig;
import com.oracle.cie.repository.common.exceptions.RepositoryCommonException;
import com.oracle.cie.rest.GavcSearchResult;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestFactory;
import com.oracle.cie.rest.RestHandler;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ModuleGenerator
extends CommonCommandLine {
    private static final Logger _log = Logger.getLogger(ModuleGenerator.class.getName());
    private RepoCommonConfig _repoCommonConfig;
    private Collection<String> _searchCoordinates;
    private String _moduleType;
    private Repository _destinationRepo;

    public ModuleGenerator(RepoCommonConfig repoCommonConfig, Collection<String> searchCoordinates, String moduleType, Repository destinationRepo) {
        this._repoCommonConfig = repoCommonConfig;
        this._searchCoordinates = searchCoordinates;
        this._moduleType = StringUtil.isNullOrEmpty((String)moduleType, (boolean)true) ? DependencyFileType.pom.name() : moduleType;
        this._destinationRepo = destinationRepo;
    }

    public void generate() throws RepositoryCommonException {
        if (this._searchCoordinates == null || this._searchCoordinates.isEmpty()) {
            throw new RepositoryCommonException("No search coordinates were specified for pom generation.");
        }
        _log.info("Searching for artifacts " + this._searchCoordinates);
        DependencyFileType dependencyFileType = DependencyFileType.valueOf((String)this._moduleType);
        _log.info("Creating modules of type " + dependencyFileType);
        try {
            if (this._destinationRepo == null) {
                this._destinationRepo = RestFactory.getRestHandlerConfig().getDefaultCacheRepository();
                _log.info("Defaulted destination repository to local-cache repository " + this._destinationRepo + " since one was not provided.");
            } else if (!this._destinationRepo.getType().isCache()) {
                throw new RepositoryCommonException("The destination repository specified was not of type " + RepositoryType.CACHE);
            }
            RestHandler restHandler = RestFactory.getRestHandler();
            LinkedHashSet artifacts = new LinkedHashSet();
            for (String searchCoordinate : this._searchCoordinates) {
                String[] split = searchCoordinate.split(":");
                String group = split[0];
                if (StringUtil.isNullOrEmpty((String)group, (boolean)true)) {
                    group = null;
                }
                String artifact = null;
                if (split.length > 1 && StringUtil.isNullOrEmpty((String)(artifact = split[1]), (boolean)true)) {
                    artifact = null;
                }
                String version = null;
                if (split.length > 2 && StringUtil.isNullOrEmpty((String)(version = split[2]), (boolean)true)) {
                    version = null;
                }
                String classifier = null;
                if (split.length > 3 && StringUtil.isNullOrEmpty((String)(classifier = split[3]), (boolean)true)) {
                    classifier = null;
                }
                for (Repository repository : this._repoCommonConfig.getRemoteRepositories()) {
                    GavcSearchResult gavcSearchResult = restHandler.gavcSearch(group, artifact, version, classifier, repository);
                    artifacts.addAll(gavcSearchResult.getArtifacts());
                }
            }
            _log.info("Search returned the following artifacts: " + artifacts);
            for (Artifact artifact : artifacts) {
                _log.info("Processing artifact " + artifact);
                Module module = DependencyManagementFactory.getInstance().getModule(artifact.getGroup(), artifact.getName(), artifact.getVersion(), artifact.getType());
                module.setModuleType(dependencyFileType.name());
                if (!restHandler.artifactExists(module.getModuleArtifact(), this._repoCommonConfig.getRemoteRepositories())) {
                    _log.info("Module artifact generation required: " + module);
                    File moduleFile = new File(System.getProperty("java.io.tmpdir"), module.getModuleArtifact().getFileName());
                    DependencyManagementFactory.getInstance().getDependencyFileHandler(dependencyFileType).writeDependenciesFile(module, moduleFile);
                    restHandler.deployArtifact(module.getModuleArtifact(), this._destinationRepo, moduleFile);
                    moduleFile.delete();
                    continue;
                }
                _log.info("Module artifact \"" + module + "\" already exists for artifact \"" + artifact + "\"");
            }
        }
        catch (RepositoryCommonException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RepositoryCommonException(e);
        }
    }

    public static void main(String[] args) {
        int retVal = 0;
        try {
            LinkedHashMap<String, String> additionalArguments = new LinkedHashMap<String, String>();
            additionalArguments.put("searchCoordinates", "<group:name:version:classifier>,...");
            additionalArguments.put("moduleType", "<type>");
            additionalArguments.put("destRepo", "<destRepo>");
            RepoCommonConfig repoCommonConfig = ModuleGenerator.getRepoCommonConfig(args, additionalArguments);
            String searchCoordinates = null;
            String moduleType = null;
            Repository destRepo = null;
            Map<String, String> additionalArgumentValues = ModuleGenerator.getAdditionalArgumentValues();
            if (additionalArgumentValues != null && !additionalArgumentValues.isEmpty()) {
                searchCoordinates = additionalArgumentValues.get("searchCoordinates");
                moduleType = additionalArgumentValues.get("moduleType");
                String value = additionalArgumentValues.get("destRepo");
                if (!StringUtil.isNullOrEmpty((String)value, (boolean)true)) {
                    destRepo = RestFactory.getRepository(null, (String)value, null, null);
                }
            }
            if (StringUtil.isNullOrEmpty(searchCoordinates, (boolean)true)) {
                throw new CommonCommandLine.CommonCommandLineException("The searchCoordinates option is required.");
            }
            List<String> split = Arrays.asList(searchCoordinates.split(","));
            ModuleGenerator moduleModifier = new ModuleGenerator(repoCommonConfig, split, moduleType, destRepo);
            moduleModifier.generate();
        }
        catch (CommonCommandLine.CommonCommandLineException e) {
            System.out.println(e.getMessage());
            ModuleGenerator.printUsage(ModuleGenerator.class);
            retVal = -1;
        }
        catch (Exception e) {
            _log.log(Level.SEVERE, "The module generation failed.", e);
            e.printStackTrace();
            retVal = -1;
        }
        System.exit(retVal);
    }
}

