/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.repository.common.threads;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class LoggedOutputThread
extends Thread {
    private InputStream _is;
    private Logger _log;
    private Level _level;

    public LoggedOutputThread(InputStream is, String name) {
        this(is, name, null);
    }

    public LoggedOutputThread(InputStream is, String name, Level level) {
        this(is, name, null, level);
    }

    public LoggedOutputThread(InputStream is, String name, Logger log, Level level) {
        super(name);
        this._is = is;
        this._log = log != null ? log : Logger.getLogger(LoggedOutputThread.class.getName());
        this._level = level != null ? level : Level.INFO;
    }

    @Override
    public void run() {
        try {
            String input;
            BufferedReader br = new BufferedReader(new InputStreamReader(this._is));
            while ((input = br.readLine()) != null) {
                this._log.log(this._level, input);
            }
        }
        catch (IOException e) {
            this._log.log(Level.SEVERE, e.getMessage(), e);
        }
    }
}

