/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.PrintWriter;
import java.io.StringWriter;
import oracle.opatch.opatchsdk.OPatchFAStep;

public class OPatchStepOperation {
    private OPatchFAStep step = null;
    private String message = "";
    private RuntimeException excep = null;
    private boolean isSuccess = true;
    private String userErrorMsg = "";
    private String errorCode = "0";

    public OPatchStepOperation(OPatchFAStep step) {
        this.step = step;
    }

    public OPatchFAStep getStep() {
        return this.step;
    }

    protected void setStepMessage(String message) {
        this.message = message;
    }

    public String getStepDescription() {
        return this.message;
    }

    public RuntimeException getExceptionTrace() {
        return this.excep;
    }

    protected void setStatus(boolean in) {
        this.isSuccess = in;
    }

    protected void setExceptionTrace(RuntimeException e) {
        this.excep = e;
    }

    public boolean isSuccess() {
        return this.isSuccess;
    }

    public String getUserErrorMsg() {
        return this.userErrorMsg;
    }

    protected void setUserErrorMsg(String msg) {
        this.userErrorMsg = msg;
    }

    public String getErrorCode() {
        return this.errorCode;
    }

    protected void setErrorCode(String errorCode) {
        if (!this.isSuccess) {
            this.errorCode = errorCode;
        }
    }

    public String toString() {
        StringBuffer buff = new StringBuffer("");
        if (this.step == null) {
            return "";
        }
        buff.append("[Step : " + this.step.toString() + ", Message : \"" + this.message + "\"");
        buff.append(", Operation Status : \"" + this.isSuccess + "\"");
        if (!this.isSuccess) {
            buff.append(", Error Code : \"" + this.errorCode + "\"");
            String exceptionAsString = "";
            String excepMsg = "";
            if (this.excep != null) {
                Throwable t = this.excep;
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                StringWriter sw = new StringWriter();
                t.printStackTrace(new PrintWriter(sw));
                exceptionAsString = sw.toString();
            }
            if (!(excepMsg = this.getExceptionMessage()).equals("")) {
                buff.append(", Exception message is: \"" + excepMsg + "\"");
            }
            buff.append(", User error message is: \"" + this.userErrorMsg + "\"");
            if (!exceptionAsString.equals("")) {
                buff.append(", Exception trace is:\n" + exceptionAsString + "]");
            } else {
                buff.append("]");
            }
        } else {
            buff.append("]");
        }
        return buff.toString();
    }

    public String getExceptionMessage() {
        if (!this.isSuccess && this.excep != null) {
            Throwable t = this.excep;
            while (t.getCause() != null) {
                t = t.getCause();
            }
            return t.getMessage();
        }
        return "";
    }
}

