/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import oracle.opatch.OPatchEnv;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchSDKStringConstants;
import oracle.opatch.wrappers.WrapperFactory;

public class OPatchStandAloneDeployAction
extends OPatchFAAutomationAction {
    private String relativeDeployFilePath = "";
    private String deployFileName = "";
    private String tempStorage = "StandAloneDeploy";

    private OPatchStandAloneDeployAction() {
    }

    protected OPatchStandAloneDeployAction(String deployName, String relativePath) {
        this.deployFileName = deployName;
        this.relativeDeployFilePath = relativePath;
    }

    protected void setRelativeDeployFilePath(String relativePath) {
        this.relativeDeployFilePath = relativePath;
    }

    public String getRelativeDeployFilePath() {
        return this.relativeDeployFilePath;
    }

    protected void setDeployFileName(String fileName) {
        this.deployFileName = fileName;
    }

    public String getDeployFileName() {
        return this.deployFileName;
    }

    public String getCompleteDeployFilePath() {
        StringBuffer buff = new StringBuffer();
        buff.append(this.getOracleHome());
        buff.append(File.separator);
        buff.append(this.getRelativeDeployFilePath());
        buff.append(File.separator);
        buff.append(this.getDeployFileName());
        return buff.toString();
    }

    @Override
    protected Map constructMap() {
        Path f;
        HashMap<String, String> env = new HashMap<String, String>();
        String tempLoc = OPatchEnv.getPatchStorageDirectoryPath((String)this.getOracleHome()) + File.separator + this.tempStorage;
        if (tempLoc != null && !tempLoc.equals("") && !Files.exists(f = WrapperFactory.getNioServiceWrapper().getPath(tempLoc, new String[0]), new LinkOption[0])) {
            try {
                Files.createDirectories(f, new FileAttribute[0]);
            }
            catch (IOException e) {
                OLogger.debug((String)e.getMessage());
            }
        }
        env.put(OPatchSDKStringConstants.TEMP_WORK_LOCATION, tempLoc);
        env.put("OPatch.ORACLE_HOME", this.getOracleHome());
        env.put("OPatch.RELATIVE_DEPLOY_PATH", this.getOracleHome());
        return env;
    }

    @Override
    public Object clone() {
        OPatchStandAloneDeployAction dAction = (OPatchStandAloneDeployAction)super.clone();
        dAction.setDeployFileName(this.getDeployFileName());
        dAction.setRelativeDeployFilePath(this.getRelativeDeployFilePath());
        return dAction;
    }
}

