/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.HashMap;
import java.util.Map;
import model.common.AbstractBaseTarget;
import model.fafmw.NodeManager;
import model.fafmw.WLAdminServer;
import model.fafmw.WLDomain;
import model.fafmw.WLServer;
import oracle.opatch.FMWClientFactory;
import oracle.opatch.fmwclient.FMWClient;
import oracle.opatch.opatchlogger.OLogger;
import oracle.opatch.opatchsdk.OPatchConfigWLDomain;
import oracle.opatch.opatchsdk.OPatchException;
import oracle.opatch.opatchsdk.OPatchFAAutomationAction;
import oracle.opatch.opatchsdk.OPatchFAClonedConfigInstance;
import oracle.opatch.opatchsdk.OPatchFAConfigContext;
import oracle.opatch.opatchsdk.OPatchFAOperation;
import oracle.opatch.opatchsdk.OPatchFAStep;
import oracle.opatch.opatchsdk.OPatchFATarget;
import oracle.opatch.opatchsdk.OPatchPatch;
import oracle.opatch.opatchsdk.OPatchStartException;
import oracle.opatch.opatchsdk.OPatchStepOperation;
import oracle.opatch.opatchsdk.OPatchStopException;
import oracle.opatch.opatchsdk.OPatchUtils;

public class OPatchJEELifecycleAction
extends OPatchFAAutomationAction {
    private WLServer server = null;
    private WLDomain domainInfo = null;
    private NodeManager nm = null;
    private FMWClient client;
    private boolean noCloseConnection = false;

    public OPatchJEELifecycleAction(OPatchFAClonedConfigInstance instance, WLServer server, WLDomain domainInfo, NodeManager nm) throws OPatchException {
        this.bindToClone(instance, domainInfo, nm, server);
    }

    public String getTargetName() {
        if (this.server == null) {
            return "";
        }
        return this.server.getName();
    }

    public WLDomain getBoundDomain() {
        return this.domainInfo;
    }

    protected WLServer getBoundServer() {
        return this.server;
    }

    @Override
    protected Map constructMap() {
        HashMap<String, Object> env = new HashMap<String, Object>();
        WLAdminServer adminServer = this.domainInfo.getWLAdminServer();
        String adminURL = adminServer.getURL();
        int adminPort = adminServer.getPort();
        String admP = adminServer.getPassword();
        String admUN = adminServer.getUserName();
        String nmUserName = this.nm.getUsername();
        String nmPassword = this.nm.getPassword();
        env.put("OPatch.ORACLE_HOME", this.getOracleHome());
        env.put("OPatch.COMMON_COMPONENTS_HOME", this.getCommonComponentsHome());
        env.put("AdminServerURL", adminURL + ":" + new Integer(adminPort).toString());
        env.put("ASP", admP.toCharArray());
        env.put("AdminUser", admUN);
        env.put("NodeManagerUser", nmUserName);
        env.put("NMP", nmPassword.toCharArray());
        return env;
    }

    @Override
    public String toString() {
        StringBuffer buff = new StringBuffer("[JEE Life Cycle Action:");
        buff.append("Server Name  = " + this.getTargetName() + "]");
        return buff.toString();
    }

    protected void bindToClone(OPatchFAClonedConfigInstance faInstance, WLDomain domainInfo, NodeManager nm, WLServer server) throws OPatchException {
        if (faInstance == null) {
            throw new OPatchException("Please provide a non-null <OPatchFAClonedConfigInstance> object.");
        }
        if (!(OPatchUtils.checkFAObjectSanity(faInstance, (AbstractBaseTarget)domainInfo) && OPatchUtils.checkFAObjectSanity(faInstance, (AbstractBaseTarget)nm) && OPatchUtils.checkFAObjectSanity(faInstance, (AbstractBaseTarget)server))) {
            throw new OPatchException("The system model object could not be binded to cloned config instances.");
        }
        this.setBoundToConfigInstance(true);
        this.domainInfo = domainInfo;
        this.nm = nm;
        this.server = server;
        OPatchFAConfigContext con = OPatchFATarget.getConfigContext();
        if (con == null) {
            con = new OPatchFAConfigContext();
        }
        con.addConfigWLDomain(domainInfo);
        OPatchConfigWLDomain domWrap = con.getWLDomain(domainInfo);
        if (domWrap != null) {
            domWrap.addManagedServer(server);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void doPrereq(OPatchFAOperation operation) throws OPatchException {
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        FMWClient client = null;
        String oracleHomePath = this.getOracleHome();
        OPatchPatch patch = this.getWrapperPatch();
        String logFile = "";
        this.setLogFile(logFile);
        OPatchException oe = null;
        try {
            if (!this.isArtifactBoundtoConfigInstance()) {
                String errorMsg = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                String stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                throw new OPatchException(errorMsg);
            }
            String domainName = "";
            if (this.domainInfo != null) {
                domainName = OPatchUtils.norm(this.domainInfo.getName());
            }
            try {
                logFile = OPatchUtils.initLogFile(oracleHomePath, OPatchFATarget.getLifeCycleTimeStamp(), "Prereq_Server_" + this.getTargetName() + "_" + domainName, this.getDisplayLogFile());
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg = "Check if log file is created properly for the operation.";
                String errorMsg = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg, errorMsg, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            try {
                this.client = client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), null);
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            try {
                if (operation != OPatchFAOperation.PREREQ_JEE_LIFECYCLE) {
                    String errorMsg = "OPatch does not support the operation \"" + operation.toString() + "\" for this artifact.";
                    String stepMsg = "Check if operation \"" + operation.toString() + "\" is supported.";
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_OPERATION_SUPPORTED, stepMsg, errorMsg, null);
                    this.setFailedPrereqStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                    OPatchException re = new OPatchException(errorMsg);
                    throw re;
                }
                client.prereq();
            }
            catch (Throwable t) {
                OPatchException re = new OPatchException("OPatch fails in prereq on the artifact. " + t.getMessage());
                re.setStackTrace(t.getStackTrace());
                throw re;
            }
        }
        catch (Throwable t) {
            try {
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                OPatchException re = new OPatchException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                oe = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                OPatchUtils.updatePrereq(client, this);
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                    this.setFailedClosingStep(failedStep);
                    OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
                }
                OPatchUtils.closeLogFile();
                if (!this.noCloseConnection && client != null) {
                    client.close();
                }
                if (oe == null) return;
                throw oe;
            }
        }
        OPatchUtils.updatePrereq(client, this);
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            String stepMsg = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
            this.setFailedClosingStep(failedStep);
            OLogger.justlog((int)OLogger.INFO, (String)failedStep.toString());
        }
        OPatchUtils.closeLogFile();
        if (!this.noCloseConnection && client != null) {
            client.close();
        }
        if (oe == null) return;
        throw oe;
    }

    protected FMWClient getClient() {
        return this.client;
    }

    protected void setNoCloseConnection(boolean noClose) {
        this.noCloseConnection = noClose;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void start() throws OPatchStartException {
        FMWClient client = null;
        OPatchStartException os = null;
        boolean updatePrereqFailure = false;
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        this.setFailedClosingStep(null);
        String oracleHomePath = "";
        String logFile = "";
        try {
            if (!this.isArtifactBoundtoConfigInstance()) {
                String errorMsg = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                String stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                throw new OPatchStartException(errorMsg);
            }
            oracleHomePath = this.getOracleHome();
            String domainName = "";
            if (this.domainInfo != null) {
                domainName = OPatchUtils.norm(this.domainInfo.getName());
            }
            try {
                logFile = OPatchUtils.initLogFile(oracleHomePath, OPatchFATarget.getLifeCycleTimeStamp(), "Start_Server_" + this.getTargetName() + "_" + domainName, this.getDisplayLogFile());
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg = "Check if log file is created properly for the operation.";
                String errorMsg = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg, errorMsg, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            try {
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), null);
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            client.start();
            OPatchUtils.updatePrereq(client, this);
            updatePrereqFailure = true;
            OPatchStepOperation prereqStep = this.getFailedPrereqStep();
            if (prereqStep != null) {
                throw new OPatchStartException("OPatch failed in prerequisite checks prior to start operation.");
            }
        }
        catch (Throwable t) {
            try {
                if (!updatePrereqFailure) {
                    OPatchUtils.updatePrereq(client, this);
                    updatePrereqFailure = true;
                }
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                OPatchStartException re = new OPatchStartException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                os = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                    this.setFailedClosingStep(failedStep);
                }
                OPatchUtils.closeLogFile();
                OPatchStepOperation prereqStep = this.getFailedPrereqStep();
                if (prereqStep != null) {
                    if (client != null) {
                        client.close();
                    }
                    if (os == null) return;
                    throw os;
                }
                OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.JEE_SERVER_START);
                this.setExecLogFile(execLog);
                OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), OPatchFATarget.getLifeCycleTimeStamp(), this);
                execLog = this.getExecLogFile();
                boolean failure = false;
                if (os != null) {
                    failure = true;
                }
                OPatchUtils.updateConfig(this.domainInfo, this.server, true, failure);
                this.setConfigLogFile(configLog);
                OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), this);
                configLog = this.getConfigLogFile();
                if (client != null) {
                    client.close();
                }
                if (os == null) return;
                throw os;
            }
        }
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            String stepMsg = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
            this.setFailedClosingStep(failedStep);
        }
        OPatchUtils.closeLogFile();
        OPatchStepOperation prereqStep = this.getFailedPrereqStep();
        if (prereqStep != null) {
            if (client != null) {
                client.close();
            }
            if (os == null) return;
            throw os;
        }
        OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.JEE_SERVER_START);
        this.setExecLogFile(execLog);
        OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), OPatchFATarget.getLifeCycleTimeStamp(), this);
        execLog = this.getExecLogFile();
        boolean failure = false;
        if (os != null) {
            failure = true;
        }
        OPatchUtils.updateConfig(this.domainInfo, this.server, true, failure);
        this.setConfigLogFile(configLog);
        OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), this);
        configLog = this.getConfigLogFile();
        if (client != null) {
            client.close();
        }
        if (os == null) return;
        throw os;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void stop() throws OPatchStopException {
        FMWClient client = null;
        OPatchStopException os = null;
        boolean updatePrereqFailure = false;
        OPatchStepOperation failedStep = null;
        this.setFailedPrereqStep(null);
        this.setFailedClosingStep(null);
        String oracleHomePath = "";
        String logFile = "";
        try {
            if (!this.isArtifactBoundtoConfigInstance()) {
                String errorMsg = "Please bind the FA config instance object to the artifact using bindToClone() API.";
                String stepMsg = "Check if artifact is bound to required end point instances from Cloned Configuration instance.";
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_BIND_TO_CLONE_ARTIFACT, stepMsg, errorMsg, null);
                this.setFailedPrereqStep(failedStep);
                throw new OPatchStopException(errorMsg);
            }
            oracleHomePath = this.getOracleHome();
            String domainName = "";
            if (this.domainInfo != null) {
                domainName = OPatchUtils.norm(this.domainInfo.getName());
            }
            try {
                logFile = OPatchUtils.initLogFile(oracleHomePath, OPatchFATarget.getLifeCycleTimeStamp(), "Stop_Server_" + this.getTargetName() + "_" + domainName, this.getDisplayLogFile());
                this.setLogFile(logFile);
            }
            catch (Throwable t) {
                String stepMsg = "Check if log file is created properly for the operation.";
                String errorMsg = t.getMessage();
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_INIT_LOG_FILE, stepMsg, errorMsg, new RuntimeException(t));
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            try {
                OPatchUtils.lockHome(oracleHomePath);
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to lock the Oracle Home \"" + oracleHomePath + "\"";
                String stepMsg = "Check if OPatch can lock the Oracle Home \"" + oracleHomePath + "\"";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_LOCK_HOME, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            try {
                client = FMWClientFactory.getClient((OPatchFAAutomationAction)this, (Map)this.constructMap(), null);
            }
            catch (Throwable t) {
                String errorMsg = "OPatch failed to get the FMW client for artifact execution (Internal OPatch issue)";
                String stepMsg = "Check if OPatch can get the client for artifact execution";
                RuntimeException re = new RuntimeException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_FA_CLIENT, stepMsg, errorMsg, re);
                this.setFailedPrereqStep(failedStep);
                throw t;
            }
            client.stop();
            OPatchUtils.updatePrereq(client, this);
            updatePrereqFailure = true;
            OPatchStepOperation prereqStep = this.getFailedPrereqStep();
            if (prereqStep != null) {
                throw new OPatchStopException("OPatch failed in prerequisite checks prior to stop operation.");
            }
        }
        catch (Throwable t) {
            try {
                if (!updatePrereqFailure) {
                    OPatchUtils.updatePrereq(client, this);
                    updatePrereqFailure = true;
                }
                while (t.getCause() != null) {
                    t = t.getCause();
                }
                OPatchStopException re = new OPatchStopException(t.getMessage());
                re.setStackTrace(t.getStackTrace());
                os = re;
            }
            catch (Throwable throwable) {
                throw throwable;
            }
            finally {
                try {
                    if (!oracleHomePath.equals("")) {
                        OPatchUtils.unlockHome(oracleHomePath);
                    }
                }
                catch (Throwable t2) {
                    String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
                    String stepMsg = "Check if OPatch can unlock the Oracle Home.";
                    RuntimeException re = new RuntimeException(t2.getMessage());
                    re.setStackTrace(t2.getStackTrace());
                    failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
                    this.setFailedClosingStep(failedStep);
                }
                OPatchUtils.closeLogFile();
                OPatchStepOperation prereqStep = this.getFailedPrereqStep();
                if (prereqStep != null) {
                    if (client != null) {
                        client.close();
                    }
                    if (os == null) return;
                    throw os;
                }
                OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.JEE_SERVER_STOP);
                this.setExecLogFile(execLog);
                OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), OPatchFATarget.getLifeCycleTimeStamp(), this);
                execLog = this.getExecLogFile();
                boolean failure = false;
                if (os != null) {
                    failure = true;
                }
                OPatchUtils.updateConfig(this.domainInfo, this.server, false, failure);
                this.setConfigLogFile(configLog);
                OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), this);
                configLog = this.getConfigLogFile();
                if (client != null) {
                    client.close();
                }
                if (os == null) return;
                throw os;
            }
        }
        try {
            if (!oracleHomePath.equals("")) {
                OPatchUtils.unlockHome(oracleHomePath);
            }
        }
        catch (Throwable t) {
            String errorMsg = "OPatch failed to unlock the Oracle Home \"" + oracleHomePath + "\"";
            String stepMsg = "Check if OPatch can unlock the Oracle Home.";
            RuntimeException re = new RuntimeException(t.getMessage());
            re.setStackTrace(t.getStackTrace());
            failedStep = OPatchUtils.constructFailedStep(OPatchFAStep.CHECK_UNLOCK_HOME, stepMsg, errorMsg, re);
            this.setFailedClosingStep(failedStep);
        }
        OPatchUtils.closeLogFile();
        OPatchStepOperation prereqStep = this.getFailedPrereqStep();
        if (prereqStep != null) {
            if (client != null) {
                client.close();
            }
            if (os == null) return;
            throw os;
        }
        OPatchUtils.updateExecutionContext(client, this, OPatchFAOperation.JEE_SERVER_STOP);
        this.setExecLogFile(execLog);
        OPatchUtils.logExecutionContext(oracleHomePath, this.getOperatingFAContext(), OPatchFATarget.getLifeCycleTimeStamp(), this);
        execLog = this.getExecLogFile();
        boolean failure = false;
        if (os != null) {
            failure = true;
        }
        OPatchUtils.updateConfig(this.domainInfo, this.server, false, failure);
        this.setConfigLogFile(configLog);
        OPatchUtils.logConfigContext(oracleHomePath, OPatchFATarget.getConfigContext(), OPatchFATarget.getLifeCycleTimeStamp(), this);
        configLog = this.getConfigLogFile();
        if (client != null) {
            client.close();
        }
        if (os == null) return;
        throw os;
    }
}

