/*
 * Decompiled with CFR 0.152.
 */
package oracle.opatch.opatchsdk;

import java.util.ArrayList;
import java.util.GregorianCalendar;
import model.fafmw.NodeManager;
import model.fafmw.WLDomain;
import oracle.opatch.opatchsdk.OPatchConfigNodeManager;
import oracle.opatch.opatchsdk.OPatchConfigWLDomain;

public class OPatchFAConfigContext {
    private ArrayList<OPatchConfigWLDomain> configWLDomain = new ArrayList();
    private ArrayList<OPatchConfigNodeManager> configNM = new ArrayList();

    protected OPatchFAConfigContext() {
    }

    protected void addConfigWLDomain(WLDomain domain) {
        OPatchConfigWLDomain domainWrapper;
        if (this.configWLDomain == null) {
            this.configWLDomain = new ArrayList();
        }
        if (!this.configWLDomain.contains(domainWrapper = new OPatchConfigWLDomain(domain))) {
            this.configWLDomain.add(new OPatchConfigWLDomain(domain));
        }
    }

    protected void addConfigNodeManager(NodeManager nm) {
        OPatchConfigNodeManager nodeWrapper;
        if (this.configNM == null) {
            this.configNM = new ArrayList();
        }
        if (!this.configNM.contains(nodeWrapper = new OPatchConfigNodeManager(nm))) {
            this.configNM.add(nodeWrapper);
        }
    }

    public OPatchConfigWLDomain getWLDomain(WLDomain domain) {
        OPatchConfigWLDomain[] setDomains = this.getWLDomains();
        for (int i = 0; i < setDomains.length; ++i) {
            if (setDomains[i].getWLDomain() != domain) continue;
            return setDomains[i];
        }
        return null;
    }

    public OPatchConfigWLDomain[] getWLDomains() {
        OPatchConfigWLDomain[] domainObj = new OPatchConfigWLDomain[]{};
        if (this.configWLDomain == null) {
            return domainObj;
        }
        domainObj = new OPatchConfigWLDomain[this.configWLDomain.size()];
        this.configWLDomain.toArray(domainObj);
        return domainObj;
    }

    public OPatchConfigNodeManager[] getNodeManagers() {
        OPatchConfigNodeManager[] nodeObj = new OPatchConfigNodeManager[]{};
        if (this.configNM == null) {
            return nodeObj;
        }
        nodeObj = new OPatchConfigNodeManager[this.configNM.size()];
        this.configNM.toArray(nodeObj);
        return nodeObj;
    }

    protected ArrayList<OPatchConfigWLDomain> getConfigWLDomains() {
        return this.configWLDomain;
    }

    protected ArrayList<OPatchConfigNodeManager> getConfigNodeManagers() {
        return this.configNM;
    }

    public String toString() {
        int i;
        StringBuffer buff = new StringBuffer("");
        buff.append("\nTime of update: " + new GregorianCalendar().getTime().toString() + "");
        buff.append("\nUpdated Configuration context:");
        if (this.configWLDomain == null || this.configWLDomain.size() == 0) {
            buff.append("\n[No Weblogic Domains recorded]\n");
        } else {
            buff.append("\nDomain:SOA Composite-SOA Resource Bundle-SOA Servers-Managed Servers association:\n");
            OPatchConfigWLDomain[] domains = this.getWLDomains();
            for (i = 0; i < domains.length; ++i) {
                buff.append(domains[i].toString() + "\n");
            }
        }
        if (this.configNM == null || this.configNM.size() == 0) {
            buff.append("\n[No Node Managers recorded]\n");
        } else {
            buff.append("\nList of Node Managers:\n");
            OPatchConfigNodeManager[] nm = this.getNodeManagers();
            for (i = 0; i < nm.length; ++i) {
                buff.append(nm[i].toString() + "\n");
            }
        }
        buff.append("\n");
        return buff.toString();
    }
}

