/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.common.util.StringSubstitutionUtility;
import com.oracle.cie.common.util.WildcardFileFilter;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Level;

@TaskDescription(name="substituteString")
public class SubstituteStringTask
extends AbstractSilentTask {
    private boolean _recurse = false;
    private boolean _swapSlashes = false;
    private String _filePath = null;
    private File _file = null;
    private String _wildcard = null;
    private String _string = null;
    private String _replace = null;
    private boolean _list = false;

    private boolean hasValidStringSubsParam() {
        this._logger.finer("Validating values for replacment...");
        if (this._string == null || this._string.equals("")) {
            this._logger.severe("Error -- String to replace not set.");
            return false;
        }
        if (!this._list) {
            this._string = this._context.substitute(this._namespace, this._string);
        }
        if (this._replace == null || this._replace.equals("")) {
            this._logger.finer("Replacement String null or not set, using \"\"");
            this._replace = "";
        } else if (!this._list) {
            this._replace = this._context.substitute(this._namespace, this._replace);
        }
        if (this._filePath == null || this._filePath.equals("")) {
            this._logger.severe("Error -- File to replace not set.");
            return false;
        }
        this._filePath = this._context.substitute(this._namespace, this._filePath);
        if (this._filePath == null || this._filePath.equals("")) {
            this._logger.severe("Error -- File to replace null or empty after substitute.");
            return false;
        }
        this._file = new File(this._filePath);
        if (!this._file.exists()) {
            this._logger.severe("Error -- File to replace did not exist.");
            return false;
        }
        if (!this._file.isDirectory() && this._wildcard != null) {
            this._logger.finer("Wildcard set on non-directory replacement, it will be ignored...");
        }
        this._logger.finer("--* Replacing \"" + this._string + "\" with \"" + this._replace + "\"");
        this._logger.finer("--*  in file/directory " + this._file.getPath());
        return true;
    }

    @Override
    public void execute() throws TaskExecutionException {
        if (!this.hasValidStringSubsParam()) {
            return;
        }
        Map<String, String> changeDataMap = this.parseList(this._string, this._replace);
        WildcardFileFilter filter = null;
        if (this._file.isDirectory()) {
            filter = new WildcardFileFilter(this._wildcard, this._recurse);
        }
        try {
            this.replace(this._file, changeDataMap, (FileFilter)filter);
        }
        catch (IOException e) {
            this._logger.log(Level.SEVERE, "Exception doing replace.", e);
        }
    }

    private void replace(File file, Map changeDataMap, FileFilter filter) throws IOException {
        if (file.isDirectory()) {
            File[] files;
            for (File f : files = file.listFiles(filter)) {
                this.replace(f, changeDataMap, filter);
            }
        } else {
            StringSubstitutionUtility.globalStrSubst((String)file.getPath(), (Map)changeDataMap, (Locale)this._context.getLocale());
        }
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setFile(String file) {
        this._filePath = file;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setWildcard(String wildcard) {
        this._wildcard = wildcard;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setRecurse(String recurse) {
        this._recurse = recurse.equalsIgnoreCase("true");
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setString(String string) {
        this._string = string;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setReplace(String replace) {
        this._replace = replace;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setSwapSlashes(String swap) {
        this._swapSlashes = swap.equalsIgnoreCase("true");
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setList(String list) {
        this._list = list.equalsIgnoreCase("true");
    }

    public Map<String, String> parseList(String before, String after) {
        HashMap<String, String> map = new HashMap<String, String>();
        if (this._list) {
            StringTokenizer beforeSt = new StringTokenizer(before, ",");
            StringTokenizer afterSt = new StringTokenizer(after, ",");
            if (beforeSt.countTokens() != afterSt.countTokens()) {
                this._logger.severe("The tokens to be replaced don't match. The string has " + beforeSt.countTokens() + " and the replacement has " + afterSt.countTokens());
                return null;
            }
            while (beforeSt.hasMoreTokens()) {
                String beforeStr = this._context.substitute(this._namespace, beforeSt.nextToken());
                String afterStr = this._context.substitute(this._namespace, afterSt.nextToken());
                if (this._logger.isLoggable(Level.FINER)) {
                    this._logger.finer("Will replace " + beforeStr + " with " + afterStr);
                }
                if (this._swapSlashes) {
                    map.put(beforeStr.replace('\\', '/'), afterStr.replace('\\', '/'));
                    continue;
                }
                map.put(beforeStr, afterStr);
            }
        } else if (this._swapSlashes) {
            map.put(before.replace('\\', '/'), after.replace('\\', '/'));
        } else {
            map.put(before, after);
        }
        return map;
    }
}

