/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.helpers.SetTaskHelper;
import com.oracle.cie.wizard.silent.tasks.AbstractSetSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.lang.reflect.Method;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.logging.Level;

@TaskDescription(name="stringEval", cachingPolicy=TaskCachingPolicy.REUSE)
public class StringEvaluationTask
extends AbstractSetSilentTask {
    private String _arg1;
    private SetTaskHelper.AttrType _arg1Type = SetTaskHelper.AttrType.os_key;
    private String _arg2;
    private SetTaskHelper.AttrType _arg2Type = SetTaskHelper.AttrType.os_key;
    private String _eval;

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setArg1(String arg1) {
        this._arg1 = arg1;
    }

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"value", "os_key", "os_subst", "rs_key", "rs_subst"}, defaultValue="os_key")
    public void setArg1Type(String arg1Type) {
        try {
            this._arg1Type = SetTaskHelper.AttrType.valueOf(arg1Type);
        }
        catch (Exception ex) {
            this._logger.warning("Unsupported keyType: " + arg1Type + ". Supported values: " + Arrays.toString((Object[])SetTaskHelper.AttrType.values()));
        }
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setArg2(String arg2) {
        this._arg2 = arg2;
    }

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"value", "os_key", "os_subst", "rs_key", "rs_subst"}, defaultValue="os_key")
    public void setArg2Type(String arg2Type) {
        try {
            this._arg2Type = SetTaskHelper.AttrType.valueOf(arg2Type);
        }
        catch (Exception ex) {
            this._logger.warning("Unsupported keyType: " + (Object)((Object)this._arg2Type) + ". Supported values: " + Arrays.toString((Object[])SetTaskHelper.AttrType.values()));
        }
    }

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"equals", "equalsIgnoreCase", "notEquals", "contains", "notContains", "isNull", "isNotNull", "isNullOrEmpty", "isNotNullOrEmpty"}, required=true)
    public void setEval(String eval) {
        this._eval = eval;
    }

    @Override
    public void execute() throws TaskExecutionException {
        Method method = null;
        try {
            String str1 = this.getAttributeValue(this._arg1Type, this._arg1);
            String str2 = this.getAttributeValue(this._arg2Type, this._arg2);
            Class<?> clazz = this.getClass();
            method = clazz.getMethod(this._eval, String.class, String.class);
            Object[] arguments = new Object[]{str1, str2};
            this._logger.finer("Invoking Method: " + method.toString() + " with parameters: (" + arguments[0] + ", " + arguments[1] + ")");
            this.setKeyOnTarget(String.valueOf(method.invoke((Object)this, arguments)));
        }
        catch (Exception x) {
            String msg = "Unable to instantiate method: " + (method != null ? method.getName() : this._eval);
            this._logger.log(Level.SEVERE, msg, x);
            try {
                msg = MessageFormat.format(this._context.getI18nString("wizard", "StingEvaluation.error.msg"), method != null ? method.getName() : this._eval);
            }
            catch (Exception exception) {
                // empty catch block
            }
            throw new TaskExecutionException(this, msg, x);
        }
    }

    @Override
    public void unconfigure() {
        super.unconfigure();
        this._arg1 = null;
        this._arg1Type = SetTaskHelper.AttrType.os_key;
        this._arg2 = null;
        this._arg2Type = SetTaskHelper.AttrType.os_key;
        this._eval = null;
    }

    public boolean equalsIgnoreCase(String str1, String str2) {
        return str1 != null && str1.equalsIgnoreCase(str2);
    }

    public boolean equals(String str1, String str2) {
        return str1 != null && str1.equals(str2);
    }

    public boolean notEquals(String str1, String str2) {
        return !this.equals(str1, str2);
    }

    public boolean contains(String str1, String str2) {
        return str1 != null && str1.indexOf(str2) != -1;
    }

    public boolean notContains(String str1, String str2) {
        return !this.contains(str1, str2);
    }

    public boolean isNull(String str1, String str2) {
        return str1 == null;
    }

    public boolean isNotNull(String str1, String str2) {
        return str1 != null;
    }

    public boolean isNullOrEmpty(String str1, String str2) {
        return str1 == null || str1.isEmpty();
    }

    public boolean isNotNullOrEmpty(String str1, String str2) {
        return str1 != null && !str1.isEmpty();
    }
}

