/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.ext.OperationException;
import com.oracle.cie.wizard.ext.SilentOperationHelper;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskContext;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.logging.Level;

@TaskDescription(name="silentOperationExecution")
public class SilentOperationExecutionTask
extends AbstractSilentTask {
    private SilentOperationHelper _helper;
    private String _helperClassName;

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"com.oracle.cie.wizard.ext.SilentOperationHelper"}, required=true)
    public void setOperationHelperClass(String clazz) {
        this._helperClassName = clazz;
    }

    @Override
    public void configure(TaskContext context) throws TaskExecutionException {
        super.configure(context);
        try {
            this._helperClassName = this._context.substitute(this._namespace, this._helperClassName);
            ClassLoader classLoader = SilentOperationExecutionTask.class.getClassLoader();
            Class<?> loaderClass = classLoader.loadClass(this._helperClassName);
            this._helper = (SilentOperationHelper)loaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
            if (this._helper == null) {
                throw new TaskExecutionException(this, "Unable to initialze SilentOperationHelper class :: " + this._helperClassName);
            }
        }
        catch (TaskExecutionException e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw new TaskExecutionException(this, "Unable to load SilentOperationHelper class :: " + this._helperClassName, e);
        }
    }

    @Override
    public void execute() throws TaskExecutionException {
        try {
            this._helper.execute();
        }
        catch (OperationException e) {
            this._logger.log(Level.SEVERE, "Failed to execute the silent operation", e);
            throw new TaskExecutionException(this, "Failed to execute the silent operation", e);
        }
    }
}

