/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.helpers.SetTaskHelper;
import com.oracle.cie.wizard.silent.tasks.AbstractSetSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.util.Arrays;

@TaskDescription(name="set", cachingPolicy=TaskCachingPolicy.REUSE)
public class SetKeyOnTargetTask
extends AbstractSetSilentTask {
    private String _value;
    private SetTaskHelper.AttrType _valueType = SetTaskHelper.AttrType.os_subst;

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setValue(String value) {
        this._value = value;
    }

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"value", "os_key", "os_subst", "rs_key", "rs_subst"}, defaultValue="os_subst")
    public void setValueType(String valueType) {
        try {
            this._valueType = SetTaskHelper.AttrType.valueOf(valueType);
        }
        catch (Exception ex) {
            this._logger.warning("Unsupported keyType: " + valueType + ". Supported values: " + Arrays.toString((Object[])SetTaskHelper.AttrType.values()));
        }
    }

    @Override
    public void execute() throws TaskExecutionException {
        this.setKeyOnTarget(this.getAttributeValue(this._valueType, this._value));
    }

    @Override
    public void unconfigure() {
        super.unconfigure();
        this._value = null;
        this._valueType = SetTaskHelper.AttrType.os_subst;
    }
}

