/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.text.MessageFormat;
import java.util.logging.Level;

@TaskDescription(name="loadResources", cachingPolicy=TaskCachingPolicy.REUSE)
public class LoadResourcesTask
extends AbstractSilentTask {
    protected boolean _abort = true;
    protected String _baseName = "";
    protected boolean _reload = false;
    protected String _jar = null;
    protected String _bundleNamespace = null;

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setBaseName(String bn) {
        this._baseName = bn;
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="true")
    public void setAbort(String abort) {
        this._abort = Boolean.parseBoolean(abort);
    }

    @TaskAttribute(type=TaskAttributeType.BOOLEAN, defaultValue="false")
    public void setReload(String reload) {
        this._reload = Boolean.parseBoolean(reload);
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setJar(String jar) {
        this._jar = jar;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setBundleNamespace(String namespace) {
        this._bundleNamespace = namespace;
    }

    @Override
    public void execute() throws TaskExecutionException {
        this._baseName = this._context.substitute(this._namespace, this._baseName);
        if (this._bundleNamespace == null) {
            this._bundleNamespace = this._namespace;
        }
        try {
            if (this._reload) {
                ResourceBundleManager.releaseBundle((String)this._bundleNamespace, (String)this._baseName);
            }
            if (this._jar != null) {
                File jar = new File(this._context.substitute(this._namespace, this._jar));
                final URL[] urls = new URL[]{jar.toURI().toURL()};
                ClassLoader cl = AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

                    @Override
                    public ClassLoader run() {
                        return new URLClassLoader(urls){

                            @Override
                            public URL getResource(String name) {
                                URL parentURL = super.getResource(name);
                                URL url = this.findResource(name);
                                return url != null ? url : parentURL;
                            }
                        };
                    }
                });
                ResourceBundleManager.manageBundle((String)this._bundleNamespace, (String)this._baseName, (ClassLoader)cl);
            } else {
                ResourceBundleManager.manageBundle((String)this._bundleNamespace, (String)this._baseName);
            }
        }
        catch (Exception mrx) {
            if (this._abort) {
                String msg;
                this._logger.log(Level.SEVERE, "Error loading ResourceBundle " + this._baseName, mrx);
                try {
                    msg = MessageFormat.format(this._context.getI18nString("wizard", "LoadResourcesTask.error.msg"), this._baseName);
                }
                catch (Exception ex) {
                    msg = "Error loading resource bundle: " + this._baseName;
                }
                throw new TaskExecutionException(this, msg, mrx);
            }
            this._logger.log(Level.FINER, "Unable to load optional ResourceBundle " + this._baseName);
        }
    }

    @Override
    public void unconfigure() {
        this._jar = null;
        this._bundleNamespace = null;
    }
}

