/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.ext.OperationInput;
import com.oracle.cie.wizard.ext.impl.OperationInputImpl;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;

@TaskDescription(name="generateResponseFile")
public class GenerateResponseFileTask
extends AbstractSilentTask {
    private static final String RESPONSE_FILE_NAME_PREFIX = "responseFile";
    private static final String RESPONSE_FILE_NAME_SUFFIX = ".rsp";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute() throws TaskExecutionException {
        if (!OperationInputImpl.isInitialized()) {
            this._logger.log(Level.INFO, "Failed to generate response file as the OperationInput is not initialized");
            return;
        }
        OperationInput operationInput = OperationInputImpl.getInstance();
        boolean record = operationInput.isOptionSet(WizardConfiguration.RECORD.getName());
        String responseFilePath = operationInput.getOptionValue(WizardConfiguration.RESPONSE_FILE.getName());
        FileOutputStream fileOut = null;
        if (record && !StringUtil.isNullOrEmpty((String)responseFilePath)) {
            File responseFile = new File(responseFilePath);
            boolean exist = responseFile.exists();
            try {
                if (exist && responseFile.isDirectory()) {
                    File newResponseFile = File.createTempFile(RESPONSE_FILE_NAME_PREFIX, RESPONSE_FILE_NAME_SUFFIX, responseFile);
                    this._logger.log(Level.INFO, "The given response file points to a directory:" + responseFile.getAbsolutePath() + ", generating a new response file:" + newResponseFile.getAbsolutePath());
                    responseFile = newResponseFile;
                } else if (!exist) {
                    this.createParentDirectory(responseFile);
                }
                Properties properties = new Properties();
                for (Map.Entry<String, Object> entry : operationInput.getAllVariables().entrySet()) {
                    properties.setProperty(entry.getKey(), entry.getValue() != null ? String.valueOf(entry.getValue()) : "");
                }
                fileOut = new FileOutputStream(responseFile);
                properties.store(fileOut, "Response file");
                fileOut.close();
            }
            catch (IOException e) {
                this._logger.log(Level.WARNING, "Failed to generate response file:" + responseFile.getAbsolutePath(), e);
            }
            finally {
                if (fileOut != null) {
                    try {
                        fileOut.close();
                    }
                    catch (IOException e) {
                        this._logger.log(Level.FINEST, "Failed to close response file:" + responseFilePath, e);
                    }
                }
            }
        } else {
            this._logger.log(Level.INFO, "The necessary parameters (record:" + record + ", responseFile: " + responseFilePath + ") to generate response file are not provided");
        }
    }

    private void createParentDirectory(File fileName) {
        File parentDir = fileName.getParentFile();
        if (!parentDir.exists()) {
            this._logger.info("The parent directory of the specified file doesn't exists. Creating it...");
            parentDir.mkdirs();
        }
    }
}

