/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.wizard.helpers.IEvaluator;
import com.oracle.cie.wizard.silent.tasks.AbstractSetSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.text.MessageFormat;
import java.util.logging.Level;

@TaskDescription(name="evaluate", cachingPolicy=TaskCachingPolicy.REUSE)
public class EvaluateTask
extends AbstractSetSilentTask {
    protected String _classname;

    @TaskAttribute(type=TaskAttributeType.CLASS, typeConstraints={"com.oracle.cie.wizard.helpers.IEvaluator"}, required=true)
    public void setEvalClass(String classname) {
        this._classname = classname;
    }

    @Override
    public void execute() throws TaskExecutionException {
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Evaluating: " + this._classname);
        }
        try {
            Class<?> clazz = Class.forName(this._classname);
            IEvaluator eval = (IEvaluator)clazz.newInstance();
            boolean result = eval.evaluate(this._namespace, this._context);
            this.setKeyOnTarget(String.valueOf(result));
            if (this._logger.isLoggable(Level.FINER)) {
                this._logger.finer("Evaluation of " + this._classname + " was " + result);
            }
        }
        catch (Exception x) {
            String msg;
            this._logger.log(Level.SEVERE, "Unable to execute evaluator class: " + this._classname, x);
            try {
                msg = MessageFormat.format(this._context.getI18nString("wizard", "EvaluateTask.error.msg"), this._classname);
            }
            catch (Exception ignore) {
                msg = "Unable to execute evaluator class: " + this._classname;
            }
            throw new TaskExecutionException(this, msg, x);
        }
    }

    @Override
    public void unconfigure() {
        super.unconfigure();
        this._classname = null;
    }
}

