/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.silent.tasks;

import com.oracle.cie.common.util.Delete;
import com.oracle.cie.wizard.silent.tasks.AbstractSilentTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskCachingPolicy;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.io.File;

@TaskDescription(name="deleteFile", cachingPolicy=TaskCachingPolicy.REUSE)
public class DeleteFileTask
extends AbstractSilentTask {
    protected String _filepath = null;
    private String _resultKey;

    @TaskAttribute(type=TaskAttributeType.LITERAL, required=true)
    public void setFilePath(String file) {
        this._filepath = file;
    }

    @TaskAttribute(type=TaskAttributeType.OBJECT_STORE_KEY)
    public void setResultKey(String resultKey) {
        this._resultKey = resultKey;
    }

    @Override
    public void execute() throws TaskExecutionException {
        boolean fileExist = false;
        if (this._filepath != null) {
            this._filepath = this._context.substitute(this._namespace, this._filepath);
            if (!this._filepath.equals("")) {
                fileExist = true;
            }
        }
        if (!fileExist) {
            this._logger.warning("File not set, skipping task!");
            return;
        }
        boolean wasDeleted = false;
        File fileObject = new File(this._filepath);
        if (!fileObject.exists()) {
            this._logger.fine("File: " + this._filepath + " did not exist.");
        } else {
            this._logger.finer("Deleting file/directory '" + this._filepath + "'");
            wasDeleted = Delete.delete((File)fileObject);
            this._logger.finer("The file " + this._filepath + " was deleted? " + wasDeleted);
        }
        if (this._resultKey != null) {
            this._context.storeObject(this._namespace, this._resultKey, String.valueOf(wasDeleted));
        }
    }

    @Override
    public void unconfigure() {
        this._filepath = null;
        this._resultKey = null;
    }
}

