/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.wizard.internal.wcf.EntryElem;
import com.oracle.cie.wizard.internal.wcf.LoopRefElem;
import com.oracle.cie.wizard.internal.wcf.Subflow;
import com.oracle.cie.wizard.internal.wcf.Target;
import com.oracle.cie.wizard.internal.wcf.WCFElement;
import com.oracle.cie.wizard.internal.wcf.xml.ContinueType;
import com.oracle.cie.wizard.internal.wcf.xml.EntrySequenceType;
import com.oracle.cie.wizard.internal.wcf.xml.LoopParamsCollectionType;
import com.oracle.cie.wizard.internal.wcf.xml.LoopType;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

class LoopElem
extends EntryElem<LoopType> {
    protected String _namespace;
    protected String _loopId = ((LoopType)this.getXmlObject()).getLoopId();
    protected String _currValueKey;
    protected LoopBody _body;

    LoopElem(Subflow<?> sequence, LoopType entry) throws ExecPlanException {
        super(sequence, entry);
        this._namespace = ((LoopType)this.getXmlObject()).getNamespace();
        if (this._namespace == null) {
            this._namespace = this.getParentTarget().getNamespace();
        }
        this._currValueKey = ((LoopType)this.getXmlObject()).getLoopVarKey();
        if (this._currValueKey == null) {
            this._currValueKey = this._loopId + ".current.value";
        }
        this._body = new LoopBody(entry.getBody());
    }

    @Override
    public List<WCFElement> getDefaultElementList() throws ExecPlanException {
        return super.getDefaultElementList();
    }

    @Override
    public void removedFromWorkflow() throws ExecPlanException {
        this.getWorkflow().removeState(this._loopId);
        super.removedFromWorkflow();
    }

    @Override
    public void selectedOnNext() throws ExecPlanException {
        LoopParamsCollectionType iterParams = ((LoopType)this.getXmlObject()).getCollection();
        if (iterParams == null) {
            this.expandLoopBody(true);
        } else {
            Iterator iterator = (Iterator)this.getWorkflow().getState(this._loopId);
            if (iterator == null) {
                String collKey = iterParams.getCollectionKey();
                Object collObj = ObjectStoreManager.getObjectStore((String)this._namespace).retrieveObject((Object)collKey);
                if (collObj == null || !Collection.class.isAssignableFrom(collObj.getClass())) {
                    this._log.warning("Unable to load collection using namespace: " + this._namespace + " and key: " + collKey);
                    return;
                }
                Collection coll = (Collection)Collection.class.cast(collObj);
                if (coll.isEmpty()) {
                    this._log.warning("Collection loaded using namespace: " + this._namespace + " and key: " + collKey + " is empty.");
                    return;
                }
                iterator = coll.iterator();
                this.getWorkflow().setState(this._loopId, iterator);
            }
            if (iterator.hasNext()) {
                Object value = iterator.next();
                ObjectStoreManager.getObjectStore((String)this._namespace).storeObject((Object)this._currValueKey, value);
                this.expandLoopBody(true);
            } else {
                ObjectStoreManager.getObjectStore((String)this._namespace).removeObject((Object)this._currValueKey);
                this.getWorkflow().removeState(this._loopId);
                this.removeLoopBody();
            }
        }
    }

    @Override
    public void selectedOnPrev() throws ExecPlanException {
        this.getWorkflow().removeState(this._loopId);
        this.removeLoopBody();
    }

    String getLoopId() {
        return this._loopId;
    }

    LoopBody getLoopBody() {
        return this._body;
    }

    void expandLoopBody(boolean reexpand) throws ExecPlanException {
        if (this._body != null) {
            if (this.getWorkflow().getElementAfter(this) == this._body) {
                if (reexpand) {
                    this.getWorkflow().removeSubflow(this._body);
                    this.getWorkflow().addSubflow(this, this._body);
                }
            } else {
                this.getWorkflow().addSubflow(this, this._body);
            }
        }
    }

    void removeLoopBody() throws ExecPlanException {
        if (this._body != null && this.getWorkflow().getElementAfter(this) == this._body) {
            this.getWorkflow().removeSubflow(this._body);
        }
    }

    class LoopBody
    extends Subflow<EntrySequenceType> {
        protected LoopBody(EntrySequenceType sequence) throws ExecPlanException {
            super(LoopElem.this.getWorkflow(), sequence);
            this.loadEntries();
            this._entries.add(new LoopRefElem<ContinueType>(this, new ContinueType()));
        }

        @Override
        Target getTarget() {
            return LoopElem.this.getParentSequence().getTarget();
        }

        @Override
        EntryElem<?> getParentEntryElem() {
            return LoopElem.this;
        }
    }
}

