/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.wcf;

import com.oracle.cie.wizard.internal.wcf.EntryElem;
import com.oracle.cie.wizard.internal.wcf.Subflow;
import com.oracle.cie.wizard.internal.wcf.Target;
import com.oracle.cie.wizard.internal.wcf.WCFElement;
import com.oracle.cie.wizard.internal.wcf.WCFWrapper;
import com.oracle.cie.wizard.internal.wcf.xml.IncludeType;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import java.util.ArrayList;
import java.util.List;

class IncludeElem
extends EntryElem<IncludeType> {
    protected Target _includedTarget;

    IncludeElem(Subflow<?> sequence, IncludeType entry) throws ExecPlanException {
        super(sequence, entry);
    }

    @Override
    public List<WCFElement> getDefaultElementList() throws ExecPlanException {
        ArrayList<WCFElement> list = new ArrayList<WCFElement>();
        list.add(this);
        if (!((IncludeType)this.getXmlObject()).isLazyExpansion()) {
            list.addAll(this.getTarget().getDefaultElementList());
        }
        return list;
    }

    @Override
    public void selectedOnNext() throws ExecPlanException {
        if (((IncludeType)this.getXmlObject()).isLazyExpansion()) {
            this.getWorkflow().addSubflow(this, this.getTarget());
        }
    }

    @Override
    public void selectedOnPrev() throws ExecPlanException {
        if (((IncludeType)this.getXmlObject()).isLazyExpansion()) {
            this.getWorkflow().removeSubflow(this.getTarget());
            this._includedTarget = null;
        }
    }

    protected Target getTarget() throws ExecPlanException {
        if (this._includedTarget == null) {
            String targetName = ((IncludeType)this.getXmlObject()).getTarget();
            if (((IncludeType)this.getXmlObject()).isTargetKey()) {
                targetName = this.getWorkflow().getProxy().getWorkflowProperty(targetName);
            }
            String fileName = ((IncludeType)this.getXmlObject()).getFile();
            if (((IncludeType)this.getXmlObject()).isFileKey()) {
                fileName = this.getWorkflow().getProxy().getWorkflowProperty(fileName);
            }
            WCFWrapper wcf = fileName != null && fileName.length() > 0 ? this.getWorkflow().getWCF(fileName, this.getParentTarget().getWCFParent().getClassLoader()) : this.getParentTarget().getWCFParent();
            this._includedTarget = wcf.createTargetWrapper(targetName);
            if (this._includedTarget == null) {
                throw new ExecPlanException("Undefined target: " + targetName);
            }
            this._log.finer("Including target: " + targetName + " from file: " + wcf.getWcFileName());
        }
        return this._includedTarget;
    }

    @Override
    public void removedFromWorkflow() throws ExecPlanException {
        this._includedTarget = null;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
        sb.append(" [");
        if (this._includedTarget != null) {
            sb.append(this._includedTarget);
        } else {
            sb.append(((IncludeType)this.getXmlObject()).getTarget());
            sb.append(" [").append(((IncludeType)this.getXmlObject()).getTarget());
            String fileName = ((IncludeType)this.getXmlObject()).getFile();
            sb.append("@").append(fileName != null ? fileName : this.getParentTarget().getWCFParent().getWcFileName()).append("]");
        }
        sb.append("]");
        return sb.toString();
    }
}

