/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.tasks;

import com.oracle.cie.wizard.internal.cont.InternalTaskContext;
import com.oracle.cie.wizard.internal.tasks.AbstractInternalTask;
import com.oracle.cie.wizard.tasks.TaskAttribute;
import com.oracle.cie.wizard.tasks.TaskAttributeType;
import com.oracle.cie.wizard.tasks.TaskDescription;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

@TaskDescription(name="appendClassPath")
public class AppendTaskLoaderClassPath
extends AbstractInternalTask {
    protected String _jarFiles = null;
    protected String _key = null;
    protected KEY_TYPE _keyType = KEY_TYPE.String;

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setJarFiles(String files) {
        this._jarFiles = files;
    }

    @TaskAttribute(type=TaskAttributeType.LITERAL)
    public void setKey(String key) {
        this._key = key;
    }

    @TaskAttribute(type=TaskAttributeType.ENUM, typeConstraints={"String", "File", "URI"}, defaultValue="String")
    public void setKeyType(String keyType) {
        try {
            this._keyType = KEY_TYPE.valueOf(keyType);
        }
        catch (IllegalArgumentException ex) {
            this._logger.info("Unsupported key type : " + keyType);
        }
    }

    @Override
    public void execute() {
        List list;
        ArrayList<File> files = new ArrayList<File>();
        if (this._jarFiles != null) {
            String[] jars = this._jarFiles.split("\\s*[,;]\\s*");
            for (String jar : jars) {
                String jarname = ((InternalTaskContext)this._context).substitute(this._namespace, jar);
                files.add(new File(jarname));
            }
        }
        if (this._key != null && (list = (List)((InternalTaskContext)this._context).retrieveObject(this._namespace, ((InternalTaskContext)this._context).substitute(this._namespace, this._key))) != null) {
            switch (this._keyType) {
                case String: {
                    for (Object aList : list) {
                        files.add(new File((String)aList));
                    }
                    break;
                }
                case File: {
                    files.addAll(list);
                    break;
                }
                case URI: {
                    for (Object aList : list) {
                        files.add(new File((URI)aList));
                    }
                    break;
                }
            }
        }
        if (files.size() > 0) {
            for (File f : files) {
                if (f.isFile() && f.getName().endsWith(".jar") || f.isDirectory()) {
                    this.addToClasspath(f);
                    continue;
                }
                this._logger.warning("Unable to locate: " + f);
            }
        } else {
            this._logger.warning("No files added to classpath!");
        }
    }

    private void addToClasspath(File f) {
        this._logger.fine("Adding " + f + " to classpath!");
        try {
            ((InternalTaskContext)this._context).getProxy().addJarToClassPath(f.toURI().toURL());
        }
        catch (MalformedURLException mux) {
            this._logger.log(Level.SEVERE, "Unable to create url for: " + f, mux);
        }
    }

    public static enum KEY_TYPE {
        String,
        File,
        URI;

    }
}

