/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.engine;

import com.oracle.cie.common.ICommonConstants;
import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.wizard.WizardCompletionInfo;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.WizardConfigurationException;
import com.oracle.cie.wizard.WizardException;
import com.oracle.cie.wizard.WizardLogManager;
import com.oracle.cie.wizard.internal.engine.DefaultWizardLogManager;
import com.oracle.cie.wizard.internal.engine.EmbeddedEngine;
import java.io.FileNotFoundException;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.MissingResourceException;
import java.util.ServiceLoader;
import java.util.logging.Level;

public class WizardControllerEngine
extends EmbeddedEngine {
    protected Integer _returnCode;

    @Override
    public void init(WizardConfiguration conf) throws WizardException {
        if (conf == null) {
            throw new WizardException("No configuration provided!");
        }
        this.setupClassLoader();
        this.setupResources();
        if (conf.isUsageRequested()) {
            System.out.println(conf.getUsage());
            throw new WizardConfigurationException(WizardCompletionInfo.getInstance().getSuccessCode(), conf);
        }
        if (!conf.isValid()) {
            System.err.println(conf.getAllErrors());
            System.err.println(conf.getUsage());
            throw new WizardConfigurationException(WizardCompletionInfo.getInstance().getErrorCode(), conf);
        }
        this._conf = conf;
        this.setupWizardLog();
        this.setupObjectStore();
        super.init(conf);
    }

    @Override
    protected void handleError(Object ... params) {
        this._returnCode = this._returnCode == null ? WizardCompletionInfo.getInstance().getFatalErrorCode() : this._returnCode.intValue();
        super.handleError(params);
        if (this._errCause != null) {
            this._logger.log(Level.SEVERE, "Wizard error cause", this._errCause);
        }
    }

    @Override
    void stopExecution(int code) {
        super.stopExecution(code);
        this._returnCode = this._returnCode == null ? code : this._returnCode;
    }

    @Override
    protected boolean isEmbeddedProcess() {
        return false;
    }

    protected Integer getReturnCode() {
        return this._returnCode;
    }

    protected void setReturnCode(int code) {
        this._returnCode = code;
    }

    protected void setupWizardLog() {
        Exception exception = null;
        WizardLogManager logManager = null;
        try {
            Iterator<WizardLogManager> iterator = ServiceLoader.load(WizardLogManager.class, WizardControllerEngine.class.getClassLoader()).iterator();
            if (iterator.hasNext()) {
                logManager = iterator.next();
            }
        }
        catch (Exception ex) {
            exception = ex;
        }
        if (logManager == null) {
            logManager = new DefaultWizardLogManager();
        }
        logManager.setWizardConfiguration(this.getConfiguration());
        try {
            logManager.setupLogging();
        }
        catch (WizardException e) {
            System.err.println(MessageFormat.format(ResourceBundleManager.getString((String)"wizard-internal", (String)"error.log.setup"), e.toString()));
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Wizard Controller initializing");
        }
        if (exception != null) {
            this._logger.log(Level.WARNING, "Problem occurred in setting up the custom logger :", exception);
        }
    }

    protected void setupResources() {
        ResourceBundleManager.manageBundles((String)"comdev", (String[])ICommonConstants.COMMON_BUNDLES);
        ResourceBundleManager.manageBundles((String)"wizard-internal", (String[])new String[]{"resources/wizard/wizard"});
        try {
            ResourceBundleManager.manageBundles((String)"wizard-internal", (String[])new String[]{"resources/wizard/wizard_ext"});
        }
        catch (MissingResourceException missingResourceException) {
            // empty catch block
        }
    }

    protected void setupObjectStore() {
        ObjectStoreManager.setClassLoader((ClassLoader)this._taskClassLoader);
        ObjectStoreManager.getObjectStore((String)"wizard-internal");
        try {
            ObjectStoreManager.loadNamespace((String)"wizard-internal", (String)"resources/wizard/wizard_internal_ns.properties", (boolean)false);
        }
        catch (FileNotFoundException ex) {
            this._logger.log(Level.INFO, "Couldn't load wizard resources", ex);
        }
        try {
            ObjectStoreManager.loadNamespace((String)"wizard-internal", (String)"resources/wizard/wizard_internal_ns_custom.properties", (boolean)true);
        }
        catch (FileNotFoundException ex) {
            // empty catch block
        }
        IObjectStore os = ObjectStoreManager.getObjectStore((String)"wizard-options");
        if (os != null) {
            os.storeAll(this.getConfiguration().getOptions());
        }
    }
}

