/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.internal.engine;

import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.WizardCompletionInfo;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.WizardEngine;
import com.oracle.cie.wizard.WizardException;
import com.oracle.cie.wizard.WizardMode;
import com.oracle.cie.wizard.WizardState;
import com.oracle.cie.wizard.event.WizardStateChangeEvent;
import com.oracle.cie.wizard.event.WizardStateChangeListener;
import com.oracle.cie.wizard.event.WizardTaskActionEvent;
import com.oracle.cie.wizard.event.WizardTaskActionListener;
import com.oracle.cie.wizard.internal.cont.TaskContainer;
import com.oracle.cie.wizard.internal.engine.UpdatableURLClassLoader;
import com.oracle.cie.wizard.internal.engine.WizardCommandAction;
import com.oracle.cie.wizard.internal.engine.WizardControllerProxy;
import com.oracle.cie.wizard.internal.engine.WizardTaskFactory;
import com.oracle.cie.wizard.internal.wcf.WCFWorkflow;
import com.oracle.cie.wizard.tasks.Task;
import com.oracle.cie.wizard.tasks.TaskFactory;
import com.oracle.cie.wizard.tasks.TraversalMode;
import com.oracle.cie.wizard.wcf.ExecPlanException;
import com.oracle.cie.wizard.wcf.TaskEntry;
import com.oracle.cie.wizard.wcf.Workflow;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EmbeddedEngine
implements WizardEngine {
    protected final Logger _logger = Logger.getLogger(this.getClass().getName());
    public static final String EMB_PROCESS_CLASSLOADER_CREATION_OBJ_KEY = "createNewEmbProcessClassloader";
    protected static final int MAX_QUEUE_INS_ATTEMPTS = 10;
    protected WizardConfiguration _conf;
    protected ControllerProxy _proxy;
    protected WizardState _state = WizardState.CREATED;
    protected WizardMode _mode;
    protected List<TaskContainer<?, Task<?>>> _taskContainers;
    protected Workflow _workflow;
    protected UpdatableURLClassLoader _taskClassLoader;
    protected TaskFactory _taskFactory;
    protected Throwable _errCause;
    protected List<WizardStateChangeListener> _stateListeners = new ArrayList<WizardStateChangeListener>();
    protected List<WizardTaskActionListener> _taskActionListeners = new ArrayList<WizardTaskActionListener>();
    protected BlockingQueue<WizardCommandAction> _cmdQueue = new LinkedBlockingQueue<WizardCommandAction>();
    private TaskContainer<?, Task<?>> _activeContainer = null;
    protected Map<Object, Object> _wizLocalStore = new HashMap<Object, Object>();

    @Override
    public void init(WizardConfiguration conf) throws WizardException {
        this._conf = conf;
        this.setupClassLoader();
        this._proxy = new WizardControllerProxy(this);
        this.configureMode();
        this.configureTaskFactory();
        this.configureExecEngine();
        this.changeState(WizardState.CONFIGURED);
    }

    @Override
    public ControllerProxy getControllerProxy() {
        return this._proxy;
    }

    @Override
    public void run() {
        this._logger.finest("Executing.");
        this.changeState(WizardState.RUNNING);
        this.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.NEXT, new Object[0]));
        while (this._state == WizardState.RUNNING || this._state == WizardState.SUSPENDED || this._state == WizardState.ERROR) {
            try {
                this._logger.finest("Waiting for new commands...");
                WizardCommandAction cmdAction = this._cmdQueue.poll(10L, TimeUnit.SECONDS);
                if (cmdAction == null) continue;
                this._logger.finest("Processing command: " + (Object)((Object)cmdAction.getCommand()));
                WizardCommandAction.WizardCommand cmd = cmdAction.getCommand();
                if (this._state == WizardState.ERROR && cmd != WizardCommandAction.WizardCommand.CANCEL && cmd != WizardCommandAction.WizardCommand.ERROR) {
                    this._logger.finer("Wizard is in error state. Ingoring command " + (Object)((Object)cmd));
                    continue;
                }
                if (this._state == WizardState.SUSPENDED && (cmd == WizardCommandAction.WizardCommand.NEXT || cmd == WizardCommandAction.WizardCommand.FAST_FINISH || cmd == WizardCommandAction.WizardCommand.PREV || cmd == WizardCommandAction.WizardCommand.GOTO)) {
                    this._logger.finer("Wizard is suspended. Ignoring command " + (Object)((Object)cmd));
                    continue;
                }
                switch (cmd) {
                    case NEXT: {
                        this.goForward(null);
                        break;
                    }
                    case FAST_FINISH: {
                        this.goForward(this._workflow.getEntryAt(this._workflow.getSize() - 1));
                        break;
                    }
                    case PREV: {
                        this.goReverse(null);
                        break;
                    }
                    case GOTO: {
                        Object[] params = cmdAction.getParameters();
                        if (params == null || params.length < 1 || params[0] == null) {
                            this._logger.warning("The parameter for command " + (Object)((Object)cmd) + " is missing.");
                            break;
                        }
                        if (!TaskEntry.class.isAssignableFrom(params[0].getClass())) {
                            this._logger.warning("Incompatible parameter class for command " + (Object)((Object)cmd) + ": " + params[0].getClass());
                            break;
                        }
                        this.goToTask((TaskEntry)TaskEntry.class.cast(params[0]));
                        break;
                    }
                    case SUSPEND: {
                        this.changeState(WizardState.SUSPENDED);
                        break;
                    }
                    case RESUME: {
                        this.changeState(WizardState.RUNNING);
                        break;
                    }
                    case ERROR: {
                        this.handleError(cmdAction.getParameters());
                        break;
                    }
                    case CANCEL: {
                        this.stopExecution(WizardCompletionInfo.getInstance().getCancelCode());
                        break;
                    }
                    case COMPLETE: {
                        this.stopExecution(WizardCompletionInfo.getInstance().getSuccessCode());
                    }
                }
            }
            catch (InterruptedException ix) {
                this._logger.log(Level.INFO, "Interrupted while retrieving action.", ix);
            }
            catch (Throwable thr) {
                int returnCode;
                WizardCompletionInfo wzi = WizardCompletionInfo.getInstance();
                int n = returnCode = WizardException.class.isAssignableFrom(thr.getClass()) ? wzi.getErrorCode() : wzi.getFatalErrorCode();
                if (this._state == WizardState.ERROR) {
                    this._logger.log(Level.SEVERE, "Wizard encountered error", thr);
                    this.stopExecution(returnCode);
                    continue;
                }
                this.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.ERROR, returnCode, thr));
            }
        }
        this.changeState(WizardState.TERMINATED);
    }

    protected WizardConfiguration getConfiguration() {
        return this._conf;
    }

    protected WizardState getState() {
        return this._state;
    }

    protected WizardMode getMode() {
        return this._mode;
    }

    protected UpdatableURLClassLoader getTaskClassLoader() {
        return this._taskClassLoader;
    }

    protected Workflow getWorkflow() {
        return this._workflow;
    }

    protected void addWizardStateChangeListener(WizardStateChangeListener listener) {
        if (listener != null && !this._stateListeners.contains(listener)) {
            this._stateListeners.add(listener);
        }
    }

    protected void removeWizardStateChangeListener(WizardStateChangeListener listener) {
        this._stateListeners.remove(listener);
    }

    protected void addWizardTaskActionListener(WizardTaskActionListener listener) {
        if (listener != null && !this._taskActionListeners.contains(listener)) {
            this._taskActionListeners.add(listener);
        }
    }

    protected void removeWizardTaskActionListener(WizardTaskActionListener listener) {
        this._taskActionListeners.remove(listener);
    }

    protected void requestWizardAction(WizardCommandAction action) {
        for (int attempts = 0; attempts < 10; ++attempts) {
            try {
                this._logger.finer("Adding command action to the queue: " + action);
                if (this._logger.isLoggable(Level.FINEST) && action.getParameters() != null) {
                    for (Object p : action.getParameters()) {
                        this._logger.log(Level.FINEST, "Task Action Parameter: " + p, p instanceof Throwable ? (Throwable)p : null);
                    }
                }
                this._cmdQueue.put(action);
                return;
            }
            catch (InterruptedException ex) {
                this._logger.log(Level.INFO, "Interrupted while scheduling action.", ex);
                continue;
            }
        }
        this._logger.severe("Failed to insert action into action queue after 10 attempts.");
        this.stopExecution(WizardCompletionInfo.getInstance().getErrorCode());
    }

    protected void setupClassLoader() {
        if (this._taskClassLoader != null) {
            return;
        }
        if (this.isEmbeddedProcess() && !Boolean.parseBoolean(this._conf.getOptionValue(EMB_PROCESS_CLASSLOADER_CREATION_OBJ_KEY))) {
            this._taskClassLoader = (UpdatableURLClassLoader)Thread.currentThread().getContextClassLoader();
            return;
        }
        this._taskClassLoader = AccessController.doPrivileged(new PrivilegedAction<UpdatableURLClassLoader>(){

            @Override
            public UpdatableURLClassLoader run() {
                return new UpdatableURLClassLoader(new URL[0], Thread.currentThread().getContextClassLoader());
            }
        });
        if (!this.isEmbeddedProcess()) {
            Thread.currentThread().setContextClassLoader(this._taskClassLoader);
        }
    }

    protected void configureMode() throws WizardException {
        this._mode = WizardMode.GUI;
        String m = this._conf.getOptionValue(WizardConfiguration.MODE);
        if (m != null) {
            try {
                this._mode = WizardMode.valueOf(m.toUpperCase());
            }
            catch (IllegalArgumentException ex) {
                this._logger.finer("WizardMode is not set or unsupported, using default...");
            }
        }
        if (this._logger.isLoggable(Level.FINER)) {
            this._logger.finer("Execution mode is: " + (Object)((Object)this._mode));
        }
        this._taskContainers = new ArrayList();
        for (String contClass : this.getContainers(this._mode)) {
            this._taskContainers.add(this.loadTaskContainer(contClass));
        }
    }

    protected void configureTaskFactory() {
        this._taskFactory = new WizardTaskFactory();
        this._taskFactory.setTaskClazzLoader(this._taskClassLoader);
    }

    protected void configureExecEngine() throws WizardException {
        this._workflow = new WCFWorkflow();
        String wcf = this._conf.getOptionValue(WizardConfiguration.CTRLFILE);
        String target = this._conf.getOptionValue(WizardConfiguration.TARGET);
        try {
            this._workflow.init(this._proxy, wcf, target, this._taskClassLoader, null);
        }
        catch (ExecPlanException ex) {
            throw new WizardException("Couldn't start execution using target " + (target == null ? "[default]" : target) + " in WCF <" + wcf + ">", ex);
        }
    }

    protected String[] getContainers(WizardMode mode) {
        ArrayList<String> containers = new ArrayList<String>();
        containers.add("com.oracle.cie.wizard.internal.cont.InternalTaskContainer");
        containers.add("com.oracle.cie.wizard.internal.cont.SilentTaskContainer");
        if (mode == WizardMode.GUI) {
            containers.add("com.oracle.cie.wizard.internal.cont.GUITaskContainer");
        }
        return containers.toArray(new String[containers.size()]);
    }

    protected TaskContainer<?, Task<?>> loadTaskContainer(String clazz) throws WizardException {
        TaskContainer cont;
        try {
            cont = (TaskContainer)this.getClass().getClassLoader().loadClass(clazz).newInstance();
        }
        catch (InstantiationException e) {
            throw new WizardException("Invalid TaskContainer", e);
        }
        catch (Exception e) {
            throw new WizardException("Unable to load TaskContainer", e);
        }
        cont.init(this._proxy);
        return cont;
    }

    protected void changeState(WizardState state) {
        if (this._state.isValidTransition(state)) {
            this._logger.finer("Changing from state '" + (Object)((Object)this._state) + "' to '" + (Object)((Object)state) + "'");
            WizardState oldState = this._state;
            this._state = state;
            this.fireStateChangeEvent(oldState, state);
        } else {
            this._logger.warning("Given state '" + (Object)((Object)state) + "' does not follow current '" + (Object)((Object)this._state) + "'");
        }
    }

    protected synchronized void goForward(TaskEntry target) throws WizardException, ExecPlanException {
        block6: {
            TaskEntry taskEntry;
            if (this._activeContainer != null && !this._activeContainer.isTaskComplete(TraversalMode.FORWARD)) {
                this._logger.finest("Task is not complete. Ingoring command.");
                this._activeContainer.keepRunningTask();
                return;
            }
            if (this._activeContainer != null) {
                this._activeContainer.unconfigureTask();
            }
            while (true) {
                boolean skip_forward;
                if ((taskEntry = this._workflow.next()) == null) {
                    this._activeContainer = null;
                    this.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.COMPLETE, new Object[0]));
                    break block6;
                }
                if (taskEntry.getExectutionDirection() != TaskEntry.ExecutionDirection.ALWAYS && taskEntry.getExectutionDirection() != TaskEntry.ExecutionDirection.FORWARD) {
                    this.fireTaskActionEvent(taskEntry, WizardTaskActionEvent.Action.SKIPPED, WizardTaskActionEvent.Direction.FORWARD);
                    continue;
                }
                Task<?> task = this._taskFactory.getTaskInstance(taskEntry);
                this._activeContainer = this.getTaskContainer(task);
                this._activeContainer.setTask(task, TraversalMode.FORWARD);
                boolean bl = skip_forward = target != null && this._workflow.getIndex(target) > this._workflow.getCurrentIndex();
                if (!skip_forward || !this._activeContainer.bypassTask()) break;
                this._activeContainer.unconfigureTask();
                this.fireTaskActionEvent(taskEntry, WizardTaskActionEvent.Action.BYPASSED, WizardTaskActionEvent.Direction.FORWARD);
            }
            this.fireTaskActionEvent(taskEntry, WizardTaskActionEvent.Action.SCHEDULED, WizardTaskActionEvent.Direction.FORWARD);
        }
        if (this._activeContainer != null) {
            this._activeContainer.executeTask();
        }
    }

    protected synchronized void goReverse(TaskEntry target) throws WizardException, ExecPlanException {
        block7: {
            TaskEntry taskEntry;
            if (this._activeContainer == null) {
                this._logger.finest("No current task. Ignoring command.");
                return;
            }
            if (this._activeContainer.getCurrentTask().getEntry().isReverseDisallowed()) {
                this._logger.finer("Task does not allow reverse navigation. Ingoring command.");
                this._activeContainer.keepRunningTask();
                return;
            }
            if (!this._activeContainer.isTaskComplete(TraversalMode.REVERSE)) {
                this._logger.finest("Task is not complete. Ingoring command.");
                this._activeContainer.keepRunningTask();
                return;
            }
            this._activeContainer.unconfigureTask();
            while (true) {
                boolean skip_reverse;
                if ((taskEntry = this._workflow.previous()) == null) {
                    this._activeContainer = null;
                    this.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.NEXT, new Object[0]));
                    break block7;
                }
                if (taskEntry.getExectutionDirection() != TaskEntry.ExecutionDirection.ALWAYS && taskEntry.getExectutionDirection() != TaskEntry.ExecutionDirection.BACK) {
                    this.fireTaskActionEvent(taskEntry, WizardTaskActionEvent.Action.SKIPPED, WizardTaskActionEvent.Direction.REVERSE);
                    continue;
                }
                Task<?> task = this._taskFactory.getTaskInstance(taskEntry);
                this._activeContainer = this.getTaskContainer(task);
                this._activeContainer.setTask(task, TraversalMode.REVERSE);
                boolean bl = skip_reverse = target != null && this._workflow.getIndex(target) < this._workflow.getCurrentIndex();
                if (!skip_reverse || !this._activeContainer.bypassTask()) break;
                this._activeContainer.unconfigureTask();
                this.fireTaskActionEvent(taskEntry, WizardTaskActionEvent.Action.BYPASSED, WizardTaskActionEvent.Direction.REVERSE);
            }
            this.fireTaskActionEvent(taskEntry, WizardTaskActionEvent.Action.SCHEDULED, WizardTaskActionEvent.Direction.REVERSE);
        }
        if (this._activeContainer != null) {
            this._activeContainer.executeTask();
        }
    }

    protected void goToTask(TaskEntry target) throws WizardException, ExecPlanException {
        int currIdx = this._workflow.getCurrentIndex();
        int targetIdx = this._workflow.getIndex(target);
        if (targetIdx < 0) {
            this._logger.info("The task the wizard was requested to go to is not part of the current flow.");
            return;
        }
        if (targetIdx == currIdx) {
            this._logger.finer("The task the wizard was requested to go to is the current task.");
        } else if (targetIdx > currIdx) {
            this.goForward(target);
        } else {
            this.goReverse(target);
        }
    }

    protected TaskContainer<?, Task<?>> getTaskContainer(Task<?> task) throws WizardException {
        for (TaskContainer<?, Task<?>> container : this._taskContainers) {
            if (!container.isSupported(task.getClass())) continue;
            return container;
        }
        throw new WizardException("Unsupported task: " + task.getClass());
    }

    protected void handleError(Object ... params) {
        if (params != null) {
            for (Object param : params) {
                if (param == null) {
                    this._logger.warning("Invalid Action Parameter: null");
                }
                if (!(param instanceof Throwable)) continue;
                if (this._errCause != null) {
                    this._logger.warning("Duplicate action cause encountered: " + param);
                }
                this._errCause = (Throwable)Throwable.class.cast(param);
            }
        }
        this.changeState(WizardState.ERROR);
        boolean handled = false;
        for (TaskContainer<?, Task<?>> cont : this._taskContainers) {
            if (!cont.handlesFatalErrorExit()) continue;
            handled = true;
            break;
        }
        if (!handled) {
            this.requestWizardAction(new WizardCommandAction(WizardCommandAction.WizardCommand.CANCEL, params));
        }
    }

    void stopExecution(int code) {
        boolean isError = this._state == WizardState.ERROR;
        this.changeState(WizardState.SHUTTING_DOWN);
        if (isError) {
            this.cleanup();
        }
    }

    protected void cleanup() {
    }

    protected void fireStateChangeEvent(WizardState oldState, WizardState newState) {
        if (!this._stateListeners.isEmpty()) {
            WizardStateChangeEvent e = new WizardStateChangeEvent(this._proxy, oldState, newState);
            for (WizardStateChangeListener l : this._stateListeners) {
                try {
                    l.stateChanged(e);
                }
                catch (Throwable ex) {
                    this._logger.log(Level.SEVERE, "WizardStateChangeEvent thrown unexpected exception.", ex);
                }
            }
        }
    }

    protected void fireTaskActionEvent(TaskEntry task, WizardTaskActionEvent.Action action, WizardTaskActionEvent.Direction direction) {
        if (!this._taskActionListeners.isEmpty()) {
            WizardTaskActionEvent e = new WizardTaskActionEvent(this._proxy, action, direction, task);
            for (WizardTaskActionListener l : this._taskActionListeners) {
                try {
                    l.taskActionPeformed(e);
                }
                catch (Throwable ex) {
                    this._logger.log(Level.SEVERE, "WizardTaskActionEvent thrown unexpected exception.", ex);
                }
            }
        }
    }

    TraversalMode getTraversalMode() {
        return this._activeContainer.getTraversalMode();
    }

    protected Throwable getErrorCause() {
        return this._errCause;
    }

    protected boolean isEmbeddedProcess() {
        return true;
    }

    protected boolean hasDefinedLocalObject(Object key) {
        return this._wizLocalStore.containsKey(key);
    }

    protected Object retrieveLocalObject(Object key) {
        return this._wizLocalStore.get(key);
    }

    protected Object setLocalObject(Object key, Object value) {
        return this._wizLocalStore.put(key, value);
    }

    protected Object removeLocalObject(Object key) {
        return this._wizLocalStore.remove(key);
    }
}

