/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.tasks;

import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.ext.OutcomeSummaryController;
import com.oracle.cie.wizard.ext.OutcomeSummaryExtension;
import com.oracle.cie.wizard.ext.summary.SummaryPanelParser;
import com.oracle.cie.wizard.ext.summary.xml.CheckboxType;
import com.oracle.cie.wizard.ext.summary.xml.DisplayType;
import com.oracle.cie.wizard.ext.summary.xml.NodeType;
import com.oracle.cie.wizard.ext.summary.xml.OutcomeSummaryType;
import com.oracle.cie.wizard.ext.summary.xml.TextType;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.tasks.SummaryGUITask;
import com.oracle.cie.wizard.tasks.TaskDescription;
import com.oracle.cie.wizard.tasks.TaskExecutionException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.logging.Level;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.xml.bind.JAXBException;
import org.xml.sax.SAXException;

@TaskDescription(name="outcome_summary_gui")
public class OutcomeSummaryGUITask
extends SummaryGUITask {
    private OutcomeSummaryExtension _summaryExtension;
    private OutcomeSummaryType _summaryType;
    private List<CheckboxType> _checkboxTypes;

    @Override
    public void configure(GUITaskContext context) throws TaskExecutionException {
        super.configure(context);
        try {
            ClassLoader classLoader = OutcomeSummaryGUITask.class.getClassLoader();
            if (!StringUtil.isNullOrEmpty((String)this._summaryType.getHelperClass(), (boolean)true)) {
                Class<?> loaderClass = classLoader.loadClass(this._summaryType.getHelperClass());
                this._summaryExtension = (OutcomeSummaryExtension)loaderClass.getConstructor(new Class[0]).newInstance(new Object[0]);
                if (this._summaryExtension == null) {
                    throw new TaskExecutionException(this, "Unable to initialze outcome summary extension class :: " + this._summaryType.getHelperClass());
                }
                this._summaryExtension.initialize();
            } else {
                this._logger.log(Level.INFO, "No helper class provided to customize or control the additional component on outcome summary panel");
            }
            this._checkboxTypes = new ArrayList<CheckboxType>(this._summaryType.getTextOrCheckbox().size());
        }
        catch (TaskExecutionException e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw e;
        }
        catch (Exception e) {
            this._logger.log(Level.SEVERE, e.getMessage(), e);
            throw new TaskExecutionException(this, ((GUITaskContext)this._context).getPublishedMessage(this._namespace, "64255", this._configFile, e.getMessage()).getFullMessage(), e);
        }
    }

    @Override
    public JComponent createUI() {
        JComponent compoent = super.createUI();
        if (this._summaryType.getTextOrCheckbox().isEmpty()) {
            return compoent;
        }
        HyperlinkListener listener = new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        OutcomeSummaryGUITask.this.displayURI(e.getURL().toURI());
                    }
                    catch (Exception ex) {
                        OutcomeSummaryGUITask.this._logger.log(Level.FINER, "Error occurred in opening the external link", ex);
                    }
                }
            }
        };
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)compoent, "Center");
        JPanel bottomPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints(0, 0, 0, 1, 1.0, 0.0, 23, 2, new Insets(8, 10, 0, 10), 0, 0);
        gbc.gridx = 0;
        gbc.gridy = 0;
        gbc.anchor = 17;
        int count = this._summaryType.getTextOrCheckbox().size();
        gbc.insets.bottom = count == 1 ? 8 : 0;
        for (DisplayType object : this._summaryType.getTextOrCheckbox()) {
            if (object instanceof CheckboxType) {
                final CheckboxType cbType = (CheckboxType)object;
                if (this._summaryExtension == null || this._summaryExtension.showComponent(cbType.getId())) {
                    this._checkboxTypes.add(cbType);
                    JCheckBox checkbox = new JCheckBox();
                    GUIUtilities.configureButton((AbstractButton)checkbox, (String)this.getI18nValue(cbType.getNameKey(), this._controller instanceof OutcomeSummaryController ? ((OutcomeSummaryController)this._controller).getComponentTextParams(cbType.getId()) : null));
                    checkbox.setSelected(cbType.isSelected());
                    checkbox.addActionListener(new ActionListener(){

                        @Override
                        public void actionPerformed(ActionEvent e) {
                            JCheckBox button = (JCheckBox)e.getSource();
                            cbType.setSelected(button.isSelected());
                        }
                    });
                    bottomPanel.add((Component)checkbox, gbc);
                }
            } else {
                TextType tType = (TextType)object;
                if (this._summaryExtension == null || this._summaryExtension.showComponent(tType.getId())) {
                    JTextPane textPane = new JTextPane();
                    textPane.setEditorKit(GUIUtilities.getHTMLEditorKit((boolean)tType.isBold()));
                    textPane.setEditable(false);
                    textPane.setOpaque(false);
                    textPane.setText(this.getI18nValue(tType.getNameKey(), this._controller instanceof OutcomeSummaryController ? ((OutcomeSummaryController)this._controller).getComponentTextParams(tType.getId()) : null));
                    textPane.addHyperlinkListener(listener);
                    bottomPanel.add((Component)textPane, gbc);
                }
            }
            gbc.insets.top = 0;
            ++gbc.gridy;
            if (--count != 1) continue;
            gbc.insets.bottom = 8;
        }
        mainPanel.add((Component)bottomPanel, "South");
        return mainPanel;
    }

    @Override
    public boolean okNext() {
        HashMap<String, Boolean> componentIdStateMap = new HashMap<String, Boolean>(this._checkboxTypes.size(), 1.0f);
        for (CheckboxType cbType : this._checkboxTypes) {
            componentIdStateMap.put(cbType.getId(), cbType.isSelected());
        }
        try {
            if (this._summaryExtension != null) {
                this._summaryExtension.doOperation(componentIdStateMap);
            }
        }
        catch (Exception e) {
            this._logger.log(Level.WARNING, "Error occured in performing checkbox operation through external API:" + this._summaryExtension.getClass().getName(), e);
        }
        return super.okNext();
    }

    @Override
    protected NodeType parseSchema() throws SAXException, JAXBException {
        this._summaryType = new SummaryPanelParser().parseOutcomeConfig(this.getConfigurationStream());
        return this._summaryType.getSummaryTree();
    }

    @Override
    protected InputStream getConfigurationStream() {
        return OutcomeSummaryGUITask.class.getClassLoader().getResourceAsStream(this._configFile);
    }
}

