/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.msgpanel.impl;

import com.oracle.cie.common.ui.gui.GUIHelper;
import com.oracle.cie.common.ui.gui.GUIUtilities;
import com.oracle.cie.common.ui.gui.ImagePanel;
import com.oracle.cie.common.util.ResourceBundleManager;
import com.oracle.cie.wizard.gui.GUITaskContext;
import com.oracle.cie.wizard.gui.msgpanel.MessageKey;
import com.oracle.cie.wizard.gui.msgpanel.MessagePanel;
import com.oracle.cie.wizard.gui.msgpanel.MessageSelectionEvent;
import com.oracle.cie.wizard.gui.msgpanel.MessageSelectionListener;
import com.oracle.cie.wizard.gui.msgpanel.MessageType;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.ComboBoxEditor;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.border.LineBorder;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.text.BoxView;
import javax.swing.text.ComponentView;
import javax.swing.text.Element;
import javax.swing.text.IconView;
import javax.swing.text.JTextComponent;
import javax.swing.text.LabelView;
import javax.swing.text.ParagraphView;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;
import javax.swing.text.StyledEditorKit;
import javax.swing.text.View;
import javax.swing.text.ViewFactory;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class MessagePanelImpl
implements MessagePanel {
    private GUITaskContext _context = null;
    private JScrollPane _scrollPane;
    private MessageTree _messageTree;
    private JTextPane _nvMsgDisplay = null;
    private ImagePanel _billboardImage = null;
    private Map<MessageType, ImageIcon> _iconMap = null;
    private List<Set<JComponent>> _compArrayList = null;
    private List<Set<MessageKey>> _keyArrayList = null;
    private List<ValidationMessageNode> _msgList;
    private Map<Object, NonValidationMessageNode> _nonValidationMsgMap;
    private List<MessageSelectionListener> _listenerList;
    private Object _selectedKey;
    private Set<Object> _selectedKeys;
    private FocusListener _componentFocusListener;
    private FocusListener _nonValidationFocusListener;
    private MessagePanelSelectionListener _msgListener;
    private Font _labelFont = null;
    private boolean _billboardMode;
    private int _indent = 20;
    private static final Logger _log = Logger.getLogger(MessagePanelImpl.class.getName());
    public static final String GENERIC_LOGO_LARGE_IMAGE_ICON = "resources/wizard/images/headerlog_wiz.png";
    public static final String ERROR_ICON = "resources/wizard/images/error_status.png";
    public static final String WARNING_ICON = "resources/wizard/images/warning_status.png";
    public static final String PENDING_ICON = "resources/wizard/images/pending_status.png";
    public static final String SUCCESS_ICON = "resources/wizard/images/checkmark_sm_ena.png";

    public MessagePanelImpl(GUITaskContext context) {
        this._context = context;
        this.loadIconMap();
        this._scrollPane = new JScrollPane(20, 31);
        this._messageTree = new MessageTree();
        this._nvMsgDisplay = new JTextPane(){

            @Override
            public boolean getScrollableTracksViewportWidth() {
                return true;
            }
        };
        this._billboardImage = new ImagePanel(GUIUtilities.loadIcon((String)GENERIC_LOGO_LARGE_IMAGE_ICON, (ClassLoader)MessagePanelImpl.class.getClassLoader()).getImage());
        this._listenerList = new ArrayList<MessageSelectionListener>();
        this._msgListener = new MessagePanelSelectionListener();
        this._compArrayList = new ArrayList<Set<JComponent>>();
        this._keyArrayList = new ArrayList<Set<MessageKey>>();
        this._msgList = new ArrayList<ValidationMessageNode>();
        this._selectedKeys = new LinkedHashSet<Object>();
        this._nonValidationMsgMap = new HashMap<Object, NonValidationMessageNode>();
        this._componentFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                JComponent comp = (JComponent)e.getComponent();
                for (Set comps : MessagePanelImpl.this._compArrayList) {
                    if (!comps.contains(comp)) continue;
                    MessagePanelImpl.this._selectedKey = comps;
                    MessagePanelImpl.this._selectedKeys.add(comps);
                    break;
                }
                ((MessageModel)MessagePanelImpl.this._messageTree.getModel()).refresh();
            }

            @Override
            public void focusLost(FocusEvent e) {
                JComponent comp = (JComponent)e.getComponent();
                for (Set comps : MessagePanelImpl.this._compArrayList) {
                    if (!comps.contains(comp)) continue;
                    MessagePanelImpl.this._selectedKey = null;
                    MessagePanelImpl.this._selectedKeys.remove(comps);
                    break;
                }
                ((MessageModel)MessagePanelImpl.this._messageTree.getModel()).refresh();
            }
        };
        this._nonValidationFocusListener = new FocusListener(){

            @Override
            public void focusGained(FocusEvent e) {
                if (SwingUtilities.isDescendingFrom(e.getComponent(), MessagePanelImpl.this._context.getTaskUIComponent())) {
                    MessagePanelImpl.this._selectedKey = e.getComponent();
                    MessagePanelImpl.this.showNonValidationMsg();
                }
            }

            @Override
            public void focusLost(FocusEvent e) {
            }
        };
        this._nvMsgDisplay.addHyperlinkListener(new HyperlinkListener(){

            @Override
            public void hyperlinkUpdate(HyperlinkEvent e) {
                if (e.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    // empty if block
                }
            }
        });
        this._messageTree.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                TreeNode root = (TreeNode)MessagePanelImpl.this._messageTree.getModel().getRoot();
                for (int i = 0; i < root.getChildCount(); ++i) {
                    TreeNode header = root.getChildAt(i);
                    ((MessageModel)MessagePanelImpl.this._messageTree.getModel()).nodeChanged(header);
                    if (header.getChildCount() == 0) {
                        _log.warning("Invalid message - No details for message " + header);
                    }
                    TreeNode details = header.getChildAt(0);
                    if (!MessagePanelImpl.this._messageTree.isExpanded(new TreePath(new Object[]{root, header}))) continue;
                    ((MessageModel)MessagePanelImpl.this._messageTree.getModel()).nodeChanged(details);
                }
            }
        });
        this._messageTree.setRootVisible(false);
        this._messageTree.setLargeModel(true);
        this._messageTree.setRowHeight(0);
        this._messageTree.setShowsRootHandles(true);
        this._messageTree.getSelectionModel().setSelectionMode(1);
        this._messageTree.setModel(new MessageModel());
        this._messageTree.setCellRenderer(new MessageCellRenderer());
        this._messageTree.addTreeSelectionListener(this._msgListener);
        if (BasicTreeUI.class.isInstance(this._messageTree.getUI().getClass())) {
            this._indent = ((BasicTreeUI)this._messageTree.getUI()).getLeftChildIndent() + ((BasicTreeUI)this._messageTree.getUI()).getRightChildIndent();
        }
        this._nvMsgDisplay.setEditable(false);
        this._nvMsgDisplay.setOpaque(false);
        this._nvMsgDisplay.setFocusable(true);
        this._billboardImage.setFocusable(false);
        this._billboardMode = false;
        this._labelFont = UIManager.getFont("Label.font");
        this._scrollPane.getViewport().setView(this._nvMsgDisplay);
    }

    @Override
    public void addValidationMessage(MessageType type, String message, String details, JComponent ... comps) throws Exception {
        if (comps != null && comps.length > 0) {
            LinkedHashSet<Object> components = new LinkedHashSet<Object>(Arrays.asList(comps));
            if (components.contains(null)) {
                throw new Exception("Illegal method call - contains null as arguments");
            }
            this.addValidationMessage(components, type, message, details);
            this._compArrayList.add(new LinkedHashSet<JComponent>(Arrays.asList(comps)));
            for (JComponent comp : comps) {
                if (comp == null) continue;
                if (JComboBox.class.isAssignableFrom(comp.getClass())) {
                    JTextComponent tf;
                    ComboBoxEditor ed = ((JComboBox)JComboBox.class.cast(comp)).getEditor();
                    if (ed == null || (tf = (JTextComponent)ed.getEditorComponent()) == null) continue;
                    tf.addFocusListener(this._componentFocusListener);
                    continue;
                }
                comp.addFocusListener(this._componentFocusListener);
            }
        } else {
            this.addPanelValidationMessage(type, message, details);
        }
    }

    @Override
    public void addValidationMessage(MessageType type, String message, String details, MessageKey ... keys) throws Exception {
        if (keys == null || Arrays.asList(keys).contains(null)) {
            throw new Exception("Illegal use of null MessageKey object");
        }
        this.addValidationMessage(new LinkedHashSet<Object>(Arrays.asList(keys)), type, message, details);
        this._keyArrayList.add(new LinkedHashSet<MessageKey>(Arrays.asList(keys)));
    }

    @Override
    public void addPanelValidationMessage(MessageType type, String message, String details) {
        this.addValidationMessage(new LinkedHashSet<Object>(), type, message, details);
    }

    protected void addValidationMessage(Set<Object> key, MessageType type, String message, String details) {
        if (!this._billboardMode) {
            this._scrollPane.getViewport().setView(this._messageTree);
            this._messageTree.setFocusable(true);
            ValidationMessageNode root = (ValidationMessageNode)((MessageModel)this._messageTree.getModel()).getRoot();
            ValidationMessageNode node = new ValidationMessageNode();
            node.setParent(root);
            node.setMessageKey(key);
            node.setType(type);
            node.setMessage(message);
            node.setLeaf(false);
            ValidationMessageNode child = new ValidationMessageNode();
            child.setParent(node);
            child.setMessageKey(key);
            child.setMessage(details);
            child.setType(type);
            child.setLeaf(true);
            node.addChild(child);
            ((MessageModel)this._messageTree.getModel()).insertMessageNode(node, child);
            if (this._msgList.contains(node)) {
                this._msgList.set(this._msgList.indexOf(node), node);
            } else {
                this._msgList.add(node);
            }
        } else {
            _log.warning("Illegal operation. Panel is in billboard mode");
        }
    }

    @Override
    public void setNonValidationMessage(Object key, MessageType type, String message) {
        if (!this._billboardMode) {
            JComponent comp = null;
            if (key != null && JComponent.class.isAssignableFrom(key.getClass())) {
                comp = (JComponent)JComponent.class.cast(key);
            }
            if (message == null) {
                if (this._nonValidationMsgMap.containsKey(key)) {
                    this._nonValidationMsgMap.remove(key);
                    if (comp != null) {
                        comp.removeFocusListener(this._nonValidationFocusListener);
                    }
                }
                this.showNonValidationMsg();
                return;
            }
            NonValidationMessageNode node = new NonValidationMessageNode();
            node.setType(type);
            node.setDetails(message);
            if (!type.equals((Object)MessageType.ERROR) && !type.equals((Object)MessageType.INPROGRESS)) {
                this._nonValidationMsgMap.put(key, node);
            }
            if (comp != null) {
                comp.addFocusListener(this._nonValidationFocusListener);
                String accessDescr = comp.getAccessibleContext().getAccessibleDescription();
                if (accessDescr != null) {
                    comp.getAccessibleContext().setAccessibleDescription(accessDescr + " " + message);
                } else {
                    comp.getAccessibleContext().setAccessibleDescription(message);
                }
            }
            this.showNonValidationMsg();
        } else {
            _log.warning("Illegal operation. Panel is in billboard mode");
        }
    }

    @Override
    public void clearValidationMessages(JComponent comp) throws Exception {
        if (comp == null) {
            throw new Exception("Illegal usage - use clearValidationMessages()");
        }
        if (!this._billboardMode) {
            boolean vMode = true;
            if (this._msgList.isEmpty()) {
                vMode = false;
            }
            Vector<Object> removedArray = new Vector<Object>();
            if (comp != null) {
                if (vMode) {
                    LinkedHashSet temp;
                    if (this._selectedKey != null && LinkedHashSet.class.isAssignableFrom(this._selectedKey.getClass()) && !(temp = (LinkedHashSet)this._selectedKey).isEmpty()) {
                        for (Object ob : temp) {
                            if (!JComponent.class.isAssignableFrom(ob.getClass()) || !comp.equals((JComponent)ob)) continue;
                            this._selectedKey = null;
                        }
                    }
                    if (!this._selectedKeys.isEmpty()) {
                        ArrayList<Object> contains = new ArrayList<Object>();
                        block1: for (Object c : this._selectedKeys) {
                            LinkedHashSet temp2;
                            if (!LinkedHashSet.class.isAssignableFrom(c.getClass()) || (temp2 = (LinkedHashSet)c).isEmpty()) continue;
                            for (Object ob : temp2) {
                                if (!JComponent.class.isAssignableFrom(ob.getClass()) || !comp.equals((JComponent)ob)) continue;
                                contains.add(c);
                                continue block1;
                            }
                        }
                        this._selectedKeys.removeAll(contains);
                    }
                }
                ArrayList<Set<JComponent>> removedFromList = new ArrayList<Set<JComponent>>();
                for (Set<JComponent> comps : this._compArrayList) {
                    removedArray.clear();
                    if (!comps.contains(comp)) continue;
                    for (JComponent c : comps) {
                        if (c.getBorder() != null && ComponentBorder.class.isAssignableFrom(c.getBorder().getClass())) {
                            c.setBorder(((ComponentBorder)ComponentBorder.class.cast(c.getBorder())).getOldBorder());
                        }
                        c.removeFocusListener(this._componentFocusListener);
                    }
                    removedFromList.add(comps);
                    ((MessageModel)this._messageTree.getModel()).removeMessageNodes(comps, removedArray);
                    this._msgList.removeAll(removedArray);
                }
                this._compArrayList.removeAll(removedFromList);
            }
            if (vMode && this._msgList.isEmpty()) {
                this._selectedKey = null;
                this._scrollPane.getViewport().setView(this._nvMsgDisplay);
                this.showNonValidationMsg();
            }
        }
    }

    @Override
    public void clearValidationMessages(MessageKey key) throws Exception {
        if (key == null) {
            throw new Exception("Illegal usage - use clearValidationMessages()");
        }
        if (!this._billboardMode) {
            boolean vMode = true;
            if (this._msgList.isEmpty()) {
                vMode = false;
            }
            Vector<Object> removedArray = new Vector<Object>();
            if (key != null) {
                if (vMode) {
                    LinkedHashSet temp;
                    if (this._selectedKey != null && LinkedHashSet.class.isAssignableFrom(this._selectedKey.getClass()) && !(temp = (LinkedHashSet)this._selectedKey).isEmpty()) {
                        for (Object object : temp) {
                            if (!MessageKey.class.isAssignableFrom(object.getClass()) || !key.equals((MessageKey)object)) continue;
                            this._selectedKey = null;
                        }
                    }
                    if (!this._selectedKeys.isEmpty()) {
                        ArrayList<Object> contains = new ArrayList<Object>();
                        block1: for (Object object : this._selectedKeys) {
                            LinkedHashSet temp2;
                            if (!LinkedHashSet.class.isAssignableFrom(object.getClass()) || (temp2 = (LinkedHashSet)object).isEmpty()) continue;
                            for (Object ob : temp2) {
                                if (!MessageKey.class.isAssignableFrom(ob.getClass()) || !key.equals((MessageKey)ob)) continue;
                                contains.add(object);
                                continue block1;
                            }
                        }
                        this._selectedKeys.removeAll(contains);
                    }
                }
                ArrayList<Set<MessageKey>> removeFromList = new ArrayList<Set<MessageKey>>();
                for (Set<MessageKey> set : this._keyArrayList) {
                    if (!set.contains(key)) continue;
                    removeFromList.add(set);
                }
                this._keyArrayList.removeAll(removeFromList);
                for (Set set : removeFromList) {
                    removedArray.clear();
                    ((MessageModel)this._messageTree.getModel()).removeMessageNodes(set, removedArray);
                    this._msgList.removeAll(removedArray);
                }
            }
            if (vMode && this._msgList.isEmpty()) {
                this._selectedKey = null;
                this._scrollPane.getViewport().setView(this._nvMsgDisplay);
                this.showNonValidationMsg();
            }
        }
    }

    @Override
    public void clearPanelValidationMessages() {
        if (!this._billboardMode) {
            boolean vMode = true;
            if (this._msgList.isEmpty()) {
                vMode = false;
            }
            Vector<Object> removedArray = new Vector<Object>();
            ((MessageModel)this._messageTree.getModel()).removeMessageNodes(null, removedArray);
            this._msgList.removeAll(removedArray);
            if (vMode && this._msgList.isEmpty()) {
                this._selectedKey = null;
                this._scrollPane.getViewport().setView(this._nvMsgDisplay);
                this.showNonValidationMsg();
            }
        }
    }

    @Override
    public void clearAllValidationMessages() {
        if (!this._billboardMode) {
            this._selectedKey = null;
            for (Set<JComponent> comps : this._compArrayList) {
                for (JComponent comp : comps) {
                    comp.removeFocusListener(this._componentFocusListener);
                    if (comp.getBorder() == null || !ComponentBorder.class.isAssignableFrom(comp.getBorder().getClass())) continue;
                    comp.setBorder(((ComponentBorder)ComponentBorder.class.cast(comp.getBorder())).getOldBorder());
                }
            }
            this._compArrayList.clear();
            this._keyArrayList.clear();
            ((MessageModel)this._messageTree.getModel()).removeAll();
            this._msgList.clear();
            this._scrollPane.getViewport().setView(this._nvMsgDisplay);
            this.showNonValidationMsg();
        }
    }

    @Override
    public void clearAllNonValidationMessages() {
        if (!this._billboardMode) {
            this._selectedKey = null;
            Component comp = null;
            for (Object key : this._nonValidationMsgMap.keySet()) {
                if (key != null && JComponent.class.isAssignableFrom(key.getClass())) {
                    comp = (JComponent)JComponent.class.cast(key);
                }
                if (comp == null) continue;
                comp.removeFocusListener(this._nonValidationFocusListener);
            }
            this._nonValidationMsgMap.clear();
            this.showNonValidationMsg();
        }
    }

    @Override
    public void clearMessagePanel() {
        this.clearAllValidationMessages();
        this.clearAllNonValidationMessages();
        this._selectedKeys.clear();
    }

    @Override
    public boolean hasValidationMessage(MessageType type) {
        for (ValidationMessageNode node : this._msgList) {
            if (type != null && !node.getType().equals((Object)type)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void setBillboard(String resource) {
        ImageIcon image = GUIUtilities.loadIcon((String)resource, (ClassLoader)MessagePanelImpl.class.getClassLoader());
        this._billboardImage.setImage(image.getImage());
    }

    @Override
    public void showBillboard(boolean show) {
        this._billboardMode = show;
        if (show) {
            this._scrollPane.getViewport().setView((Component)this._billboardImage);
        }
    }

    public JComponent getMessagePanel() {
        return this._scrollPane;
    }

    @Override
    public JComponent getMessageTree() {
        return this._messageTree;
    }

    @Override
    public void messageKeySelected(MessageKey messageKey, boolean isSelected) {
        if (isSelected) {
            this._selectedKey = messageKey;
            for (Set<MessageKey> keys : this._keyArrayList) {
                if (!keys.contains(messageKey)) continue;
                this._selectedKeys.add(keys);
            }
        } else {
            this._selectedKey = null;
            for (Set<MessageKey> keys : this._keyArrayList) {
                if (!keys.contains(messageKey)) continue;
                this._selectedKeys.remove(keys);
            }
        }
        ((MessageModel)this._messageTree.getModel()).refresh();
    }

    @Override
    public void addMessageSelectionListener(MessageSelectionListener l) {
        this._listenerList.add(l);
    }

    @Override
    public void removeMessageSelectionListener(MessageSelectionListener l) {
        this._listenerList.remove(l);
    }

    public boolean isBillboardMode() {
        return this._billboardMode;
    }

    private void loadIconMap() {
        this._iconMap = new HashMap<MessageType, ImageIcon>();
        this.insertIcon(ERROR_ICON, MessageType.ERROR);
        this.insertIcon(WARNING_ICON, MessageType.WARNING);
        this.insertIcon(PENDING_ICON, MessageType.INPROGRESS);
        this.insertIcon(SUCCESS_ICON, MessageType.SUCCESS);
    }

    private void insertIcon(String loc, MessageType type) {
        URL image = null;
        image = MessagePanelImpl.class.getClassLoader().getResource(loc);
        if (image != null) {
            this._iconMap.put(type, new ImageIcon(Toolkit.getDefaultToolkit().getImage(image)));
        }
    }

    private void showNonValidationMsg() {
        if (!this._selectedKeys.isEmpty()) {
            String text = "";
            for (Object key : this._selectedKeys) {
                NonValidationMessageNode node = this._nonValidationMsgMap.get(key);
                if (node == null) continue;
                text.concat(this.displayMsg(node));
            }
            this._nvMsgDisplay.setText(text);
        } else {
            NonValidationMessageNode node = this._nonValidationMsgMap.get(this._selectedKey);
            if (node == null) {
                this._nvMsgDisplay.setText("");
            } else {
                this._nvMsgDisplay.setText(this.displayMsg(node));
            }
        }
    }

    private String displayMsg(NonValidationMessageNode node) {
        this._nvMsgDisplay.setFocusable(true);
        this._nvMsgDisplay.setContentType("text/html");
        URL image = null;
        if (node.getType().equals((Object)MessageType.WARNING)) {
            image = MessagePanelImpl.class.getClassLoader().getResource(WARNING_ICON);
        }
        if (node.getType().equals((Object)MessageType.SUCCESS)) {
            image = MessagePanelImpl.class.getClassLoader().getResource(SUCCESS_ICON);
        }
        if (!node.getType().equals((Object)MessageType.INFORMATION)) {
            return MessageFormat.format(ResourceBundleManager.getString((String)"wizard-internal", (String)"MessagePanel.nonvalidation.message.html.wrapper"), node.getDetails(), image, this._labelFont.getFamily(), this._labelFont.getSize());
        }
        return MessageFormat.format(ResourceBundleManager.getString((String)"wizard-internal", (String)"MessagePanel.nonvalidation.information.message.html.wrapper"), node.getDetails(), this._labelFont.getFamily(), this._labelFont.getSize());
    }

    private class MessageTree
    extends JTree {
        private AccessibleMessageTree accTree;

        public MessageTree() {
            this.setAccTree(new AccessibleMessageTree());
        }

        @Override
        public boolean getScrollableTracksViewportWidth() {
            return true;
        }

        public AccessibleMessageTree getAccTree() {
            return this.accTree;
        }

        public void setAccTree(AccessibleMessageTree accTree) {
            this.accTree = accTree;
        }

        private class AccessibleMessageTree
        extends JTree.AccessibleJTree {
            private AccessibleMessageTree() {
                super(MessageTree.this);
            }

            @Override
            public void addAccessibleSelection(int i) {
                TreeModel model = MessagePanelImpl.this._messageTree.getModel();
                if (model != null && i == 0) {
                    ValidationMessageNode root = (ValidationMessageNode)model.getRoot();
                    if (root.getChildCount() > 0) {
                        Object[] objPath = new Object[]{root, root.getChildAt(i)};
                        TreePath path = new TreePath(objPath);
                        MessagePanelImpl.this._messageTree.addSelectionPath(path);
                    } else {
                        super.addAccessibleSelection(i);
                    }
                }
            }
        }
    }

    private class MessagePanelSelectionListener
    implements TreeSelectionListener {
        @Override
        public void valueChanged(TreeSelectionEvent e) {
            block13: {
                LinkedHashSet<MessageKey> keys;
                Object ob;
                MessageType maxType;
                ValidationMessageNode node;
                block14: {
                    Iterator<Object> it;
                    ArrayList<ValidationMessageNode> selectedNodes = new ArrayList<ValidationMessageNode>();
                    TreePath path = null;
                    if (e.getOldLeadSelectionPath() != null && (path = e.getOldLeadSelectionPath()).getPathCount() >= 2 && !(node = (ValidationMessageNode)path.getPathComponent(1)).getMessageKey().isEmpty()) {
                        maxType = this.getMessageType(node);
                        ob = null;
                        it = node.getMessageKey().iterator();
                        if (it.hasNext()) {
                            ob = it.next();
                        }
                        if (JComponent.class.isAssignableFrom(ob.getClass())) {
                            for (Object object : node.getMessageKey()) {
                                JComponent jComponent = (JComponent)JComponent.class.cast(object);
                                if (!selectedNodes.isEmpty() && ((ValidationMessageNode)selectedNodes.get(0)).getMessageKey().equals(node.getMessageKey()) || jComponent.getBorder() == null || !ComponentBorder.class.isAssignableFrom(jComponent.getBorder().getClass())) continue;
                                jComponent.setBorder(((ComponentBorder)ComponentBorder.class.cast(jComponent.getBorder())).getOldBorder());
                            }
                        } else if (MessageKey.class.isAssignableFrom(ob.getClass())) {
                            keys = new LinkedHashSet();
                            for (Object object : node.getMessageKey()) {
                                keys.add((MessageKey)MessageKey.class.cast(object));
                            }
                            MessageSelectionEvent messageSelectionEvent = new MessageSelectionEvent(MessagePanelImpl.this, keys, maxType, false);
                            for (MessageSelectionListener ml : MessagePanelImpl.this._listenerList) {
                                ml.messageSelected(messageSelectionEvent);
                            }
                        }
                    }
                    if (e.getNewLeadSelectionPath() == null || (path = e.getNewLeadSelectionPath()).getPathCount() < 2 || (node = (ValidationMessageNode)path.getPathComponent(1)).getMessageKey().isEmpty()) break block13;
                    maxType = this.getMessageType(node);
                    ob = null;
                    it = node.getMessageKey().iterator();
                    if (it.hasNext()) {
                        ob = it.next();
                    }
                    if (!JComponent.class.isAssignableFrom(ob.getClass())) break block14;
                    for (Object e2 : node.getMessageKey()) {
                        JComponent jComponent = (JComponent)JComponent.class.cast(e2);
                        selectedNodes.add(node);
                        if (jComponent.getBorder() != null && ComponentBorder.class.isAssignableFrom(jComponent.getBorder().getClass())) continue;
                        if (maxType.equals((Object)MessageType.ERROR)) {
                            jComponent.setBorder(new ComponentBorder(jComponent.getBorder(), GUIHelper.ERROR_COLOR, jComponent));
                            continue;
                        }
                        if (!maxType.equals((Object)MessageType.WARNING)) continue;
                        jComponent.setBorder(new ComponentBorder(jComponent.getBorder(), GUIHelper.WARNING_COLOR, jComponent));
                    }
                    break block13;
                }
                if (!MessageKey.class.isAssignableFrom(ob.getClass())) break block13;
                keys = new LinkedHashSet<MessageKey>();
                for (Object object : node.getMessageKey()) {
                    keys.add((MessageKey)MessageKey.class.cast(object));
                }
                MessageSelectionEvent messageSelectionEvent = new MessageSelectionEvent(MessagePanelImpl.this, keys, maxType, true);
                for (MessageSelectionListener ml : MessagePanelImpl.this._listenerList) {
                    ml.messageSelected(messageSelectionEvent);
                }
            }
        }

        private MessageType getMessageType(ValidationMessageNode node) {
            MessageType type = MessageType.INFORMATION;
            for (ValidationMessageNode temp : MessagePanelImpl.this._msgList) {
                if (temp.getMessageKey() == null || !temp.getMessageKey().equals(node.getMessageKey()) || temp.getType().compareTo(type) >= 0) continue;
                type = temp.getType();
            }
            return type;
        }
    }

    private class MessageModel
    extends DefaultTreeModel {
        public MessageModel() {
            super(new ValidationMessageNode());
        }

        public void insertMessageNode(ValidationMessageNode node, ValidationMessageNode child) {
            ValidationMessageNode root = (ValidationMessageNode)this.getRoot();
            Vector<ValidationMessageNode> children = root.getChildren();
            boolean flag = false;
            if (children.isEmpty()) {
                root.addChild(node);
                this.fireEvent(node, child);
                Object[] leadPath = new Object[]{root, node};
                MessagePanelImpl.this._messageTree.setLeadSelectionPath(new TreePath(leadPath));
                MessagePanelImpl.this._messageTree.getAccTree().addAccessibleSelection(0);
                return;
            }
            if (!children.contains(node)) {
                if (node.getMessageKey().isEmpty()) {
                    int i;
                    for (i = 0; i < children.size() && node.getMessageKey().isEmpty() && node.getType().compareTo(children.get(i).getType()) > 0; ++i) {
                    }
                    while (i < children.size() && node.getType().compareTo(children.get(i).getType()) == 0 && node.getMessage().compareTo(children.get(i).getMessage()) > 0) {
                        ++i;
                    }
                    root.addChild(i, node);
                    this.fireEvent(node, child);
                    Object[] leadPath = new Object[]{root, root.getChildAt(0)};
                    MessagePanelImpl.this._messageTree.setLeadSelectionPath(new TreePath(leadPath));
                    MessagePanelImpl.this._messageTree.getAccTree().addAccessibleSelection(0);
                    return;
                }
                for (int i = 0; i < children.size(); ++i) {
                    if (!node.getMessageKey().equals(children.get(i).getMessageKey())) continue;
                    flag = true;
                    while (i < children.size() && node.getMessageKey().equals(children.get(i).getMessageKey()) && node.getType().compareTo(children.get(i).getType()) > 0) {
                        ++i;
                    }
                    while (i < children.size() && node.getMessageKey().equals(children.get(i).getMessageKey()) && node.getType().compareTo(children.get(i).getType()) == 0 && node.getMessage().compareTo(children.get(i).getMessage()) > 0) {
                        ++i;
                    }
                    root.addChild(i, node);
                    this.fireEvent(node, child);
                    Object[] leadPath = new Object[]{root, root.getChildAt(0)};
                    MessagePanelImpl.this._messageTree.setLeadSelectionPath(new TreePath(leadPath));
                    MessagePanelImpl.this._messageTree.getAccTree().addAccessibleSelection(0);
                    return;
                }
                if (!flag) {
                    root.addChild(node);
                    this.fireEvent(node, child);
                    Object[] leadPath = new Object[]{root, root.getChildAt(0)};
                    MessagePanelImpl.this._messageTree.setLeadSelectionPath(new TreePath(leadPath));
                    MessagePanelImpl.this._messageTree.getAccTree().addAccessibleSelection(0);
                    return;
                }
            } else {
                return;
            }
        }

        public void removeMessageNodes(Object key, Vector<Object> removedArray) {
            int i;
            ValidationMessageNode root = (ValidationMessageNode)this.getRoot();
            Vector<ValidationMessageNode> children = root.getChildren();
            for (int i2 = 0; i2 < children.size(); ++i2) {
                ValidationMessageNode temp = children.elementAt(i2);
                if (key != null) {
                    if (temp.getMessageKey() == null || !temp.getMessageKey().equals(key)) continue;
                    removedArray.add(temp);
                    continue;
                }
                if (!temp.getMessageKey().isEmpty()) continue;
                removedArray.add(temp);
            }
            int[] childIndex = new int[removedArray.size()];
            for (i = 0; i < removedArray.size(); ++i) {
                childIndex[i] = root.getIndex((ValidationMessageNode)removedArray.get(i));
            }
            for (i = 0; i < removedArray.size(); ++i) {
                root.removeChild((ValidationMessageNode)removedArray.get(i));
            }
            this.nodesWereRemoved(root, childIndex, removedArray.toArray());
        }

        public void removeAll() {
            int i;
            ValidationMessageNode root = (ValidationMessageNode)this.getRoot();
            Vector<ValidationMessageNode> children = root.getChildren();
            Vector<ValidationMessageNode> removedArray = new Vector<ValidationMessageNode>();
            for (int i2 = 0; i2 < children.size(); ++i2) {
                removedArray.add(children.elementAt(i2));
            }
            int[] childIndex = new int[removedArray.size()];
            for (i = 0; i < removedArray.size(); ++i) {
                childIndex[i] = root.getIndex((ValidationMessageNode)removedArray.get(i));
            }
            for (i = 0; i < removedArray.size(); ++i) {
                root.removeChild((ValidationMessageNode)removedArray.get(i));
            }
            this.nodesWereRemoved(root, childIndex, removedArray.toArray());
        }

        public void refresh() {
            this.fireTreeNodesChanged(this, new Object[]{this.getRoot()}, null, null);
        }

        private void fireEvent(ValidationMessageNode node, ValidationMessageNode child) {
            int[] newIndex = new int[]{this.root.getIndex(node)};
            this.nodesWereInserted(this.root, newIndex);
            newIndex[0] = node.getIndex(child);
            this.nodesWereInserted(node, newIndex);
        }
    }

    private class MessageCellRenderer
    extends DefaultTreeCellRenderer {
        DetailsTextPane _details;
        boolean _isCompSelected;

        public MessageCellRenderer() {
            this.setLeafIcon(null);
            this.setClosedIcon(null);
            this.setOpenIcon(null);
            this._details = new DetailsTextPane();
            Style normalStyle = this._details.addStyle("normal", null);
            StyleConstants.setForeground(normalStyle, this.getTextNonSelectionColor());
            Style errorStyle = this._details.addStyle("error", null);
            StyleConstants.setForeground(errorStyle, GUIHelper.ERROR_COLOR);
            this._details.setEditable(false);
            this._details.setFocusable(true);
            this._details.setOpaque(true);
        }

        @Override
        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            Enum type = null;
            String accessibleName = "";
            Set<Object> messageKey = null;
            if (value != null) {
                accessibleName = value.toString();
                type = ((ValidationMessageNode)ValidationMessageNode.class.cast(value)).getType();
                messageKey = ((ValidationMessageNode)ValidationMessageNode.class.cast(value)).getMessageKey();
            }
            if (!leaf) {
                super.getTreeCellRendererComponent(tree, value, sel, expanded, leaf, row, hasFocus);
                if (type != null && type.equals((Object)MessageType.ERROR)) {
                    this.setForeground(GUIHelper.ERROR_COLOR);
                    this.putClientProperty("AccessibleName", ResourceBundleManager.getString((String)"wizard-internal", (String)"MessagePanel.accessibility.message.prefix.error") + accessibleName);
                } else if (type != null && type.equals((Object)MessageType.WARNING)) {
                    this.putClientProperty("AccessibleName", ResourceBundleManager.getString((String)"wizard-internal", (String)"MessagePanel.accessibility.message.prefix.warning") + accessibleName);
                } else {
                    this.putClientProperty("AccessibleName", accessibleName);
                }
                this._isCompSelected = MessagePanelImpl.this._selectedKey != null && messageKey == MessagePanelImpl.this._selectedKey || !MessagePanelImpl.this._selectedKeys.isEmpty() && MessagePanelImpl.this._selectedKeys.contains(messageKey);
                this.setBackground(this.getBackgroundNonSelectionColor());
                this.setFont(this.getFont().deriveFont(1));
                this.setIcon((Icon)MessagePanelImpl.this._iconMap.get(type));
                return this;
            }
            if (type != null && type.equals((Object)MessageType.ERROR)) {
                this._details.setForeground(GUIHelper.ERROR_COLOR);
                this._details.putClientProperty("AccessibleName", ResourceBundleManager.getString((String)"wizard-internal", (String)"MessagePanel.accessibility.message.prefix.error") + accessibleName);
            } else {
                if (type != null && type.equals((Object)MessageType.WARNING)) {
                    this._details.putClientProperty("AccessibleName", ResourceBundleManager.getString((String)"wizard-internal", (String)"MessagePanel.accessibility.message.prefix.warning") + accessibleName);
                } else {
                    this._details.putClientProperty("AccessibleName", accessibleName);
                }
                if (sel) {
                    this._details.setForeground(this.getTextSelectionColor());
                } else {
                    this._details.setForeground(this.getTextNonSelectionColor());
                }
            }
            this._details.setFont(MessagePanelImpl.this._labelFont);
            if (value != null) {
                StyledDocument doc = this._details.getStyledDocument();
                this._details.setText(value.toString());
                doc.setCharacterAttributes(0, doc.getLength(), this._details.getStyle(type != null && type.equals((Object)MessageType.ERROR) ? "error" : "normal"), true);
            }
            if (sel) {
                this._details.setBackground(this.getBackgroundSelectionColor());
            } else {
                this._details.setBackground(this.getBackgroundNonSelectionColor());
            }
            this._details._focus = hasFocus;
            this._details._selected = sel;
            return this._details;
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            return new Dimension(MessagePanelImpl.this._messageTree.getWidth() - MessagePanelImpl.this._indent, d.height);
        }

        @Override
        public Color getBackgroundNonSelectionColor() {
            if (this._isCompSelected) {
                return this.getBackgroundSelectionColor();
            }
            return super.getBackgroundNonSelectionColor();
        }

        private class DetailsTextPane
        extends JTextPane {
            boolean _focus;
            boolean _selected;

            DetailsTextPane() {
                this.setEditorKit(new StyledEditorKit(){
                    ViewFactory defaultFactory;
                    {
                        this.defaultFactory = new WrapColumnFactory();
                    }

                    @Override
                    public ViewFactory getViewFactory() {
                        return this.defaultFactory;
                    }
                });
            }

            @Override
            public Dimension getPreferredSize() {
                int nodeMaxWidth = MessagePanelImpl.this._messageTree.getWidth() - 2 * MessagePanelImpl.this._indent;
                this.setSize(nodeMaxWidth, Integer.MAX_VALUE);
                Dimension d = super.getPreferredSize();
                d.width = nodeMaxWidth;
                return d;
            }

            @Override
            public void paint(Graphics g) {
                super.paint(g);
                Color bColor = null;
                if (this._selected) {
                    bColor = MessageCellRenderer.this.getBackgroundSelectionColor();
                } else {
                    bColor = MessageCellRenderer.this.getBackgroundNonSelectionColor();
                    if (bColor == null) {
                        bColor = this.getBackground();
                    }
                }
                if (this._focus) {
                    Color bsColor = MessageCellRenderer.this.getBorderSelectionColor();
                    if (bsColor != null && this._selected) {
                        g.setColor(bsColor);
                    }
                    g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
                }
            }
        }
    }

    private class ValidationMessageNode
    implements TreeNode {
        private Set<Object> _messageKey;
        private String _message;
        private MessageType _type;
        private Vector<ValidationMessageNode> _children = new Vector();
        private ValidationMessageNode _parent;
        private boolean _leaf;

        private ValidationMessageNode() {
        }

        public Set<Object> getMessageKey() {
            return this._messageKey;
        }

        public void setMessageKey(Set<Object> key) {
            this._messageKey = key;
        }

        public String getMessage() {
            return this._message;
        }

        public void setMessage(String message) {
            this._message = message;
        }

        public MessageType getType() {
            return this._type;
        }

        public void setType(MessageType type) {
            this._type = type;
        }

        @Override
        public boolean isLeaf() {
            return this._leaf;
        }

        public void setLeaf(boolean leaf) {
            this._leaf = leaf;
        }

        @Override
        public TreeNode getParent() {
            return this._parent;
        }

        public void setParent(ValidationMessageNode parent) {
            this._parent = parent;
        }

        public Vector<ValidationMessageNode> getChildren() {
            return this._children;
        }

        public Enumeration children() {
            if (this._children == null) {
                return null;
            }
            return this._children.elements();
        }

        public void addChild(ValidationMessageNode node) {
            this._children.add(node);
        }

        public void addChild(int index, ValidationMessageNode node) {
            this._children.add(index, node);
        }

        public void removeChild(ValidationMessageNode node) {
            this._children.remove(node);
        }

        @Override
        public TreeNode getChildAt(int childIndex) {
            if (this._children == null) {
                throw new ArrayIndexOutOfBoundsException("node has no children");
            }
            return this._children.elementAt(childIndex);
        }

        @Override
        public boolean getAllowsChildren() {
            return !this.isLeaf();
        }

        @Override
        public int getChildCount() {
            if (this._children == null) {
                return 0;
            }
            return this._children.size();
        }

        @Override
        public int getIndex(TreeNode node) {
            if (!this._children.contains(node)) {
                return -1;
            }
            return this._children.indexOf(node);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this._messageKey == null ? 0 : this._messageKey.hashCode());
            result = 31 * result + (this._message == null ? 0 : this._message.hashCode());
            result = 31 * result + (this._type == null ? 0 : this._type.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ValidationMessageNode other = (ValidationMessageNode)obj;
            if (this._messageKey == null ? other._messageKey != null : !this._messageKey.equals(other._messageKey)) {
                return false;
            }
            if (this._message == null ? other._message != null : !this._message.equals(other._message)) {
                return false;
            }
            if (this._type == null ? other._type != null : !this._type.equals((Object)other._type)) {
                return false;
            }
            return !(this._children == null ? other._children != null : !this._children.equals(other._children));
        }

        public String toString() {
            return this.getMessage();
        }

        private MessagePanelImpl getOuterType() {
            return MessagePanelImpl.this;
        }
    }

    private class NonValidationMessageNode {
        private MessageType _type;
        private String _details;

        private NonValidationMessageNode() {
        }

        public MessageType getType() {
            return this._type;
        }

        public void setType(MessageType type) {
            this._type = type;
        }

        public String getDetails() {
            return this._details;
        }

        public void setDetails(String details) {
            this._details = details;
        }

        public String toString() {
            return this.getDetails();
        }
    }

    private class ComponentBorder
    extends LineBorder {
        private Border _oldBorder;
        private Insets _insets;

        public ComponentBorder(Border border, Color color, JComponent comp) {
            Insets oldBorderInsets;
            super(color);
            this._oldBorder = null;
            this._insets = null;
            this._oldBorder = border;
            this._insets = super.getBorderInsets(comp, new Insets(0, 0, 0, 0));
            Insets insets = oldBorderInsets = this._oldBorder == null ? null : this._oldBorder.getBorderInsets(comp);
            if (oldBorderInsets != null) {
                this._insets.top = Math.max(this._insets.top, oldBorderInsets.top);
                this._insets.bottom = Math.max(this._insets.bottom, oldBorderInsets.bottom);
                this._insets.left = Math.max(this._insets.left, oldBorderInsets.left);
                this._insets.right = Math.max(this._insets.right, oldBorderInsets.right);
            }
        }

        @Override
        public Insets getBorderInsets(Component comp) {
            return (Insets)this._insets.clone();
        }

        public Border getOldBorder() {
            return this._oldBorder;
        }
    }

    private static class WrapLabelView
    extends LabelView {
        public WrapLabelView(Element elem) {
            super(elem);
        }

        @Override
        public float getMinimumSpan(int axis) {
            switch (axis) {
                case 0: {
                    return 0.0f;
                }
                case 1: {
                    return super.getMinimumSpan(axis);
                }
            }
            throw new IllegalArgumentException("Invalid axis: " + axis);
        }
    }

    private class WrapColumnFactory
    implements ViewFactory {
        private WrapColumnFactory() {
        }

        @Override
        public View create(Element elem) {
            String kind = elem.getName();
            if (kind != null) {
                if (kind.equals("content")) {
                    return new WrapLabelView(elem);
                }
                if (kind.equals("paragraph")) {
                    return new ParagraphView(elem);
                }
                if (kind.equals("section")) {
                    return new BoxView(elem, 1);
                }
                if (kind.equals("component")) {
                    return new ComponentView(elem);
                }
                if (kind.equals("icon")) {
                    return new IconView(elem);
                }
            }
            return new LabelView(elem);
        }
    }
}

