/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.gui.components;

import com.oracle.cie.wizard.gui.components.SummaryTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.font.TextAttribute;
import java.util.Map;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellRenderer;

public class SummaryTreeCellRenderer
extends JPanel
implements TreeCellRenderer {
    private Font _boldFont;
    private Font _normalFont;
    private Font _italicFont;
    private JLabel _label;
    private JLabel _hyperLinklabel;
    private Color _defaultFGColor;

    public SummaryTreeCellRenderer() {
        this.setLayout(new BoxLayout(this, 0));
        this._label = new JLabel();
        this._normalFont = this._label.getFont();
        this._defaultFGColor = this._label.getForeground();
        this._boldFont = this._normalFont.deriveFont(1);
        this._italicFont = this._normalFont.deriveFont(2);
        this._hyperLinklabel = new HyperLinkLabel();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean sel, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        String stringValue = tree.convertValueToText(value, sel, expanded, leaf, row, hasFocus);
        this._label.setText(stringValue);
        this.setEnabled(tree.isEnabled());
        this.setComponentOrientation(tree.getComponentOrientation());
        this.getAccessibleContext().setAccessibleName(stringValue);
        if (value instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)value;
            if (node instanceof SummaryTreeNode) {
                SummaryTreeNode installerNode = (SummaryTreeNode)node;
                switch (installerNode.getFontType()) {
                    case BOLD: {
                        this._label.setFont(this._boldFont);
                        break;
                    }
                    case ITALIC: {
                        this._label.setFont(this._italicFont);
                        break;
                    }
                    case BOLD_AND_ITALIC: {
                        this._label.setFont(this._normalFont.deriveFont(3));
                        break;
                    }
                    default: {
                        this._label.setFont(this._normalFont);
                    }
                }
                this._label.setForeground(this.getColor(installerNode));
                this.add(this._label);
                if (installerNode.containsHyperlink()) {
                    this._label.setText(this._label.getText().replace(installerNode.getHyperLinkText(), ""));
                    this._hyperLinklabel.setText(installerNode.getHyperLinkText());
                    this.add(this._hyperLinklabel);
                } else if (this._hyperLinklabel != null) {
                    this.remove(this._hyperLinklabel);
                }
            } else {
                this.add(this._label);
                this.setFont(node.isRoot() ? this._boldFont : this._normalFont);
            }
        }
        return this;
    }

    private Color getColor(SummaryTreeNode node) {
        switch (node.getColor()) {
            case RED: {
                return Color.RED;
            }
            case BLUE: {
                return Color.BLUE;
            }
            case GREEN: {
                return Color.GREEN;
            }
        }
        return this._defaultFGColor;
    }

    public static final class HyperLinkLabel
    extends JLabel {
        HyperLinkLabel() {
            this.setForeground(Color.BLUE);
            Map<TextAttribute, ?> attributes = this.getFont().getAttributes();
            attributes.put(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON);
            this.setFont(this.getFont().deriveFont(attributes));
        }
    }
}

