/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.ext.panel;

import com.oracle.cie.wizard.ext.panel.AbstractSelectionComponentWrapper;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JRadioButton;

public class RadioButtonWrapper
extends AbstractSelectionComponentWrapper {
    private static Map<String, Set<ComponentPair>> _buttonGrouping = new HashMap<String, Set<ComponentPair>>();

    public RadioButtonWrapper(String labelName, String id, JRadioButton radioButton, String value, String workFlowProperty, boolean notifyComponents) {
        super(labelName, id, radioButton, workFlowProperty, notifyComponents);
        this.add(id, radioButton, value);
    }

    @Override
    public void setValue(Object obj) {
        Set<ComponentPair> pairs = _buttonGrouping.get(this._id);
        for (ComponentPair pair : pairs) {
            pair._button.setSelected(pair._value.equals(obj));
        }
    }

    @Override
    public Object getValue() {
        Set<ComponentPair> pairs = _buttonGrouping.get(this._id);
        for (ComponentPair pair : pairs) {
            if (!pair._button.isSelected()) continue;
            return pair._value;
        }
        return null;
    }

    private void add(String id, JRadioButton radioButton, String value) {
        if (_buttonGrouping.containsKey(id)) {
            _buttonGrouping.get(id).add(new ComponentPair(value, radioButton));
        } else {
            HashSet<ComponentPair> pairs = new HashSet<ComponentPair>();
            pairs.add(new ComponentPair(value, radioButton));
            _buttonGrouping.put(id, pairs);
        }
    }

    static void cleanOldButtonGroup(String id) {
        if (_buttonGrouping.containsKey(id)) {
            _buttonGrouping.remove(id);
        }
    }

    private static class ComponentPair {
        String _value;
        JRadioButton _button;

        ComponentPair(String value, JRadioButton button) {
            this._value = value;
            this._button = button;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this._button == null ? 0 : this._button.getText().hashCode());
            result = 31 * result + (this._value == null ? 0 : this._value.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ComponentPair other = (ComponentPair)obj;
            if (this._button == null ? other._button != null : !this._button.getText().equals(other._button.getText())) {
                return false;
            }
            return !(this._value == null ? other._value != null : !this._value.equals(other._value));
        }
    }
}

