/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard.ext.impl;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.wizard.ext.TaskHelper;
import com.oracle.cie.wizard.tasks.TaskContext;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DefaultTaskHelper
implements TaskHelper {
    private static final Logger _logger = Logger.getLogger(DefaultTaskHelper.class.getName());
    private TaskContext _context;

    public DefaultTaskHelper(TaskContext context) {
        this._context = context;
    }

    @Override
    public void setWorkFlowProperty(String name, String value) {
        if (StringUtil.isNullOrEmpty((String)name)) {
            throw new IllegalArgumentException("Can not set null or empty string as work-flow property.");
        }
        String oldValue = this.getWorkFlowProperty(name);
        if (!StringUtil.isNullOrEmpty((String)oldValue)) {
            _logger.log(Level.INFO, "Changing the work-flow property ('" + name + "') value (old-value='" + oldValue + "', new-value='" + value + "')");
        }
        this._context.setWorkflowProperty(name, value);
    }

    @Override
    public String getWorkFlowProperty(String name) {
        return this._context.getWorkflowProperty(name);
    }
}

