/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard;

public enum WizardState {
    CREATED,
    CONFIGURED,
    RUNNING,
    SUSPENDED,
    ERROR,
    SHUTTING_DOWN,
    CLEANUP,
    TERMINATED;


    public boolean isValidTransition(WizardState next) {
        switch (this) {
            case CREATED: {
                return next == CONFIGURED;
            }
            case CONFIGURED: {
                return next == RUNNING;
            }
            case RUNNING: {
                return next == SUSPENDED || next == ERROR || next == SHUTTING_DOWN;
            }
            case SUSPENDED: {
                return next == RUNNING || next == ERROR || next == SHUTTING_DOWN;
            }
            case ERROR: {
                return next == SHUTTING_DOWN;
            }
            case SHUTTING_DOWN: {
                return next == CLEANUP || next == TERMINATED;
            }
            case CLEANUP: {
                return next == TERMINATED;
            }
            case TERMINATED: {
                return false;
            }
        }
        return false;
    }
}

