/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.wizard;

import com.oracle.cie.wizard.ControllerProxy;
import com.oracle.cie.wizard.WizardCompletionInfo;
import com.oracle.cie.wizard.WizardConfiguration;
import com.oracle.cie.wizard.WizardConfigurationException;
import com.oracle.cie.wizard.WizardConfigurationLoader;
import com.oracle.cie.wizard.WizardEngine;
import com.oracle.cie.wizard.WizardException;
import com.oracle.cie.wizard.WizardState;
import java.util.Iterator;
import java.util.Map;
import java.util.ServiceLoader;

public final class WizardController {
    public static final String DEFAULT_WIZARD_THREAD_NAME = "WizardController";
    private static final String DEFAULT_WIZARD_CONFIG = "com.oracle.cie.wizard.internal.engine.DefaultWizardConfiguration";
    private static final String DEFAULT_WIZARD_ENGINE = "com.oracle.cie.wizard.internal.engine.WizardControllerEngine";
    protected WizardEngine _engine;
    protected boolean _isRunning;

    private WizardController(WizardConfiguration conf) throws WizardException {
        this._engine = WizardController.createWizardEngine(conf);
    }

    public ControllerProxy getControllerProxy() {
        return this._engine.getControllerProxy();
    }

    public Thread startWizard() throws WizardException {
        return this.startWizard(DEFAULT_WIZARD_THREAD_NAME);
    }

    public synchronized Thread startWizard(String threadName) throws WizardException {
        if (this._isRunning) {
            throw new WizardException("Wizard is already running!");
        }
        Thread wizardThread = new Thread((Runnable)this._engine, threadName);
        wizardThread.setDaemon(true);
        wizardThread.start();
        this._isRunning = true;
        return wizardThread;
    }

    public static void main(String[] args) throws WizardException {
        WizardConfigurationLoader conf = WizardController.createWizardConfiguration();
        conf.setCommandLineArguments(args);
        System.exit(WizardController.invokeWizardAndWait(conf));
    }

    public static WizardController createWizard(String[] args) throws WizardException {
        WizardConfigurationLoader conf = WizardController.createWizardConfiguration();
        conf.setCommandLineArguments(args);
        return new WizardController(conf);
    }

    public static WizardController createWizard(Map<String, String> options) throws WizardException {
        WizardConfigurationLoader conf = WizardController.createWizardConfiguration();
        conf.setOptions(options);
        return new WizardController(conf);
    }

    public static int invokeWizardAndWait(Map<String, String> options) throws WizardException {
        WizardConfigurationLoader conf = WizardController.createWizardConfiguration();
        conf.setOptions(options);
        return WizardController.invokeWizardAndWait(conf);
    }

    private static WizardConfigurationLoader createWizardConfiguration() throws WizardException {
        WizardConfigurationLoader loader = null;
        try {
            Iterator<WizardConfigurationLoader> iterator = ServiceLoader.load(WizardConfigurationLoader.class, WizardController.class.getClassLoader()).iterator();
            loader = iterator.hasNext() ? iterator.next() : (WizardConfigurationLoader)WizardConfigurationLoader.class.cast(Class.forName(DEFAULT_WIZARD_CONFIG).newInstance());
        }
        catch (Exception ex) {
            try {
                loader = (WizardConfigurationLoader)WizardConfigurationLoader.class.cast(Class.forName(DEFAULT_WIZARD_CONFIG).newInstance());
            }
            catch (Exception e) {
                throw new WizardException(e);
            }
        }
        return loader;
    }

    private static WizardEngine createWizardEngine(WizardConfiguration conf) throws WizardException {
        WizardEngine engine = null;
        try {
            engine = (WizardEngine)WizardEngine.class.cast(Class.forName(DEFAULT_WIZARD_ENGINE).newInstance());
        }
        catch (Exception e) {
            throw new WizardException(e);
        }
        engine.init(conf);
        return engine;
    }

    private static int invokeWizardAndWait(WizardConfiguration conf) {
        Integer returnCode = null;
        try {
            WizardController wiz = new WizardController(conf);
            ControllerProxy proxy = wiz.getControllerProxy();
            Thread t = wiz.startWizard();
            while (proxy.getState() != WizardState.TERMINATED) {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            returnCode = proxy.getReturnCode();
        }
        catch (WizardConfigurationException ex) {
            returnCode = ex.getReturnCode();
        }
        catch (WizardException wdx) {
            wdx.printStackTrace();
        }
        return returnCode != null ? returnCode.intValue() : WizardCompletionInfo.getInstance().getFatalErrorCode();
    }
}

