/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import com.oracle.cie.common.util.logging.CommandExecutionResult;
import com.oracle.cie.common.util.logging.LogFactory;
import com.oracle.cie.common.util.logging.LogStringUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Arrays;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class UnixLogFilePermissionHandler {
    public static void changeOwnership(String path) {
        File file = new File(path);
        try {
            UnixLogFilePermissionHandler.changeRootOwnership(file);
        }
        catch (IOException e) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Unable to change ownership:" + e));
        }
    }

    public static void changePermission(String path, String permission) {
        CommandExecutionResult result = UnixLogFilePermissionHandler.executeCommand(new String[]{"chmod", permission, path});
        int returnCode = result.getReturnCode();
        if (returnCode != 0) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Unable to change the permission :" + result.getErrorMessage()));
        }
    }

    public static void changeRootOwnership(File filePath) throws IOException {
        if (!filePath.exists()) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Skipping ownership modification call, file path:" + filePath + " doesnt exist."));
            return;
        }
        String user = UnixLogFilePermissionHandler.getOwnerName(filePath.getPath());
        if (!UnixLogFilePermissionHandler.hasRootPrivilege(user)) {
            LogFactory.addLogRecord(new LogRecord(Level.INFO, "No need to change file '" + filePath + "' ownership as its been owned by non root user:" + user));
            return;
        }
        Class<LogFactory> clazz = LogFactory.class;
        URL classResource = clazz.getResource('/' + clazz.getName().replace('.', '/') + ".class");
        File fileToUseForOwnership = null;
        if (classResource != null && classResource.getProtocol().equals("jar")) {
            URL u;
            File jarFile;
            String fileComponent = classResource.getFile();
            int classSeparatorIndex = fileComponent.lastIndexOf("!");
            if (classSeparatorIndex != -1) {
                fileComponent = fileComponent.substring(0, classSeparatorIndex);
            }
            if ((jarFile = new File((u = new URL(URLDecoder.decode(fileComponent = fileComponent.replaceAll("\\+", "%2B"), "UTF-8"))).getFile())).exists()) {
                fileToUseForOwnership = jarFile;
                user = UnixLogFilePermissionHandler.getOwnerName(fileToUseForOwnership.getPath());
            }
        }
        if (UnixLogFilePermissionHandler.hasRootPrivilege(user)) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Unable to change the " + filePath + " owner."));
            return;
        }
        LogFactory.addLogRecord(new LogRecord(Level.INFO, "Changing the file:" + filePath + " ownership from root to " + user));
        String group = UnixLogFilePermissionHandler.getOwnerGroup(fileToUseForOwnership.getPath());
        UnixLogFilePermissionHandler.setOwnerAndGroup(filePath.getPath(), user, group);
        LogFactory.addLogRecord(new LogRecord(Level.INFO, "Successfully updated the file " + filePath + " ownership and group to " + user + ":" + group));
    }

    public static boolean hasRootPrivilege(String user) {
        LogFactory.addLogRecord(new LogRecord(Level.FINEST, user != null ? "Checking if  user '" + user + "' has root privilege." : "Checking if current user has root privilege."));
        CommandExecutionResult result = user != null ? UnixLogFilePermissionHandler.executeCommand(new String[]{"id", "-u", user}) : UnixLogFilePermissionHandler.executeCommand(new String[]{"id", "-u"});
        String output = result.getMessage();
        if (LogStringUtil.isNotEmpty(output)) {
            LogFactory.addLogRecord(new LogRecord(Level.FINEST, "Userid=" + output.trim()));
            return output.trim().equals("0");
        }
        LogFactory.addLogRecord(new LogRecord(Level.FINEST, user == null ? "User dont have root privilege." : "User '" + user + "' dont have root privilege"));
        return false;
    }

    public static CommandExecutionResult executeCommand(String[] commands) {
        CommandExecutionResult exeReturn = new CommandExecutionResult(commands);
        int retValue = -1;
        String errMsg = "";
        String processingMessage = "";
        LogFactory.addLogRecord(new LogRecord(Level.INFO, "Executing command:" + Arrays.toString(commands)));
        try {
            Runtime runtime = Runtime.getRuntime();
            Process process = null;
            process = runtime.exec(commands);
            retValue = process.waitFor();
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            errMsg = UnixLogFilePermissionHandler.readStream(errorStream);
            processingMessage = UnixLogFilePermissionHandler.readStream(inputStream);
        }
        catch (Exception e) {
            errMsg = errMsg + e.getMessage();
        }
        exeReturn.setErrorMessage(errMsg);
        exeReturn.setMessage(processingMessage);
        exeReturn.setReturnCode(retValue);
        if (LogStringUtil.isNotEmpty(errMsg)) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Problem [" + errMsg + "] in executing the command:" + Arrays.toString(commands)));
        }
        LogFactory.addLogRecord(new LogRecord(Level.INFO, "Completed command execution with an exit code:" + retValue));
        return exeReturn;
    }

    private static String getOwnerName(String filePath) {
        String ownerName = null;
        CommandExecutionResult result = UnixLogFilePermissionHandler.executeCommand(new String[]{"stat", "-c", "%U", filePath});
        int returnCode = result.getReturnCode();
        if (returnCode != 0) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Unable to get the owner name of file " + filePath + " : " + result.getErrorMessage()));
        } else {
            ownerName = result.getMessage();
            if (LogStringUtil.isNotEmpty(ownerName)) {
                ownerName = ownerName.trim();
            }
            LogFactory.addLogRecord(new LogRecord(Level.FINE, "Current owner name of the file " + filePath + " is : " + ownerName));
        }
        return ownerName;
    }

    private static String getOwnerGroup(String filePath) {
        String ownerGroup = null;
        CommandExecutionResult result = UnixLogFilePermissionHandler.executeCommand(new String[]{"stat", "-c", "%G", filePath});
        int returnCode = result.getReturnCode();
        if (returnCode != 0) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Unable to get the owner group of file " + filePath + " : " + result.getErrorMessage()));
        } else {
            ownerGroup = result.getMessage();
            if (LogStringUtil.isNotEmpty(ownerGroup)) {
                ownerGroup = ownerGroup.trim();
            }
            LogFactory.addLogRecord(new LogRecord(Level.FINE, "Current owner group of the file " + filePath + " is : " + ownerGroup));
        }
        return ownerGroup;
    }

    private static void setOwnerAndGroup(String filePath, String ownerName, String ownerGroup) {
        CommandExecutionResult result = UnixLogFilePermissionHandler.executeCommand(new String[]{"chown", ownerName + ":" + ownerGroup, filePath});
        int returnCode = result.getReturnCode();
        if (returnCode != 0) {
            LogFactory.addLogRecord(new LogRecord(Level.WARNING, "Unable to set the owner name and group of file " + filePath + " : " + result.getErrorMessage()));
        } else {
            LogFactory.addLogRecord(new LogRecord(Level.FINE, "Succefully set owner name and  group of the file " + filePath));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String readStream(InputStreamReader inputStream) {
        StringBuffer sb = new StringBuffer();
        BufferedReader br = null;
        String line = "";
        try {
            br = new BufferedReader(inputStream);
            while ((line = br.readLine()) != null) {
                sb.append(line);
                sb.append("\n");
            }
        }
        catch (IOException e) {
            LogFactory.addLogRecord(new LogRecord(Level.FINEST, "Failed to read the command execution output" + e));
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException iOException) {}
            }
        }
        return sb.toString();
    }
}

