/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.common.util.logging;

import com.oracle.cie.common.util.logging.EnvironmentUtil;
import com.oracle.cie.common.util.logging.LogFactory;
import java.io.File;
import java.net.URL;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.LogRecord;

public class OldPropertySubstitutor {
    public boolean _debug = EnvironmentUtil.isDebugMode();

    public String substitute(String substProp, Properties properties) {
        StringBuilder rsltBuf = new StringBuilder();
        StringBuilder substBuf = new StringBuilder();
        boolean betweenBrackets = false;
        block4: for (char c : substProp.toCharArray()) {
            switch (c) {
                case '[': {
                    if (betweenBrackets) {
                        LogFactory.addLogRecord(new LogRecord(Level.WARNING, "WARNING - Nested brackets in substituted property:" + substProp));
                    }
                    betweenBrackets = true;
                    continue block4;
                }
                case ']': {
                    if (!betweenBrackets) {
                        LogFactory.addLogRecord(new LogRecord(Level.WARNING, "WARNING - Unmatching brackets in substituted property:" + substProp));
                    } else {
                        rsltBuf.append(this.substituteKey(substBuf.toString(), properties));
                        substBuf.delete(0, substBuf.length());
                    }
                    betweenBrackets = false;
                    continue block4;
                }
                default: {
                    if (betweenBrackets) {
                        substBuf.append(c);
                        continue block4;
                    }
                    rsltBuf.append(c);
                }
            }
        }
        if (this._debug) {
            LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG:  *** Substituted property = " + substProp + "=" + rsltBuf));
        }
        return rsltBuf.toString();
    }

    private String substituteKey(String substProp, Properties properties) {
        String details;
        if (substProp == null) {
            return "";
        }
        String[] parts = substProp.split(":", 2);
        String type = parts[0];
        String string = details = parts.length > 1 ? parts[1] : null;
        if ("PROP".equals(type)) {
            String value = details == null ? null : properties.getProperty(details);
            return value == null ? "" : value;
        }
        if ("ENV".equals(type)) {
            String value = details == null ? null : System.getenv(details);
            return value == null ? "" : value;
        }
        if ("DATE".equals(type)) {
            SimpleDateFormat sdf = new SimpleDateFormat(details == null ? "yyyyMMddHHmmss" : details);
            return sdf.format(new Date());
        }
        if ("CLASS_LOC".equals(type)) {
            String className;
            File location;
            block15: {
                location = null;
                className = details != null ? details : this.getClass().getName();
                String string2 = className = className.endsWith(".class") ? className : className.replace('.', '/') + ".class";
                if (this._debug) {
                    LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: determining class or jar containing directory for class " + className));
                }
                try {
                    URL classResource = this.getClass().getClassLoader().getResource(className);
                    if (classResource != null) {
                        String fileComponent = classResource.getFile();
                        if (classResource.getProtocol().equals("file")) {
                            int classFileIndex = fileComponent.lastIndexOf(className);
                            if (classFileIndex != -1) {
                                fileComponent = fileComponent.substring(0, classFileIndex);
                            }
                            fileComponent = fileComponent.replaceAll("\\+", "%2B");
                            location = new File(URLDecoder.decode(fileComponent, "UTF-8"));
                        } else if (classResource.getProtocol().equals("jar")) {
                            int classSeparatorIndex = fileComponent.lastIndexOf("!");
                            if (classSeparatorIndex != -1) {
                                fileComponent = fileComponent.substring(0, classSeparatorIndex);
                            }
                            fileComponent = fileComponent.replaceAll("\\+", "%2B");
                            URL u = new URL(URLDecoder.decode(fileComponent, "UTF-8"));
                            location = new File(u.getFile()).getParentFile();
                        }
                    }
                }
                catch (Exception e) {
                    if (!this._debug) break block15;
                    LogFactory.addLogRecord(new LogRecord(Level.WARNING, "LOG_DEBUG: unable to get class location: " + className + ":" + e));
                }
            }
            if (this._debug) {
                LogFactory.addLogRecord(new LogRecord(Level.INFO, "LOG_DEBUG: the class or jar containing directory for class " + className + " is " + location));
            }
            return location == null ? "" : location.getAbsolutePath();
        }
        return "";
    }
}

