/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest.wadl.provider;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.oracle.cie.common.util.IOUtil;
import com.oracle.cie.rest.ChecksumSearchResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;

@Provider
@Consumes(value={"application/vnd.org.jfrog.artifactory.search.ChecksumSearchResult+json"})
public class SearchChecksumSearchResult
implements MessageBodyReader<ChecksumSearchResult> {
    private static ObjectMapper mapper = new ObjectMapper();

    public boolean isReadable(Class arg, Type type, Annotation[] annotations, MediaType mediaType) {
        return "application".equalsIgnoreCase(mediaType.getType()) && "vnd.org.jfrog.artifactory.search.ChecksumSearchResult+json".equalsIgnoreCase(mediaType.getSubtype());
    }

    public ChecksumSearchResult readFrom(Class arg, Type type, Annotation[] annotations, MediaType mediaType, MultivaluedMap multivaluedMap, InputStream inputStream) throws IOException, WebApplicationException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        IOUtil.bufferedCopy((InputStream)inputStream, (OutputStream)baos);
        baos.close();
        return (ChecksumSearchResult)mapper.readValue(baos.toByteArray(), ChecksumSearchResultImpl.class);
    }

    public static class ChecksumSearchResultImpl
    extends HashMap
    implements ChecksumSearchResult {
        public static final String ARTIFACTORY_API = "/api/storage/";

        @Override
        public List<String> getResults() {
            ArrayList<String> uris = new ArrayList<String>();
            List results = (List)this.get("results");
            if (results != null && !results.isEmpty()) {
                for (Map map : results) {
                    String uri = (String)map.get("uri");
                    if (uri == null) continue;
                    uris.add(uri);
                }
            }
            return uris;
        }

        @Override
        public Map<String, String> getUriToRepoMap() {
            LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            List<String> uris = this.getResults();
            if (uris != null && !uris.isEmpty()) {
                for (String uri : uris) {
                    String repoName = "";
                    int i = uri.indexOf(ARTIFACTORY_API);
                    if (i > -1) {
                        repoName = uri.substring(i += ARTIFACTORY_API.length(), uri.indexOf("/", i));
                    }
                    map.put(uri, repoName);
                }
            }
            return map;
        }

        @Override
        public String toString() {
            return "" + this.getResults();
        }
    }
}

