/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.rest;

import com.oracle.cie.dependency.mgmt.Artifact;
import com.oracle.cie.dependency.mgmt.Version;
import com.oracle.cie.rest.ArtifactVersionsResult;
import com.oracle.cie.rest.Build;
import com.oracle.cie.rest.BuildInfo;
import com.oracle.cie.rest.Checksum;
import com.oracle.cie.rest.ChecksumSearchResult;
import com.oracle.cie.rest.FileInfo;
import com.oracle.cie.rest.FolderInfo;
import com.oracle.cie.rest.GavcSearchResult;
import com.oracle.cie.rest.MetadataSearchResult;
import com.oracle.cie.rest.Repository;
import com.oracle.cie.rest.RepositoryType;
import com.oracle.cie.rest.RestException;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public interface RestHandler {
    public static final String MD5_CHECKSUM_EXTENSION = ".md5";
    public static final String SHA1_CHECKSUM_EXTENSION = ".sha1";
    public static final String CHECKSUM_FILE_EXT = ".md5";
    public static final String LOCAL_ARTIFACT_PROPERTIES_FILE = ".artifact.properties";

    public Map<Artifact, File> retrieveArtifacts(Collection<Artifact> var1, List<Repository> var2, boolean var3, int var4) throws RestException, IOException;

    public Map<Artifact, File> retrieveArtifacts(Collection<Artifact> var1, List<Repository> var2, Repository var3, boolean var4, int var5) throws RestException, IOException;

    public File retrieveArtifact(Artifact var1, Repository var2, boolean var3) throws RestException, IOException;

    public File retrieveArtifact(Artifact var1, List<Repository> var2, boolean var3) throws RestException, IOException;

    public File retrieveArtifact(Artifact var1, Repository var2, Repository var3, boolean var4) throws RestException, IOException;

    public File retrieveArtifact(Artifact var1, List<Repository> var2, Repository var3, boolean var4) throws RestException, IOException;

    public FileInfo getFileInfo(Artifact var1, Repository var2) throws RestException, IOException;

    public FileInfo getFileInfo(Artifact var1, List<Repository> var2) throws RestException;

    public FolderInfo getFolderInfo(Repository var1, String var2) throws RestException, IOException;

    public FolderInfo getFolderInfo(Repository var1, String var2, boolean var3) throws RestException, IOException;

    public URI deployArtifact(Artifact var1, Repository var2, File var3) throws RestException, IOException;

    public URI deployArtifact(Artifact var1, Repository var2) throws RestException, IOException;

    public URI deployArtifact(Artifact var1, Repository var2, Repository var3) throws RestException, IOException;

    public URI deployArtifact(Artifact var1, Repository var2, Repository var3, File var4) throws RestException, IOException;

    public void verifyArtifact(Artifact var1, Repository var2) throws RestException, IOException;

    public void verifyArtifact(Artifact var1, File var2, Repository var3) throws IOException, RestException;

    public void verifyArtifact(Artifact var1, Repository var2, Repository var3) throws IOException, RestException;

    public void verifyArtifact(Artifact var1, File var2, Repository var3, Repository var4) throws IOException, RestException;

    public void verifyArtifact(Artifact var1, File var2, FileInfo var3, Repository var4, boolean var5) throws IOException, RestException;

    public File installArtifact(Artifact var1, File var2) throws RestException, IOException;

    public File installArtifact(Artifact var1, File var2, Repository var3) throws RestException, IOException;

    public Repository[] getRepositories(RepositoryType var1, String var2, String var3) throws RestException;

    public Repository[] getRepositories(RepositoryType var1, String var2, String var3, String var4) throws RestException;

    public boolean repositoryExists(Repository var1) throws RestException;

    public boolean artifactExists(Artifact var1, Repository var2) throws RestException;

    public boolean artifactExists(Artifact var1, List<Repository> var2) throws RestException;

    public void deleteArtifact(Artifact var1, Repository var2) throws RestException;

    public void deleteArtifact(Artifact var1, Repository var2, boolean var3) throws RestException;

    public byte[] getArchiveEntryContents(Artifact var1, String var2, List<Repository> var3) throws RestException;

    public byte[] getArchiveEntryContents(Artifact var1, String var2, Repository var3) throws RestException;

    public void copyArtifact(Artifact var1, Repository var2, Repository var3) throws RestException, IOException;

    public void copyArtifact(Artifact var1, Repository var2, Repository var3, boolean var4) throws RestException, IOException;

    public void copyArtifact(Artifact var1, Artifact var2, Repository var3, Repository var4) throws RestException, IOException;

    public void copyArtifact(Artifact var1, Artifact var2, Repository var3, Repository var4, boolean var5) throws RestException, IOException;

    public Properties getArtifactProperties(Artifact var1, List<Repository> var2) throws RestException;

    public Properties getArtifactProperties(Artifact var1, Repository var2) throws RestException;

    public void setArtifactProperties(Artifact var1, Repository var2, Properties var3) throws RestException;

    public void deleteArtifactProperties(Artifact var1, Repository var2, String ... var3) throws RestException;

    public Collection<String> getBuildNames(Repository var1) throws RestException;

    public Collection<Build> getBuilds(String var1, Repository var2) throws RestException;

    public BuildInfo getBuildInfo(Build var1, Repository var2) throws RestException;

    public void promoteBuild(Build var1, Repository var2, Repository var3, String var4, String var5, Properties var6, boolean var7, boolean var8) throws RestException;

    public void promoteBuild(Build var1, Repository var2, Repository var3, String var4, String var5, Properties var6, boolean var7, boolean var8, boolean var9) throws RestException;

    public void deleteBuild(Build var1, Repository var2, boolean var3) throws RestException;

    public ChecksumSearchResult checksumSearch(Checksum var1, Repository var2) throws RestException;

    public ArtifactVersionsResult artifactVersionsSearch(Artifact var1, Repository var2) throws RestException;

    public ArtifactVersionsResult artifactVersionsSearch(String var1, String var2, Repository var3) throws RestException;

    public Set<Version> artifactVersionsSearch(String var1, String var2, String var3, Repository var4, boolean var5) throws RestException;

    public Set<Version> artifactVersionsSearch(String var1, String var2, String var3, List<Repository> var4, boolean var5) throws RestException;

    public Version latestVersionSearch(String var1, String var2, String var3, Repository var4, boolean var5) throws RestException;

    public Version latestVersionSearch(String var1, String var2, String var3, List<Repository> var4) throws RestException;

    public MetadataSearchResult propertySearch(Properties var1, Repository var2) throws RestException;

    public MetadataSearchResult propertySearch(Properties var1, Repository var2, boolean var3) throws RestException;

    public GavcSearchResult gavcSearch(String var1, String var2, String var3, String var4, Repository var5) throws RestException;

    public GavcSearchResult gavcSearch(String var1, String var2, String var3, String var4, Repository var5, boolean var6) throws RestException;
}

