/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.remote.linux;

import com.oracle.cie.common.util.StringUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.List;

public class SSHLinuxFileTransferHandler {
    private static final String LOCAL_HOST = "localhost";

    public String getFileTransferCommandToRemote(String location, File sourceFile) throws UnknownHostException {
        String hostname = InetAddress.getLocalHost().getHostName();
        if (!StringUtil.isNullOrEmpty((String)hostname, (boolean)true) && (LOCAL_HOST.equals(hostname) || "127.0.0.1".equals(hostname))) {
            throw new UnknownHostException("Unable to identify the hostname, configured as " + hostname);
        }
        return "scp  -o FallBackToRsh=no -o PasswordAuthentication=no -o StrictHostKeyChecking=no -o NumberOfPasswordPrompts=0 " + System.getProperty("user.name") + "@" + hostname + ":" + sourceFile.getAbsolutePath() + " " + location;
    }

    public String getFileTransferCommandFromRemote(String location, File destinationFile) throws UnknownHostException {
        String hostname = InetAddress.getLocalHost().getHostName();
        if (!StringUtil.isNullOrEmpty((String)hostname, (boolean)true) && (LOCAL_HOST.equals(hostname) || "127.0.0.1".equals(hostname))) {
            throw new UnknownHostException("Unable to identify the hostname, configured as " + hostname);
        }
        return "scp  -o FallBackToRsh=no -o PasswordAuthentication=no -o StrictHostKeyChecking=no -o NumberOfPasswordPrompts=0 " + location + " " + System.getProperty("user.name") + "@" + hostname + ":" + destinationFile.getAbsolutePath();
    }

    public String getMakeDirCommand(String location, boolean recursive) {
        String command = "mkdir " + location;
        if (recursive) {
            command = "mkdir -p " + location;
        }
        return command;
    }

    public String getChmodCommand(String location, int mode) {
        return "chmod " + mode + " " + location;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeInputStreamToFile(File location, InputStream is) throws IOException {
        try (OutputStream os = null;){
            byte[] b = new byte[is.available()];
            is.read(b);
            os = new FileOutputStream(location);
            os.write(b);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void readFileToOutputStream(File location, OutputStream os) throws IOException {
        try (InputStream is = null;){
            byte[] b = new byte[(int)location.length()];
            is = new FileInputStream(location);
            is.read(b);
            os.write(b);
        }
    }

    public String getLSCommand(String location) {
        return "ls -1 " + location;
    }

    public List<String> getLSList(String lsOutput) {
        String[] files = lsOutput.split(System.lineSeparator());
        List<String> ls = Arrays.asList(files);
        return ls;
    }
}

