/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.remote.linux;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.linux.LinuxSSHUserEquivalenceConnHandlerImpl;
import com.oracle.cie.remote.linux.ReaderThread;
import java.io.File;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public final class LinuxCommandExecutionHelper {
    private static final String BIN_PATH = File.separator + "bin";
    private static final String USR_BIN_PATH = File.separator + "usr" + File.separator + "bin";
    private static final String USR_LOCAL_BIN_PATH = File.separator + "usr" + File.separator + "local" + File.separator + "bin";
    private static final String SSH_CMD = "ssh";
    private static final Logger _logger = Logger.getLogger(LinuxSSHUserEquivalenceConnHandlerImpl.class.getName());

    public static ExecReturn execute(List<String> cmds, Map<String, String> envVariable) {
        ExecReturn ret = new ExecReturn(cmds.toArray(new String[cmds.size()]));
        ProcessBuilder pb = new ProcessBuilder(cmds);
        if (envVariable != null && !envVariable.isEmpty()) {
            Map<String, String> currentEnv = pb.environment();
            Set<String> envKeyList = envVariable.keySet();
            for (String key : envKeyList) {
                currentEnv.put(key, envVariable.get(key));
            }
        }
        int retValue = -1;
        try {
            Process process = pb.start();
            InputStreamReader errorStream = new InputStreamReader(process.getErrorStream());
            InputStreamReader inputStream = new InputStreamReader(process.getInputStream());
            ReaderThread rerror = new ReaderThread(errorStream);
            ReaderThread rinput = new ReaderThread(inputStream);
            rinput.start();
            rerror.start();
            retValue = process.waitFor();
            try {
                rerror.join();
                rinput.join();
                ret.setNormalMessage(rinput.outputString);
                ret.setErrorMessage(rerror.outputString);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            ret.setReturnCode(retValue);
        }
        catch (Throwable t) {
            ret.setErrorMessage(t.getMessage());
            ret.setNormalMessage(t.getMessage());
            ret.setReturnCode(-1);
        }
        if (!StringUtil.isNullOrEmpty((String)ret.getErrorMessage(), (boolean)true)) {
            _logger.finest("Error message:" + ret.getErrorMessage());
        }
        _logger.finest("Output message:" + ret.getNormalMessage());
        _logger.finest("Return code: " + ret.getReturnCode());
        return ret;
    }

    public static String which(String cmd) {
        String cmdPath = "";
        ArrayList<String> cmds = new ArrayList<String>();
        cmds.add("which");
        cmds.add(cmd);
        try {
            ExecReturn ret = LinuxCommandExecutionHelper.execute(cmds, null);
            if (ret.isOK()) {
                cmdPath = ret.getNormalMessage();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return cmdPath;
    }

    public static String getSSHCmd() {
        String ssh = "";
        ssh = new File(BIN_PATH + File.separator + SSH_CMD).exists() ? BIN_PATH + File.separator + SSH_CMD : (new File(USR_BIN_PATH + File.separator + SSH_CMD).exists() ? USR_BIN_PATH + File.separator + SSH_CMD : (new File(USR_LOCAL_BIN_PATH + File.separator + SSH_CMD).exists() ? USR_LOCAL_BIN_PATH + File.separator + SSH_CMD : LinuxCommandExecutionHelper.which(SSH_CMD)));
        _logger.info("SSH path::" + ssh);
        return ssh;
    }

    public static class ExecReturn {
        private String[] systemCommand;
        private String errorMessage;
        private String normalMessage;
        private int retCode;
        private boolean ok;

        public ExecReturn(String[] cmd) {
            this.systemCommand = cmd;
            this.errorMessage = "";
            this.normalMessage = "";
            this.retCode = 0;
            this.ok = true;
        }

        public String getCommand() {
            if (this.systemCommand != null) {
                StringBuffer cmd = new StringBuffer();
                for (int i = 0; i < this.systemCommand.length; ++i) {
                    cmd.append(this.systemCommand[i]);
                    cmd.append("\n");
                }
                return cmd.toString();
            }
            return "Command not intialized";
        }

        public String getErrorMessage() {
            return this.errorMessage;
        }

        public String getNormalMessage() {
            return this.normalMessage;
        }

        public int getReturnCode() {
            return this.retCode;
        }

        public boolean isOK() {
            return this.ok;
        }

        protected void setErrorMessage(String msg) {
            this.errorMessage = msg;
        }

        protected void setNormalMessage(String msg) {
            this.normalMessage = msg;
        }

        protected void setReturnCode(int c) {
            this.retCode = c;
            this.ok = this.retCode == 0;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer("[GISystemCall.ExecReturn: ");
            buff.append("systemCommand= (");
            if (this.systemCommand == null) {
                buff.append("null");
            } else {
                for (int i = 0; i < this.systemCommand.length; ++i) {
                    String cmd = this.systemCommand[i];
                    if (cmd == null) continue;
                    buff.append("\"");
                    buff.append(cmd);
                    buff.append("\"");
                    if (i == this.systemCommand.length - 1) continue;
                    buff.append(", ");
                }
                buff.append(")");
            }
            buff.append(", errMsg= ");
            buff.append(this.errorMessage);
            buff.append(", normalMsg= ");
            buff.append(this.normalMessage);
            buff.append(", return code= ");
            buff.append(this.retCode);
            buff.append(", exec. ok= ");
            buff.append(this.ok);
            buff.append("]");
            return buff.toString();
        }
    }
}

