/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.remote;

import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.remote.RemoteConnectionException;
import com.oracle.cie.remote.RemoteConnectionHandler;
import com.oracle.cie.remote.RemoteConnectionHost;
import java.util.HashMap;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RemoteConnectionManager {
    private static final Logger _log = Logger.getLogger(RemoteConnectionManager.class.getName());
    private static Map<String, RemoteConnectionManager> _cachedManagers = new HashMap<String, RemoteConnectionManager>();
    private Map<String, RemoteConnectionHandler> _handlers;
    private Map<RemoteConnectionHost, RemoteConnectionHandler> _cachedHandlers = new HashMap<RemoteConnectionHost, RemoteConnectionHandler>();

    public static RemoteConnectionManager getRemoteConnectionManager() {
        return RemoteConnectionManager.getRemoteConnectionManager(null, null);
    }

    public static synchronized RemoteConnectionManager getRemoteConnectionManager(String cacheKey, ClassLoader classLoader) {
        RemoteConnectionManager manager;
        if (classLoader == null) {
            classLoader = RemoteConnectionManager.class.getClassLoader();
        }
        if (StringUtil.isNullOrEmpty((String)cacheKey, (boolean)true)) {
            cacheKey = classLoader.toString();
        }
        if ((manager = _cachedManagers.get(cacheKey)) == null) {
            manager = new RemoteConnectionManager(classLoader);
            _cachedManagers.put(cacheKey, manager);
        }
        return manager;
    }

    public static RemoteConnectionManager getCachedRemoteConnectionManager(String cacheKey) {
        return _cachedManagers.get(cacheKey);
    }

    public static void closeAll() {
        if (_cachedManagers != null && !_cachedManagers.isEmpty()) {
            for (RemoteConnectionManager manager : _cachedManagers.values()) {
                manager.closeAllHandlers();
            }
        }
    }

    private RemoteConnectionManager(ClassLoader classLoader) {
        this._handlers = new HashMap<String, RemoteConnectionHandler>();
        ServiceLoader<RemoteConnectionHandler> loader = ServiceLoader.load(RemoteConnectionHandler.class, classLoader);
        for (RemoteConnectionHandler handler : loader) {
            try {
                this._handlers.put(handler.getType(), handler);
            }
            catch (Exception e) {
                _log.log(Level.WARNING, "A failure occurred while attempting to load a remote connection handler.", e);
            }
        }
    }

    protected Map<String, RemoteConnectionHandler> getRemoteConnectionHandlers() {
        return this._handlers;
    }

    public synchronized RemoteConnectionHandler getRemoteConnectionHandler(RemoteConnectionHost host) throws RemoteConnectionException {
        RemoteConnectionHandler handler = this._cachedHandlers.get(host);
        if (handler == null) {
            handler = this.getRemoteConnectionHandlers().get(host.getRemoteConnectionType());
            if (handler == null) {
                throw new RemoteConnectionException("Unable to locate a remote connection handler for type " + host.getRemoteConnectionType());
            }
            try {
                handler = (RemoteConnectionHandler)handler.getClass().newInstance();
                handler.setHost(host);
            }
            catch (Exception e) {
                throw new RemoteConnectionException("Failed to create new instance of remote connection handler " + handler.getClass(), e);
            }
            this._cachedHandlers.put(host, handler);
        }
        return handler;
    }

    public void closeAllHandlers() {
        for (RemoteConnectionHandler handler : this._cachedHandlers.values()) {
            handler.close();
        }
    }
}

