/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.cie.dependency.mgmt.impl;

import com.oracle.cie.common.util.IObjectStore;
import com.oracle.cie.common.util.ObjectStoreManager;
import com.oracle.cie.common.util.StringUtil;
import com.oracle.cie.dependency.mgmt.Dependency;
import com.oracle.cie.dependency.mgmt.DependencyFileHandlerCallBack;
import com.oracle.cie.dependency.mgmt.DependencyFileType;
import com.oracle.cie.dependency.mgmt.DependencyManagementException;
import com.oracle.cie.dependency.mgmt.DependencyManagementFactory;
import com.oracle.cie.dependency.mgmt.Module;
import com.oracle.cie.dependency.mgmt.impl.AbstractDependencyFileHandler;
import com.oracle.cie.dependency.mgmt.impl.LegalInformationImpl;
import com.oracle.cie.dependency.mgmt.impl.VersionImpl;
import com.oracle.cie.dependency.mgmt.xml.mvn.DependencyManagement;
import com.oracle.cie.dependency.mgmt.xml.mvn.Model;
import com.oracle.cie.dependency.mgmt.xml.mvn.ObjectFactory;
import com.oracle.cie.dependency.mgmt.xml.mvn.Organization;
import com.oracle.cie.dependency.mgmt.xml.mvn.Parent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PomDependencyFileHandlerImpl
extends AbstractDependencyFileHandler {
    private static JAXBContext _contextReader;
    private static JAXBContext _contextWriter;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PomDependencyFileHandlerImpl() throws DependencyManagementException {
        Class<PomDependencyFileHandlerImpl> clazz = PomDependencyFileHandlerImpl.class;
        synchronized (PomDependencyFileHandlerImpl.class) {
            ClassLoader originalContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(PomDependencyFileHandlerImpl.class.getClassLoader());
                if (_contextReader == null) {
                    _contextReader = JAXBContext.newInstance((Class[])new Class[]{ObjectFactory.class});
                }
                if (_contextWriter == null) {
                    ObjectFactory objectFactory = new ObjectFactory();
                    Model mvnModel = objectFactory.createModel();
                    _contextWriter = JAXBContext.newInstance((String)mvnModel.getClass().getPackage().getName(), (ClassLoader)mvnModel.getClass().getClassLoader());
                }
            }
            catch (JAXBException e) {
                throw new DependencyManagementException(e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalContextClassLoader);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public DependencyFileType getType() {
        return DependencyFileType.pom;
    }

    @Override
    public Module readDependenciesFile(InputStream is, DependencyFileHandlerCallBack callBack) throws IOException, DependencyManagementException {
        Module module;
        if (is == null) {
            throw new DependencyManagementException("The input stream provided was null.");
        }
        try {
            Model.Dependencies mvnDeps;
            List<com.oracle.cie.dependency.mgmt.xml.mvn.Dependency> mvnDepsDeps;
            DependencyManagement.Dependencies depMgmtDeps;
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            docFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            docFactory.setExpandEntityReferences(false);
            docFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document document = docBuilder.parse(is);
            Unmarshaller unmarshaller = _contextReader.createUnmarshaller();
            Object o = unmarshaller.unmarshal((Node)document);
            if (o instanceof JAXBElement) {
                o = ((JAXBElement)o).getValue();
            }
            if (!(o instanceof Model)) {
                throw new DependencyManagementException("Parsed object was not the expected type.  Expected " + Model.class + " Actual:" + o.getClass());
            }
            Model mvnModel = (Model)o;
            String groupId = mvnModel.getGroupId();
            String artifactId = mvnModel.getArtifactId();
            String version = mvnModel.getVersion();
            String packaging = mvnModel.getPackaging();
            String name = mvnModel.getName();
            String description = mvnModel.getDescription();
            String url = mvnModel.getUrl();
            String inceptionYear = mvnModel.getInceptionYear();
            Organization organization = mvnModel.getOrganization();
            Model.Licenses licenses = mvnModel.getLicenses();
            Module parentModule = null;
            Parent parent = mvnModel.getParent();
            if (parent != null) {
                boolean atLeastOneOverridden = false;
                if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
                    groupId = parent.getGroupId();
                } else {
                    atLeastOneOverridden = true;
                }
                if (StringUtil.isNullOrEmpty((String)artifactId, (boolean)true)) {
                    artifactId = parent.getArtifactId();
                } else {
                    atLeastOneOverridden = true;
                }
                if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                    version = parent.getVersion();
                }
                if (!atLeastOneOverridden) {
                    throw new DependencyManagementException("The pom file specified is invalid because at least one of the groupId or artifactId parent values must be overridden.");
                }
                if (callBack != null) {
                    parentModule = callBack.loadParentModule(parent.getGroupId(), parent.getArtifactId(), parent.getVersion(), parent.getRelativePath());
                }
            }
            if (StringUtil.isNullOrEmpty((String)groupId, (boolean)true)) {
                throw new DependencyManagementException("The pom file specified is invalid due to missing groupId value.");
            }
            if (StringUtil.isNullOrEmpty((String)artifactId, (boolean)true)) {
                throw new DependencyManagementException("The pom file specified is invalid due to missing artifactId value.");
            }
            if (StringUtil.isNullOrEmpty((String)version, (boolean)true)) {
                throw new DependencyManagementException("The pom file specified is invalid due to missing version value.");
            }
            LegalInformationImpl legalInfo = new LegalInformationImpl();
            legalInfo.setDescription(description);
            legalInfo.setUrl(url);
            legalInfo.setInceptionYear(inceptionYear);
            legalInfo.setOrganization(organization);
            legalInfo.setLicenses(licenses);
            module = DependencyManagementFactory.getInstance().getModule(groupId, artifactId, version, packaging, legalInfo, new String[0]);
            module.setParent(parentModule);
            module.setModuleType(DependencyFileType.pom.name());
            IObjectStore objectStore = ObjectStoreManager.getObjectStore((String)module.getGroupIdNameVersionRepoPath());
            objectStore.storeObject((Object)"version", (Object)version);
            objectStore.storeObject((Object)"project.version", (Object)version);
            objectStore.storeObject((Object)"pom.version", (Object)version);
            objectStore.storeObject((Object)"project.name", (Object)name);
            objectStore.storeObject((Object)"pom.name", (Object)name);
            objectStore.storeObject((Object)"project.artifactId", (Object)artifactId);
            objectStore.storeObject((Object)"pom.artifactId", (Object)artifactId);
            objectStore.storeObject((Object)"project.groupId", (Object)groupId);
            objectStore.storeObject((Object)"pom.groupId", (Object)groupId);
            objectStore.storeObject((Object)"project.packaging", (Object)packaging);
            objectStore.storeObject((Object)"pom.packaging", (Object)packaging);
            objectStore.storeObject((Object)"project.description", (Object)description);
            objectStore.storeObject((Object)"pom.description", (Object)description);
            objectStore.storeObject((Object)"project.url", (Object)url);
            objectStore.storeObject((Object)"pom.url", (Object)url);
            objectStore.storeObject((Object)"project.inceptionYear", (Object)inceptionYear);
            objectStore.storeObject((Object)"pom.inceptionYear", (Object)inceptionYear);
            objectStore.storeObject((Object)"project.organization", (Object)organization);
            objectStore.storeObject((Object)"pom.organization", (Object)organization);
            objectStore.storeObject((Object)"project.licenses", (Object)licenses);
            objectStore.storeObject((Object)"pom.licenses", (Object)licenses);
            if (parent != null) {
                objectStore.storeObject((Object)"parent.version", (Object)parent.getVersion());
                objectStore.storeObject((Object)"project.parent.version", (Object)parent.getVersion());
                objectStore.storeObject((Object)"pom.parent.version", (Object)parent.getVersion());
                objectStore.storeObject((Object)"project.parent.artifactId", (Object)parent.getArtifactId());
                objectStore.storeObject((Object)"pom.parent.artifactId", (Object)parent.getArtifactId());
                objectStore.storeObject((Object)"project.parent.groupId", (Object)parent.getGroupId());
                objectStore.storeObject((Object)"pom.parent.groupId", (Object)parent.getGroupId());
            }
            if (parentModule != null) {
                ArrayList<Module> parentModules = new ArrayList<Module>();
                for (Module tmpParentModule = parentModule; tmpParentModule != null; tmpParentModule = tmpParentModule.getParent()) {
                    parentModules.add(tmpParentModule);
                }
                Collections.reverse(parentModules);
                for (Module module2 : parentModules) {
                    Properties parentProperties = module2.getProperties();
                    if (parentProperties == null || parentProperties.isEmpty()) continue;
                    for (String propertyName : parentProperties.stringPropertyNames()) {
                        objectStore.storeObject((Object)propertyName, (Object)parentProperties.getProperty(propertyName));
                    }
                }
                Properties parentProperties = parentModule.getProperties();
                if (parentProperties != null && !parentProperties.isEmpty()) {
                    for (String propertyName : parentProperties.stringPropertyNames()) {
                        objectStore.storeObject((Object)("project.parent." + propertyName), (Object)parentProperties.getProperty(propertyName));
                    }
                }
            }
            Properties properties = null;
            Model.Properties mvnModelProperties = mvnModel.getProperties();
            if (mvnModelProperties != null) {
                properties = new Properties();
                List<Element> propElements = mvnModelProperties.getAny();
                if (propElements != null) {
                    for (Element element : propElements) {
                        String propertyName = element.getTagName();
                        String propertyValue = this.substitute(element.getTextContent(), objectStore);
                        if (propertyValue == null) {
                            propertyValue = "";
                        }
                        objectStore.storeObject((Object)propertyName, (Object)propertyValue);
                        properties.setProperty(propertyName, propertyValue);
                    }
                }
            }
            module.setProperties(properties);
            ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
            DependencyManagement dependencyManagement = mvnModel.getDependencyManagement();
            if (dependencyManagement != null && (depMgmtDeps = dependencyManagement.getDependencies()) != null) {
                mvnDepsDeps = depMgmtDeps.getDependency();
                dependencies.addAll(this.createDependencies(mvnDepsDeps, true, objectStore));
            }
            if ((mvnDeps = mvnModel.getDependencies()) != null) {
                mvnDepsDeps = mvnDeps.getDependency();
                dependencies.addAll(this.createDependencies(mvnDepsDeps, false, objectStore));
            }
            if (!dependencies.isEmpty()) {
                module.setDependencies(dependencies);
            }
        }
        catch (JAXBException e) {
            throw new DependencyManagementException(e);
        }
        catch (ParserConfigurationException e) {
            throw new DependencyManagementException(e);
        }
        catch (SAXException e) {
            throw new DependencyManagementException(e);
        }
        return module;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private List<Dependency> createDependencies(List<com.oracle.cie.dependency.mgmt.xml.mvn.Dependency> deps, boolean dependencyManagement, IObjectStore objectStore) throws DependencyManagementException {
        ArrayList<Dependency> dependencies = new ArrayList<Dependency>();
        for (com.oracle.cie.dependency.mgmt.xml.mvn.Dependency mvnDep : deps) {
            String classifier;
            Boolean optional;
            Dependency dependency;
            String version;
            String groupId = this.substitute(mvnDep.getGroupId(), objectStore);
            String artifactId = this.substitute(mvnDep.getArtifactId(), objectStore);
            String type = this.substitute(mvnDep.getType(), objectStore);
            if (StringUtil.isNullOrEmpty((String)type, (boolean)true)) {
                type = "jar";
            }
            if (StringUtil.isNullOrEmpty((String)(version = mvnDep.getVersion()), (boolean)true)) {
                if (dependencyManagement) throw new DependencyManagementException("For artifact {" + groupId + ":" + artifactId + ":" + version + ":" + type + "}: The version cannot be empty.");
                dependency = DependencyManagementFactory.getInstance().getDependency(groupId, artifactId, new VersionImpl(), type);
            } else {
                version = this.substitute(version, objectStore);
                dependency = DependencyManagementFactory.getInstance().getDependency(groupId, artifactId, version, type);
            }
            String scope = mvnDep.getScope();
            if (!StringUtil.isNullOrEmpty((String)scope, (boolean)true)) {
                dependency.setScope(this.substitute(scope, objectStore));
            }
            if ((optional = mvnDep.isOptional()) != null && mvnDep.isOptional().booleanValue()) {
                dependency.setOptional(true);
            }
            if (!StringUtil.isNullOrEmpty((String)(classifier = mvnDep.getClassifier()), (boolean)true)) {
                dependency.setClassifier(this.substitute(classifier, objectStore));
            }
            dependency.setDependencyManagement(dependencyManagement);
            dependencies.add(dependency);
        }
        return dependencies;
    }

    private String substitute(String value, IObjectStore objectStore) {
        return value != null ? objectStore.substitute(value, "${", "}", true) : null;
    }

    @Override
    public void writeDependenciesFile(Module module, OutputStream os) throws IOException, DependencyManagementException {
        Properties properties;
        List<Dependency> dependencies;
        if (module == null) {
            throw new DependencyManagementException("The module provided was null.");
        }
        if (os == null) {
            throw new DependencyManagementException("The output stream provided was null.");
        }
        ObjectFactory objectFactory = new ObjectFactory();
        Model mvnModel = objectFactory.createModel();
        JAXBElement<Model> jaxbProject = objectFactory.createProject(mvnModel);
        mvnModel.setModelVersion("4.0.0");
        mvnModel.setGroupId(module.getGroup());
        mvnModel.setArtifactId(module.getName());
        mvnModel.setVersion(module.getVersionString());
        mvnModel.setDescription(module.getLegalInformation().getDescription());
        mvnModel.setUrl(module.getLegalInformation().getUrl());
        mvnModel.setInceptionYear(module.getLegalInformation().getInceptionYear());
        mvnModel.setOrganization(module.getLegalInformation().getOrganization());
        mvnModel.setLicenses(module.getLegalInformation().getLicenses());
        if (module.isPackagingTypeSet()) {
            mvnModel.setPackaging(module.getType());
        }
        if ((dependencies = module.getDependencies()) != null && !dependencies.isEmpty()) {
            List<com.oracle.cie.dependency.mgmt.xml.mvn.Dependency> mvnDepsCreated = this.createMavenDependencies(dependencies, false);
            if (!mvnDepsCreated.isEmpty()) {
                Model.Dependencies mvnDeps = new Model.Dependencies();
                mvnModel.setDependencies(mvnDeps);
                List<com.oracle.cie.dependency.mgmt.xml.mvn.Dependency> mvnDepsDeps = mvnDeps.getDependency();
                mvnDepsDeps.addAll(mvnDepsCreated);
            }
            if (!(mvnDepsCreated = this.createMavenDependencies(dependencies, true)).isEmpty()) {
                DependencyManagement depMgmt = new DependencyManagement();
                mvnModel.setDependencyManagement(depMgmt);
                DependencyManagement.Dependencies depMgmtDeps = new DependencyManagement.Dependencies();
                depMgmt.setDependencies(depMgmtDeps);
                List<com.oracle.cie.dependency.mgmt.xml.mvn.Dependency> mvnDepsDeps = depMgmtDeps.getDependency();
                mvnDepsDeps.addAll(mvnDepsCreated);
            }
        }
        if ((properties = module.getProperties()) != null) {
            Model.Properties mvnModelProperties = objectFactory.createModelProperties();
            mvnModel.setProperties(mvnModelProperties);
            if (!properties.isEmpty()) {
                DocumentBuilder docBuilder;
                DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
                try {
                    docBuilder = docFactory.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new DependencyManagementException(e);
                }
                List<Element> propElements = mvnModelProperties.getAny();
                for (String propertyName : properties.stringPropertyNames()) {
                    String propertyValue = properties.getProperty(propertyName);
                    Element element = docBuilder.newDocument().createElementNS(jaxbProject.getName().getNamespaceURI(), propertyName);
                    element.setTextContent(propertyValue);
                    propElements.add(element);
                }
            }
        }
        try {
            Marshaller marshaller = _contextWriter.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)true);
            marshaller.marshal(jaxbProject, os);
        }
        catch (JAXBException e) {
            throw new DependencyManagementException(e);
        }
    }

    private List<com.oracle.cie.dependency.mgmt.xml.mvn.Dependency> createMavenDependencies(List<Dependency> dependencies, boolean dependencyManagement) {
        ArrayList<com.oracle.cie.dependency.mgmt.xml.mvn.Dependency> mvnDepsDeps = new ArrayList<com.oracle.cie.dependency.mgmt.xml.mvn.Dependency>();
        for (Dependency dependency : dependencies) {
            String scope;
            if (dependencyManagement != dependency.isDependencyManagement()) continue;
            com.oracle.cie.dependency.mgmt.xml.mvn.Dependency mvnDep = new com.oracle.cie.dependency.mgmt.xml.mvn.Dependency();
            mvnDep.setGroupId(dependency.getGroup());
            mvnDep.setArtifactId(dependency.getName());
            mvnDep.setVersion(dependency.getVersionString());
            mvnDep.setType(dependency.getType());
            String classifier = dependency.getClassifier();
            if (!StringUtil.isNullOrEmpty((String)classifier, (boolean)true)) {
                mvnDep.setClassifier(classifier);
            }
            if (!StringUtil.isNullOrEmpty((String)(scope = dependency.getScope()), (boolean)true)) {
                mvnDep.setScope(scope);
            }
            if (dependency.isOptional()) {
                mvnDep.setOptional(Boolean.TRUE);
            }
            mvnDepsDeps.add(mvnDep);
        }
        return mvnDepsDeps;
    }
}

